/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.codec;

import com.github.steveice10.opennbt.tag.builtin.ByteArrayTag;
import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.DoubleTag;
import com.github.steveice10.opennbt.tag.builtin.FloatTag;
import com.github.steveice10.opennbt.tag.builtin.IntArrayTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.LongArrayTag;
import com.github.steveice10.opennbt.tag.builtin.LongTag;
import com.github.steveice10.opennbt.tag.builtin.ShortTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LazilyParsedNumber;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class NbtComponentSerializer {
    private static final Set<String> BOOLEAN_TYPES = new HashSet<String>(Arrays.asList("interpret", "bold", "italic", "underlined", "strikethrough", "obfuscated"));
    private static final List<Pair<String, String>> COMPONENT_TYPES = Arrays.asList(new Pair<String, String>("text", "text"), new Pair<String, String>("translatable", "translate"), new Pair<String, String>("score", "score"), new Pair<String, String>("selector", "selector"), new Pair<String, String>("keybind", "keybind"), new Pair<String, String>("nbt", "nbt"));

    private NbtComponentSerializer() {
    }

    @Contract(value="null -> null")
    public static JsonElement tagComponentToJson(@Nullable Tag tag) {
        return NbtComponentSerializer.convertToJson(null, tag);
    }

    @Nullable
    public static Tag jsonComponentToTag(@Nullable JsonElement component) {
        return NbtComponentSerializer.convertToTag("", component);
    }

    @Contract(value="_, null -> null")
    private static Tag convertToTag(String name, @Nullable JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        if (element.isJsonObject()) {
            CompoundTag tag = new CompoundTag(name);
            JsonObject jsonObject = element.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                NbtComponentSerializer.convertObjectEntry((String)entry.getKey(), (JsonElement)entry.getValue(), tag);
            }
            NbtComponentSerializer.addComponentType(jsonObject, tag);
            return tag;
        }
        if (element.isJsonArray()) {
            return NbtComponentSerializer.convertJsonArray(name, element.getAsJsonArray());
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                return new StringTag(name, primitive.getAsString());
            }
            if (primitive.isBoolean()) {
                return new ByteTag(name, (byte)(primitive.getAsBoolean() ? 1 : 0));
            }
            Number number = primitive.getAsNumber();
            if (number instanceof Integer) {
                return new IntTag(name, number.intValue());
            }
            if (number instanceof Byte) {
                return new ByteTag(name, number.byteValue());
            }
            if (number instanceof Short) {
                return new ShortTag(name, number.shortValue());
            }
            if (number instanceof Long) {
                return new LongTag(name, number.longValue());
            }
            if (number instanceof Double) {
                return new DoubleTag(name, number.doubleValue());
            }
            if (number instanceof Float) {
                return new FloatTag(name, number.floatValue());
            }
            if (number instanceof LazilyParsedNumber) {
                return new IntTag(name, number.intValue());
            }
            return new IntTag(name, number.intValue());
        }
        throw new IllegalArgumentException("Unhandled json type " + element.getClass().getSimpleName() + " with value " + element.getAsString());
    }

    private static ListTag convertJsonArray(String name, JsonArray array) {
        ListTag listTag = new ListTag(name);
        boolean singleType = true;
        for (JsonElement entry : array) {
            Tag convertedEntryTag = NbtComponentSerializer.convertToTag("", entry);
            if (listTag.getElementType() != null && listTag.getElementType() != convertedEntryTag.getClass()) {
                singleType = false;
                break;
            }
            listTag.add(convertedEntryTag);
        }
        if (singleType) {
            return listTag;
        }
        ListTag processedListTag = new ListTag(name);
        for (JsonElement entry : array) {
            Tag convertedTag = NbtComponentSerializer.convertToTag("", entry);
            if (convertedTag instanceof CompoundTag) {
                processedListTag.add(convertedTag);
                continue;
            }
            CompoundTag compoundTag = new CompoundTag("");
            compoundTag.put(new StringTag("type", "text"));
            if (convertedTag instanceof ListTag) {
                compoundTag.put(new StringTag("text"));
                compoundTag.put(new ListTag("extra", (List<Tag>)((ListTag)convertedTag).getValue()));
            } else {
                compoundTag.put(new StringTag("text", NbtComponentSerializer.stringValue(convertedTag)));
            }
            processedListTag.add(compoundTag);
        }
        return processedListTag;
    }

    private static void convertObjectEntry(String key, JsonElement value, CompoundTag tag) {
        UUID uuid;
        JsonObject hoverEvent;
        JsonElement id;
        if (key.equals("contents") && value.isJsonObject() && (id = (hoverEvent = value.getAsJsonObject()).get("id")) != null && id.isJsonPrimitive() && (uuid = NbtComponentSerializer.parseUUID(id.getAsString())) != null) {
            hoverEvent.remove("id");
            CompoundTag convertedTag = (CompoundTag)NbtComponentSerializer.convertToTag(key, value);
            convertedTag.put(new IntArrayTag("id", NbtComponentSerializer.toIntArray(uuid)));
            tag.put(convertedTag);
            return;
        }
        tag.put(NbtComponentSerializer.convertToTag(key, value));
    }

    private static void addComponentType(JsonObject object, CompoundTag tag) {
        if (object.has("type")) {
            return;
        }
        for (Pair<String, String> pair : COMPONENT_TYPES) {
            if (!object.has((String)((Pair)pair).value)) continue;
            tag.put(new StringTag("type", (String)((Pair)pair).key));
            return;
        }
    }

    @Nullable
    private static JsonElement convertToJson(@Nullable String key, @Nullable Tag tag) {
        if (tag == null) {
            return null;
        }
        if (tag instanceof CompoundTag) {
            JsonObject object = new JsonObject();
            if (!"value".equals(key)) {
                NbtComponentSerializer.removeComponentType(object);
            }
            for (Tag entry : (CompoundTag)tag) {
                NbtComponentSerializer.convertCompoundTagEntry(entry.getName(), entry, object);
            }
            return object;
        }
        if (tag instanceof ListTag) {
            ListTag list = (ListTag)tag;
            JsonArray array = new JsonArray();
            for (Tag listEntry : list) {
                array.add(NbtComponentSerializer.convertToJson(null, listEntry));
            }
            return array;
        }
        if (tag.getValue() instanceof Number) {
            Number number = (Number)tag.getValue();
            if (key != null && BOOLEAN_TYPES.contains(key)) {
                return new JsonPrimitive(Boolean.valueOf(number.byteValue() != 0));
            }
            return new JsonPrimitive(number);
        }
        if (tag instanceof StringTag) {
            return new JsonPrimitive(((StringTag)tag).getValue());
        }
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag arrayTag = (ByteArrayTag)tag;
            JsonArray array = new JsonArray();
            for (byte num : arrayTag.getValue()) {
                array.add((Number)num);
            }
            return array;
        }
        if (tag instanceof IntArrayTag) {
            IntArrayTag arrayTag = (IntArrayTag)tag;
            JsonArray array = new JsonArray();
            for (int num : arrayTag.getValue()) {
                array.add((Number)num);
            }
            return array;
        }
        if (tag instanceof LongArrayTag) {
            LongArrayTag arrayTag = (LongArrayTag)tag;
            JsonArray array = new JsonArray();
            for (long num : arrayTag.getValue()) {
                array.add((Number)num);
            }
            return array;
        }
        throw new IllegalArgumentException("Unhandled tag type " + tag.getClass().getSimpleName());
    }

    private static void convertCompoundTagEntry(String key, Tag tag, JsonObject object) {
        CompoundTag showEntity;
        Object idTag;
        if (key.equals("contents") && tag instanceof CompoundTag && (idTag = (showEntity = (CompoundTag)tag).get("id")) instanceof IntArrayTag) {
            showEntity.remove("id");
            JsonObject convertedElement = (JsonObject)NbtComponentSerializer.convertToJson(key, tag);
            UUID uuid = NbtComponentSerializer.fromIntArray(((IntArrayTag)idTag).getValue());
            convertedElement.addProperty("id", uuid.toString());
            object.add(key, (JsonElement)convertedElement);
            return;
        }
        object.add(key.isEmpty() ? "text" : key, NbtComponentSerializer.convertToJson(key, tag));
    }

    private static void removeComponentType(JsonObject object) {
        JsonElement type = object.remove("type");
        if (type == null || !type.isJsonPrimitive()) {
            return;
        }
        String typeString = type.getAsString();
        for (Pair<String, String> pair : COMPONENT_TYPES) {
            if (((String)((Pair)pair).key).equals(typeString)) continue;
            object.remove((String)((Pair)pair).value);
        }
    }

    public static UUID fromIntArray(int[] parts) {
        if (parts.length != 4) {
            return new UUID(0L, 0L);
        }
        return new UUID((long)parts[0] << 32 | (long)parts[1] & 0xFFFFFFFFL, (long)parts[2] << 32 | (long)parts[3] & 0xFFFFFFFFL);
    }

    public static int[] toIntArray(UUID uuid) {
        return NbtComponentSerializer.toIntArray(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static int[] toIntArray(long msb, long lsb) {
        return new int[]{(int)(msb >> 32), (int)msb, (int)(lsb >> 32), (int)lsb};
    }

    @Nullable
    public static UUID parseUUID(String uuidString) {
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static String stringValue(Tag tag) {
        if (tag instanceof ByteArrayTag) {
            return Arrays.toString(((ByteArrayTag)tag).getValue());
        }
        if (tag instanceof ByteTag) {
            return Byte.toString(((ByteTag)tag).getValue());
        }
        if (tag instanceof DoubleTag) {
            return Double.toString(((DoubleTag)tag).getValue());
        }
        if (tag instanceof FloatTag) {
            return Float.toString(((FloatTag)tag).getValue().floatValue());
        }
        if (tag instanceof IntArrayTag) {
            return Arrays.toString(((IntArrayTag)tag).getValue());
        }
        if (tag instanceof IntTag) {
            return Integer.toString(((IntTag)tag).getValue());
        }
        if (tag instanceof LongArrayTag) {
            return Arrays.toString(((LongArrayTag)tag).getValue());
        }
        if (tag instanceof LongTag) {
            return Long.toString(((LongTag)tag).getValue());
        }
        if (tag instanceof ShortTag) {
            return Short.toString(((ShortTag)tag).getValue());
        }
        if (tag instanceof StringTag) {
            return ((StringTag)tag).getValue();
        }
        return tag.getValue().toString();
    }

    private static class Pair<K, V> {
        private final K key;
        private final V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

