/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.type.EntityType;
import com.github.steveice10.mc.protocol.data.game.statistic.BreakBlockStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.BreakItemStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.CraftItemStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.CustomStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.DropItemStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.KillEntityStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.KilledByEntityStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.PickupItemStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.Statistic;
import com.github.steveice10.mc.protocol.data.game.statistic.StatisticCategory;
import com.github.steveice10.mc.protocol.data.game.statistic.UseItemStatistic;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;

public class ClientboundAwardStatsPacket
implements MinecraftPacket {
    @NonNull
    private final Object2IntMap<Statistic> statistics = new Object2IntOpenHashMap<Statistic>();

    public ClientboundAwardStatsPacket(ByteBuf in, MinecraftCodecHelper helper) {
        int length = helper.readVarInt(in);
        for (int index = 0; index < length; ++index) {
            Statistic statistic;
            StatisticCategory category = helper.readStatisticCategory(in);
            int statisticId = helper.readVarInt(in);
            switch (category) {
                case BREAK_BLOCK: {
                    statistic = new BreakBlockStatistic(statisticId);
                    break;
                }
                case CRAFT_ITEM: {
                    statistic = new CraftItemStatistic(statisticId);
                    break;
                }
                case USE_ITEM: {
                    statistic = new UseItemStatistic(statisticId);
                    break;
                }
                case BREAK_ITEM: {
                    statistic = new BreakItemStatistic(statisticId);
                    break;
                }
                case PICKED_UP_ITEM: {
                    statistic = new PickupItemStatistic(statisticId);
                    break;
                }
                case DROP_ITEM: {
                    statistic = new DropItemStatistic(statisticId);
                    break;
                }
                case KILL_ENTITY: {
                    statistic = new KillEntityStatistic(EntityType.from(statisticId));
                    break;
                }
                case KILLED_BY_ENTITY: {
                    statistic = new KilledByEntityStatistic(EntityType.from(statisticId));
                    break;
                }
                case CUSTOM: {
                    statistic = CustomStatistic.from(statisticId);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.statistics.put(statistic, helper.readVarInt(in));
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.statistics.size());
        for (Object2IntMap.Entry entry : this.statistics.object2IntEntrySet()) {
            int statisticId;
            StatisticCategory category;
            Statistic statistic = (Statistic)entry.getKey();
            if (statistic instanceof BreakBlockStatistic) {
                category = StatisticCategory.BREAK_BLOCK;
                statisticId = ((BreakBlockStatistic)statistic).getId();
            } else if (statistic instanceof CraftItemStatistic) {
                category = StatisticCategory.CRAFT_ITEM;
                statisticId = ((CraftItemStatistic)statistic).getId();
            } else if (statistic instanceof UseItemStatistic) {
                category = StatisticCategory.USE_ITEM;
                statisticId = ((UseItemStatistic)statistic).getId();
            } else if (statistic instanceof BreakItemStatistic) {
                category = StatisticCategory.BREAK_ITEM;
                statisticId = ((BreakItemStatistic)statistic).getId();
            } else if (statistic instanceof PickupItemStatistic) {
                category = StatisticCategory.PICKED_UP_ITEM;
                statisticId = ((PickupItemStatistic)statistic).getId();
            } else if (statistic instanceof DropItemStatistic) {
                category = StatisticCategory.DROP_ITEM;
                statisticId = ((DropItemStatistic)statistic).getId();
            } else if (statistic instanceof KillEntityStatistic) {
                category = StatisticCategory.KILL_ENTITY;
                statisticId = ((KillEntityStatistic)statistic).getEntity().ordinal();
            } else if (statistic instanceof KilledByEntityStatistic) {
                category = StatisticCategory.KILLED_BY_ENTITY;
                statisticId = ((KilledByEntityStatistic)statistic).getEntity().ordinal();
            } else if (statistic instanceof CustomStatistic) {
                category = StatisticCategory.CUSTOM;
                statisticId = ((CustomStatistic)statistic).ordinal();
            } else {
                throw new IllegalStateException();
            }
            helper.writeStatisticCategory(out, category);
            helper.writeVarInt(out, statisticId);
            helper.writeVarInt(out, entry.getIntValue());
        }
    }

    @NonNull
    public Object2IntMap<Statistic> getStatistics() {
        return this.statistics;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundAwardStatsPacket)) {
            return false;
        }
        ClientboundAwardStatsPacket other = (ClientboundAwardStatsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object2IntMap<Statistic> this$statistics = this.getStatistics();
        Object2IntMap<Statistic> other$statistics = other.getStatistics();
        return !(this$statistics == null ? other$statistics != null : !this$statistics.equals(other$statistics));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundAwardStatsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object2IntMap<Statistic> $statistics = this.getStatistics();
        result = result * 59 + ($statistics == null ? 43 : $statistics.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundAwardStatsPacket(statistics=" + this.getStatistics() + ")";
    }

    public ClientboundAwardStatsPacket() {
    }
}

