/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.status.clientbound;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.auth.util.Base64;
import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import com.github.steveice10.mc.protocol.data.status.PlayerInfo;
import com.github.steveice10.mc.protocol.data.status.ServerStatusInfo;
import com.github.steveice10.mc.protocol.data.status.VersionInfo;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import lombok.NonNull;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;

public class ClientboundStatusResponsePacket
implements MinecraftPacket {
    private static final boolean ENFORCES_SECURE_CHAT_DEFAULT = false;
    @NonNull
    private final ServerStatusInfo info;

    public ClientboundStatusResponsePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        JsonArray prof;
        JsonObject obj = (JsonObject)new Gson().fromJson(helper.readString(in), JsonObject.class);
        JsonElement desc = obj.get("description");
        Component description = (Component)DefaultComponentSerializer.get().serializer().fromJson(desc, Component.class);
        JsonObject plrs = obj.get("players").getAsJsonObject();
        ArrayList<GameProfile> profiles = new ArrayList<GameProfile>();
        if (plrs.has("sample") && (prof = plrs.get("sample").getAsJsonArray()).size() > 0) {
            for (int index = 0; index < prof.size(); ++index) {
                JsonObject o = prof.get(index).getAsJsonObject();
                profiles.add(new GameProfile(o.get("id").getAsString(), o.get("name").getAsString()));
            }
        }
        PlayerInfo players = new PlayerInfo(plrs.get("max").getAsInt(), plrs.get("online").getAsInt(), profiles);
        JsonObject ver = obj.get("version").getAsJsonObject();
        VersionInfo version = new VersionInfo(ver.get("name").getAsString(), ver.get("protocol").getAsInt());
        byte[] icon = null;
        if (obj.has("favicon")) {
            icon = this.stringToIcon(obj.get("favicon").getAsString());
        }
        boolean enforcesSecureChat = false;
        if (obj.has("enforcesSecureChat")) {
            enforcesSecureChat = obj.get("enforcesSecureChat").getAsBoolean();
        }
        this.info = new ServerStatusInfo(version, players, description, icon, enforcesSecureChat);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        JsonObject obj = new JsonObject();
        JsonObject ver = new JsonObject();
        ver.addProperty("name", this.info.getVersionInfo().getVersionName());
        ver.addProperty("protocol", (Number)this.info.getVersionInfo().getProtocolVersion());
        JsonObject plrs = new JsonObject();
        plrs.addProperty("max", (Number)this.info.getPlayerInfo().getMaxPlayers());
        plrs.addProperty("online", (Number)this.info.getPlayerInfo().getOnlinePlayers());
        if (this.info.getPlayerInfo().getPlayers().size() > 0) {
            JsonArray array = new JsonArray();
            for (GameProfile profile : this.info.getPlayerInfo().getPlayers()) {
                JsonObject o = new JsonObject();
                o.addProperty("name", profile.getName());
                o.addProperty("id", profile.getIdAsString());
                array.add((JsonElement)o);
            }
            plrs.add("sample", (JsonElement)array);
        }
        obj.add("description", (JsonElement)new Gson().fromJson((String)DefaultComponentSerializer.get().serialize(this.info.getDescription()), JsonElement.class));
        obj.add("players", (JsonElement)plrs);
        obj.add("version", (JsonElement)ver);
        if (this.info.getIconPng() != null) {
            obj.addProperty("favicon", this.iconToString(this.info.getIconPng()));
        }
        obj.addProperty("enforcesSecureChat", Boolean.valueOf(this.info.isEnforcesSecureChat()));
        helper.writeString(out, obj.toString());
    }

    @Override
    public boolean isPriority() {
        return false;
    }

    private byte[] stringToIcon(String str) {
        if (str.startsWith("data:image/png;base64,")) {
            str = str.substring("data:image/png;base64,".length());
        }
        return Base64.decode(str.getBytes(StandardCharsets.UTF_8));
    }

    private String iconToString(byte[] icon) {
        return "data:image/png;base64," + new String(Base64.encode(icon), StandardCharsets.UTF_8);
    }

    @NonNull
    public ServerStatusInfo getInfo() {
        return this.info;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundStatusResponsePacket)) {
            return false;
        }
        ClientboundStatusResponsePacket other = (ClientboundStatusResponsePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ServerStatusInfo this$info = this.getInfo();
        ServerStatusInfo other$info = other.getInfo();
        return !(this$info == null ? other$info != null : !((Object)this$info).equals(other$info));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundStatusResponsePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ServerStatusInfo $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundStatusResponsePacket(info=" + this.getInfo() + ")";
    }

    public ClientboundStatusResponsePacket withInfo(@NonNull ServerStatusInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        return this.info == info ? this : new ClientboundStatusResponsePacket(info);
    }

    public ClientboundStatusResponsePacket(@NonNull ServerStatusInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        this.info = info;
    }
}

