/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.blockstateupdater.util.tagupdater;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cloudburstmc.blockstateupdater.util.TagUtils;
import org.cloudburstmc.blockstateupdater.util.tagupdater.CompoundTagUpdater;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;

public class CompoundTagUpdaterContext {
    private final List<CompoundTagUpdater> updaters = new ArrayList<CompoundTagUpdater>();

    private static int mergeVersions(int baseVersion, int updaterVersion) {
        return updaterVersion | baseVersion;
    }

    private static int baseVersion(int version) {
        return version & 0xFFFFFF00;
    }

    public static int updaterVersion(int version) {
        return version & 0xFF;
    }

    public static int makeVersion(int major, int minor, int patch) {
        return patch << 8 | minor << 16 | major << 24;
    }

    public CompoundTagUpdater.Builder addUpdater(int major, int minor, int patch) {
        return this.addUpdater(major, minor, patch, false);
    }

    public CompoundTagUpdater.Builder addUpdater(int major, int minor, int patch, boolean ignoreVersion) {
        int version = CompoundTagUpdaterContext.makeVersion(major, minor, patch);
        CompoundTagUpdater prevUpdater = this.getLatestUpdater();
        int updaterVersion = ignoreVersion || prevUpdater == null || CompoundTagUpdaterContext.baseVersion(prevUpdater.getVersion()) != version ? 0 : CompoundTagUpdaterContext.updaterVersion(prevUpdater.getVersion()) + 1;
        version = CompoundTagUpdaterContext.mergeVersions(version, updaterVersion);
        CompoundTagUpdater updater = new CompoundTagUpdater(version);
        this.updaters.add(updater);
        this.updaters.sort(null);
        return updater.builder();
    }

    public NbtMap update(NbtMap tag, int version) {
        Map<String, Object> updated = this.updateStates0(tag, version);
        if (updated == null && version != this.getLatestVersion()) {
            NbtMapBuilder builder = tag.toBuilder();
            builder.putInt("version", this.getLatestVersion());
            return builder.build();
        }
        if (updated == null) {
            return tag;
        }
        updated.put("version", this.getLatestVersion());
        return (NbtMap)TagUtils.toImmutable(updated);
    }

    public NbtMap updateStates(NbtMap tag, int version) {
        Map<String, Object> updated = this.updateStates0(tag, version);
        return updated == null ? tag : (NbtMap)TagUtils.toImmutable(updated);
    }

    private Map<String, Object> updateStates0(NbtMap tag, int version) {
        Map mutableTag = null;
        boolean updated = false;
        for (CompoundTagUpdater updater : this.updaters) {
            if (updater.getVersion() < version) continue;
            if (mutableTag == null) {
                mutableTag = (Map)TagUtils.toMutable(tag);
            }
            updated |= updater.update(mutableTag);
        }
        if (mutableTag == null || !updated) {
            return null;
        }
        return mutableTag;
    }

    private CompoundTagUpdater getLatestUpdater() {
        return this.updaters.isEmpty() ? null : this.updaters.get(this.updaters.size() - 1);
    }

    public int getLatestVersion() {
        CompoundTagUpdater updater = this.getLatestUpdater();
        return updater == null ? 0 : updater.getVersion();
    }
}

