/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.netty.codec.batch;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.Queue;
import org.cloudburstmc.protocol.common.util.VarInts;

public class BedrockBatchEncoder
extends ChannelOutboundHandlerAdapter {
    public static final String NAME = "bedrock-batch-encoder";
    private static final InternalLogger log = InternalLoggerFactory.getInstance(BedrockBatchEncoder.class);
    private final Queue<ByteBuf> messages = new ArrayDeque<ByteBuf>();

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof ByteBuf)) {
            super.write(ctx, msg, promise);
            return;
        }
        this.messages.add(((ByteBuf)msg).slice());
        promise.trySuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(ChannelHandlerContext ctx) throws Exception {
        if (this.messages.isEmpty()) {
            super.flush(ctx);
            return;
        }
        CompositeByteBuf buf = ctx.alloc().compositeDirectBuffer(this.messages.size() * 2);
        try {
            ByteBuf message;
            while ((message = this.messages.poll()) != null) {
                try {
                    ByteBuf header = ctx.alloc().ioBuffer(5);
                    VarInts.writeUnsignedInt(header, message.readableBytes());
                    buf.addComponent(true, header);
                    buf.addComponent(true, message.retain());
                }
                finally {
                    message.release();
                }
            }
            ctx.write((Object)buf.retain());
        }
        finally {
            buf.release();
        }
        super.flush(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        ByteBuf message;
        while ((message = this.messages.poll()) != null) {
            message.release();
        }
        super.handlerRemoved(ctx);
    }
}

