/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.packet;

import java.util.List;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketType;
import org.cloudburstmc.protocol.common.PacketSignal;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public class ResourcePacksInfoPacket
implements BedrockPacket {
    private final List<Entry> behaviorPackInfos = new ObjectArrayList<Entry>();
    private final List<Entry> resourcePackInfos = new ObjectArrayList<Entry>();
    private boolean forcedToAccept;
    private boolean scriptingEnabled;
    private boolean forcingServerPacksEnabled;
    private List<CDNEntry> CDNEntries = new ObjectArrayList<CDNEntry>();

    @Override
    public final PacketSignal handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.RESOURCE_PACKS_INFO;
    }

    public List<Entry> getBehaviorPackInfos() {
        return this.behaviorPackInfos;
    }

    public List<Entry> getResourcePackInfos() {
        return this.resourcePackInfos;
    }

    public boolean isForcedToAccept() {
        return this.forcedToAccept;
    }

    public boolean isScriptingEnabled() {
        return this.scriptingEnabled;
    }

    public boolean isForcingServerPacksEnabled() {
        return this.forcingServerPacksEnabled;
    }

    public List<CDNEntry> getCDNEntries() {
        return this.CDNEntries;
    }

    public void setForcedToAccept(boolean forcedToAccept) {
        this.forcedToAccept = forcedToAccept;
    }

    public void setScriptingEnabled(boolean scriptingEnabled) {
        this.scriptingEnabled = scriptingEnabled;
    }

    public void setForcingServerPacksEnabled(boolean forcingServerPacksEnabled) {
        this.forcingServerPacksEnabled = forcingServerPacksEnabled;
    }

    public void setCDNEntries(List<CDNEntry> CDNEntries) {
        this.CDNEntries = CDNEntries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourcePacksInfoPacket)) {
            return false;
        }
        ResourcePacksInfoPacket other = (ResourcePacksInfoPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.forcedToAccept != other.forcedToAccept) {
            return false;
        }
        if (this.scriptingEnabled != other.scriptingEnabled) {
            return false;
        }
        if (this.forcingServerPacksEnabled != other.forcingServerPacksEnabled) {
            return false;
        }
        List<Entry> this$behaviorPackInfos = this.behaviorPackInfos;
        List<Entry> other$behaviorPackInfos = other.behaviorPackInfos;
        if (this$behaviorPackInfos == null ? other$behaviorPackInfos != null : !((Object)this$behaviorPackInfos).equals(other$behaviorPackInfos)) {
            return false;
        }
        List<Entry> this$resourcePackInfos = this.resourcePackInfos;
        List<Entry> other$resourcePackInfos = other.resourcePackInfos;
        if (this$resourcePackInfos == null ? other$resourcePackInfos != null : !((Object)this$resourcePackInfos).equals(other$resourcePackInfos)) {
            return false;
        }
        List<CDNEntry> this$CDNEntries = this.CDNEntries;
        List<CDNEntry> other$CDNEntries = other.CDNEntries;
        return !(this$CDNEntries == null ? other$CDNEntries != null : !((Object)this$CDNEntries).equals(other$CDNEntries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourcePacksInfoPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.forcedToAccept ? 79 : 97);
        result = result * 59 + (this.scriptingEnabled ? 79 : 97);
        result = result * 59 + (this.forcingServerPacksEnabled ? 79 : 97);
        List<Entry> $behaviorPackInfos = this.behaviorPackInfos;
        result = result * 59 + ($behaviorPackInfos == null ? 43 : ((Object)$behaviorPackInfos).hashCode());
        List<Entry> $resourcePackInfos = this.resourcePackInfos;
        result = result * 59 + ($resourcePackInfos == null ? 43 : ((Object)$resourcePackInfos).hashCode());
        List<CDNEntry> $CDNEntries = this.CDNEntries;
        result = result * 59 + ($CDNEntries == null ? 43 : ((Object)$CDNEntries).hashCode());
        return result;
    }

    public String toString() {
        return "ResourcePacksInfoPacket(behaviorPackInfos=" + this.behaviorPackInfos + ", resourcePackInfos=" + this.resourcePackInfos + ", forcedToAccept=" + this.forcedToAccept + ", scriptingEnabled=" + this.scriptingEnabled + ", forcingServerPacksEnabled=" + this.forcingServerPacksEnabled + ", CDNEntries=" + this.CDNEntries + ")";
    }

    public static final class CDNEntry {
        private final String packId;
        private final String remoteUrl;

        public CDNEntry(String packId, String remoteUrl) {
            this.packId = packId;
            this.remoteUrl = remoteUrl;
        }

        public String getPackId() {
            return this.packId;
        }

        public String getRemoteUrl() {
            return this.remoteUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CDNEntry)) {
                return false;
            }
            CDNEntry other = (CDNEntry)o;
            String this$packId = this.getPackId();
            String other$packId = other.getPackId();
            if (this$packId == null ? other$packId != null : !this$packId.equals(other$packId)) {
                return false;
            }
            String this$remoteUrl = this.getRemoteUrl();
            String other$remoteUrl = other.getRemoteUrl();
            return !(this$remoteUrl == null ? other$remoteUrl != null : !this$remoteUrl.equals(other$remoteUrl));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $packId = this.getPackId();
            result = result * 59 + ($packId == null ? 43 : $packId.hashCode());
            String $remoteUrl = this.getRemoteUrl();
            result = result * 59 + ($remoteUrl == null ? 43 : $remoteUrl.hashCode());
            return result;
        }

        public String toString() {
            return "ResourcePacksInfoPacket.CDNEntry(packId=" + this.getPackId() + ", remoteUrl=" + this.getRemoteUrl() + ")";
        }
    }

    public static final class Entry {
        private final String packId;
        private final String packVersion;
        private final long packSize;
        private final String contentKey;
        private final String subPackName;
        private final String contentId;
        private final boolean scripting;
        private final boolean raytracingCapable;

        public Entry(String packId, String packVersion, long packSize, String contentKey, String subPackName, String contentId, boolean scripting, boolean raytracingCapable) {
            this.packId = packId;
            this.packVersion = packVersion;
            this.packSize = packSize;
            this.contentKey = contentKey;
            this.subPackName = subPackName;
            this.contentId = contentId;
            this.scripting = scripting;
            this.raytracingCapable = raytracingCapable;
        }

        public String getPackId() {
            return this.packId;
        }

        public String getPackVersion() {
            return this.packVersion;
        }

        public long getPackSize() {
            return this.packSize;
        }

        public String getContentKey() {
            return this.contentKey;
        }

        public String getSubPackName() {
            return this.subPackName;
        }

        public String getContentId() {
            return this.contentId;
        }

        public boolean isScripting() {
            return this.scripting;
        }

        public boolean isRaytracingCapable() {
            return this.raytracingCapable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (this.getPackSize() != other.getPackSize()) {
                return false;
            }
            if (this.isScripting() != other.isScripting()) {
                return false;
            }
            if (this.isRaytracingCapable() != other.isRaytracingCapable()) {
                return false;
            }
            String this$packId = this.getPackId();
            String other$packId = other.getPackId();
            if (this$packId == null ? other$packId != null : !this$packId.equals(other$packId)) {
                return false;
            }
            String this$packVersion = this.getPackVersion();
            String other$packVersion = other.getPackVersion();
            if (this$packVersion == null ? other$packVersion != null : !this$packVersion.equals(other$packVersion)) {
                return false;
            }
            String this$contentKey = this.getContentKey();
            String other$contentKey = other.getContentKey();
            if (this$contentKey == null ? other$contentKey != null : !this$contentKey.equals(other$contentKey)) {
                return false;
            }
            String this$subPackName = this.getSubPackName();
            String other$subPackName = other.getSubPackName();
            if (this$subPackName == null ? other$subPackName != null : !this$subPackName.equals(other$subPackName)) {
                return false;
            }
            String this$contentId = this.getContentId();
            String other$contentId = other.getContentId();
            return !(this$contentId == null ? other$contentId != null : !this$contentId.equals(other$contentId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $packSize = this.getPackSize();
            result = result * 59 + (int)($packSize >>> 32 ^ $packSize);
            result = result * 59 + (this.isScripting() ? 79 : 97);
            result = result * 59 + (this.isRaytracingCapable() ? 79 : 97);
            String $packId = this.getPackId();
            result = result * 59 + ($packId == null ? 43 : $packId.hashCode());
            String $packVersion = this.getPackVersion();
            result = result * 59 + ($packVersion == null ? 43 : $packVersion.hashCode());
            String $contentKey = this.getContentKey();
            result = result * 59 + ($contentKey == null ? 43 : $contentKey.hashCode());
            String $subPackName = this.getSubPackName();
            result = result * 59 + ($subPackName == null ? 43 : $subPackName.hashCode());
            String $contentId = this.getContentId();
            result = result * 59 + ($contentId == null ? 43 : $contentId.hashCode());
            return result;
        }

        public String toString() {
            return "ResourcePacksInfoPacket.Entry(packId=" + this.getPackId() + ", packVersion=" + this.getPackVersion() + ", packSize=" + this.getPackSize() + ", contentKey=" + this.getContentKey() + ", subPackName=" + this.getSubPackName() + ", contentId=" + this.getContentId() + ", scripting=" + this.isScripting() + ", raytracingCapable=" + this.isRaytracingCapable() + ")";
        }
    }
}

