/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.erosion.packet.backendbound;

import io.netty.buffer.ByteBuf;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.common.util.VarInts;
import org.geysermc.erosion.packet.ProtocolUtils;
import org.geysermc.erosion.packet.backendbound.BackendboundPacket;
import org.geysermc.erosion.packet.backendbound.BackendboundPacketHandler;

public final class BackendboundBlockRequestPacket
implements BackendboundPacket {
    private final int transactionId;
    private final Vector3i pos;

    public BackendboundBlockRequestPacket(int transactionId, Vector3i pos) {
        this.transactionId = transactionId;
        this.pos = pos;
    }

    public BackendboundBlockRequestPacket(ByteBuf buf) {
        this.transactionId = VarInts.readUnsignedInt(buf);
        this.pos = ProtocolUtils.readBlockPos(buf);
    }

    @Override
    public void serialize(ByteBuf buf) {
        VarInts.writeUnsignedInt(buf, this.transactionId);
        ProtocolUtils.writeBlockPos(buf, this.pos);
    }

    @Override
    public void handle(BackendboundPacketHandler packetHandler) {
        packetHandler.handleBlockRequest(this);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public Vector3i getPos() {
        return this.pos;
    }

    public String toString() {
        return "BackendboundBlockRequestPacket{pos=" + this.pos + '}';
    }
}

