/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser;

import com.github.steveice10.packetlib.tcp.TcpSession;
import io.netty.channel.epoll.Epoll;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.security.Key;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.api.Geyser;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.util.FormBuilder;
import org.geysermc.erosion.packet.Packets;
import org.geysermc.floodgate.crypto.AesCipher;
import org.geysermc.floodgate.crypto.AesKeyProducer;
import org.geysermc.floodgate.crypto.Base64Topping;
import org.geysermc.floodgate.crypto.FloodgateCipher;
import org.geysermc.floodgate.news.NewsItemAction;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.event.EventBus;
import org.geysermc.geyser.api.event.EventRegistrar;
import org.geysermc.geyser.api.event.lifecycle.GeyserPostInitializeEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserPreInitializeEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserShutdownEvent;
import org.geysermc.geyser.api.network.AuthType;
import org.geysermc.geyser.api.network.BedrockListener;
import org.geysermc.geyser.api.network.RemoteServer;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.GeyserCommandManager;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.erosion.UnixSocketClientListener;
import org.geysermc.geyser.event.GeyserEventBus;
import org.geysermc.geyser.extension.GeyserExtensionManager;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.network.netty.GeyserServer;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.core.JsonParser;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.NamedTextColor;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.TextColor;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.provider.ProviderSupplier;
import org.geysermc.geyser.scoreboard.ScoreboardUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.PendingMicrosoftAuthentication;
import org.geysermc.geyser.session.SessionManager;
import org.geysermc.geyser.skin.FloodgateSkinUploader;
import org.geysermc.geyser.skin.ProvidedSkins;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.AssetUtils;
import org.geysermc.geyser.util.CooldownUtils;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.geyser.util.Metrics;
import org.geysermc.geyser.util.NewsHandler;
import org.geysermc.geyser.util.VersionCheckUtils;
import org.geysermc.geyser.util.WebUtils;

public class GeyserImpl
implements GeyserApi {
    public static final ObjectMapper JSON_MAPPER = new ObjectMapper().enable(JsonParser.Feature.IGNORE_UNDEFINED).enable(JsonParser.Feature.ALLOW_COMMENTS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES).enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
    public static final String NAME = "Geyser";
    public static final String GIT_VERSION = "git-master-58ff00d";
    public static final String VERSION = "2.2.0-SNAPSHOT (git-master-58ff00d)";
    public static final String BUILD_NUMBER = "403";
    public static final String BRANCH = "master";
    public static final String COMMIT = "58ff00db961641164411564fe1c6d9406750f991";
    public static final String REPOSITORY = "https://github.com/GeyserMC/Geyser";
    public static final String OAUTH_CLIENT_ID = "204cefd1-4818-4de1-b98d-513fae875d88";
    private static final String IP_REGEX = "\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b";
    private final SessionManager sessionManager = new SessionManager();
    private static boolean shouldStartListener = true;
    private FloodgateCipher cipher;
    private FloodgateSkinUploader skinUploader;
    private NewsHandler newsHandler;
    private UnixSocketClientListener erosionUnixListener;
    private volatile boolean shuttingDown = false;
    private ScheduledExecutorService scheduledThread;
    private GeyserServer geyserServer;
    private final PlatformType platformType;
    private final GeyserBootstrap bootstrap;
    private final EventBus<EventRegistrar> eventBus;
    private final GeyserExtensionManager extensionManager;
    private Metrics metrics;
    private PendingMicrosoftAuthentication pendingMicrosoftAuthentication;
    private Map<String, String> savedRefreshTokens;
    private static GeyserImpl instance;

    private GeyserImpl(PlatformType platformType, GeyserBootstrap bootstrap) {
        instance = this;
        Geyser.set(this);
        this.platformType = platformType;
        this.bootstrap = bootstrap;
        GeyserLocale.finalizeDefaultLocale(this);
        this.eventBus = new GeyserEventBus();
        this.extensionManager = new GeyserExtensionManager();
        this.extensionManager.init();
        this.eventBus.fire(new GeyserPreInitializeEvent(this.extensionManager, this.eventBus));
    }

    public void initialize() {
        long startupTime = System.currentTimeMillis();
        GeyserLogger logger = this.bootstrap.getGeyserLogger();
        logger.info("******************************************");
        logger.info("");
        logger.info(GeyserLocale.getLocaleStringLog("geyser.core.load", NAME, VERSION));
        logger.info("");
        logger.info("******************************************");
        Registries.init();
        BlockRegistries.init();
        EntityDefinitions.init();
        MessageTranslator.init();
        AssetUtils.generateAssetCache().whenComplete((aVoid, ex) -> {
            if (ex != null) {
                return;
            }
            MinecraftLocale.ensureEN_US();
            String locale = GeyserLocale.getDefaultLocale();
            if (!"en_us".equals(locale)) {
                MinecraftLocale.downloadAndLoadLocale(locale);
            }
            ProvidedSkins.init();
            CompletableFuture.runAsync(AssetUtils::downloadAndRunClientJarTasks);
        });
        this.startInstance();
        GeyserConfiguration config = this.bootstrap.getGeyserConfig();
        double completeTime = (double)(System.currentTimeMillis() - startupTime) / 1000.0;
        Object message = GeyserLocale.getLocaleStringLog("geyser.core.finish.done", new DecimalFormat("#.###").format(completeTime));
        message = (String)message + " " + GeyserLocale.getLocaleStringLog("geyser.core.finish.console");
        logger.info((String)message);
        if (this.platformType == PlatformType.STANDALONE) {
            if (config.getRemote().authType() != AuthType.FLOODGATE) {
                logger.warning(GeyserLocale.getLocaleStringLog("geyser.core.movement_warn"));
            }
        } else if (config.getRemote().authType() == AuthType.FLOODGATE) {
            VersionCheckUtils.checkForOutdatedFloodgate(logger);
        }
    }

    private void startInstance() {
        String[] record;
        String remoteAddress;
        String pluginUdpPort;
        this.scheduledThread = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("Geyser Scheduled Thread"));
        GeyserLogger logger = this.bootstrap.getGeyserLogger();
        GeyserConfiguration config = this.bootstrap.getGeyserConfig();
        ScoreboardUpdater.init();
        SkinProvider.registerCacheImageTask(this);
        Registries.RESOURCE_PACKS.load();
        String geyserUdpPort = System.getProperty("geyserUdpPort", "");
        String string = pluginUdpPort = geyserUdpPort.isEmpty() ? System.getProperty("pluginUdpPort", "") : geyserUdpPort;
        if ("-1".equals(pluginUdpPort)) {
            throw new UnsupportedOperationException("This hosting/service provider does not support applications running on the UDP port");
        }
        boolean portPropertyApplied = false;
        String pluginUdpAddress = System.getProperty("geyserUdpAddress", System.getProperty("pluginUdpAddress", ""));
        if (this.platformType != PlatformType.STANDALONE) {
            int javaPort = this.bootstrap.getServerPort();
            if (config.getRemote().address().equals("auto")) {
                config.setAutoconfiguredRemote(true);
                String serverAddress = this.bootstrap.getServerBindAddress();
                if (!serverAddress.isEmpty() && !"0.0.0.0".equals(serverAddress)) {
                    config.getRemote().setAddress(serverAddress);
                } else {
                    try {
                        config.getRemote().setAddress(InetAddress.getLocalHost().getHostAddress());
                    }
                    catch (UnknownHostException ex) {
                        logger.debug("Unknown host when trying to find localhost.");
                        if (config.isDebugMode()) {
                            ex.printStackTrace();
                        }
                        config.getRemote().setAddress(InetAddress.getLoopbackAddress().getHostAddress());
                    }
                }
                if (javaPort != -1) {
                    config.getRemote().setPort(javaPort);
                }
            }
            boolean forceMatchServerPort = "server".equals(pluginUdpPort);
            if ((config.getBedrock().isCloneRemotePort() || forceMatchServerPort) && javaPort != -1) {
                config.getBedrock().setPort(javaPort);
                if (forceMatchServerPort) {
                    if (geyserUdpPort.isEmpty()) {
                        logger.info("Port set from system generic property to match Java server.");
                    } else {
                        logger.info("Port set from system property to match Java server.");
                    }
                    portPropertyApplied = true;
                }
            }
            if ("server".equals(pluginUdpAddress)) {
                String address = this.bootstrap.getServerBindAddress();
                if (!address.isEmpty()) {
                    config.getBedrock().setAddress(address);
                }
            } else if (!pluginUdpAddress.isEmpty()) {
                config.getBedrock().setAddress(pluginUdpAddress);
            }
            if (!portPropertyApplied && !pluginUdpPort.isEmpty()) {
                int port = Integer.parseInt(pluginUdpPort);
                config.getBedrock().setPort(port);
                if (geyserUdpPort.isEmpty()) {
                    logger.info("Port set from generic system property: " + port);
                } else {
                    logger.info("Port set from system property: " + port);
                }
            }
            boolean floodgatePresent = this.bootstrap.testFloodgatePluginPresent();
            if (config.getRemote().authType() == AuthType.FLOODGATE && !floodgatePresent) {
                logger.severe(GeyserLocale.getLocaleStringLog("geyser.bootstrap.floodgate.not_installed") + " " + GeyserLocale.getLocaleStringLog("geyser.bootstrap.floodgate.disabling"));
                return;
            }
            if (config.isAutoconfiguredRemote() && floodgatePresent) {
                logger.debug("Auto-setting to Floodgate authentication.");
                config.getRemote().setAuthType(AuthType.FLOODGATE);
            }
        }
        if (!(remoteAddress = config.getRemote().address()).matches(IP_REGEX) && !remoteAddress.equalsIgnoreCase("localhost") && (record = WebUtils.findSrvRecord(this, remoteAddress)) != null) {
            int remotePort = Integer.parseInt(record[2]);
            remoteAddress = record[3];
            config.getRemote().setAddress(remoteAddress);
            config.getRemote().setPort(remotePort);
            logger.debug("Found SRV record \"" + remoteAddress + ":" + remotePort + "\"");
        }
        TcpSession.USE_EVENT_LOOP_FOR_PACKETS = false;
        this.pendingMicrosoftAuthentication = new PendingMicrosoftAuthentication(config.getPendingAuthenticationTimeout());
        this.newsHandler = new NewsHandler(BRANCH, this.buildNumber());
        Packets.initGeyser();
        if (Epoll.isAvailable()) {
            this.erosionUnixListener = new UnixSocketClientListener();
        } else {
            logger.debug("Epoll is not available; Erosion's Unix socket handling will not work.");
        }
        CooldownUtils.setDefaultShowCooldown(config.getShowCooldown());
        DimensionUtils.changeBedrockNetherId(config.isAboveBedrockNetherBuilding());
        Integer bedrockThreadCount = Integer.getInteger("Geyser.BedrockNetworkThreads");
        if (bedrockThreadCount == null) {
            bedrockThreadCount = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)(NettyRuntime.availableProcessors() * 2)));
        }
        if (shouldStartListener) {
            this.geyserServer = new GeyserServer(this, bedrockThreadCount);
            ((CompletableFuture)this.geyserServer.bind(new InetSocketAddress(config.getBedrock().address(), config.getBedrock().port())).whenComplete((avoid, throwable) -> {
                if (throwable == null) {
                    logger.info(GeyserLocale.getLocaleStringLog("geyser.core.start", config.getBedrock().address(), String.valueOf(config.getBedrock().port())));
                } else {
                    String address = config.getBedrock().address();
                    int port = config.getBedrock().port();
                    logger.severe(GeyserLocale.getLocaleStringLog("geyser.core.fail", address, String.valueOf(port)));
                    if (!"0.0.0.0".equals(address)) {
                        logger.info(Component.text("Suggestion: try setting `address` under `bedrock` in the Geyser config back to 0.0.0.0", (TextColor)NamedTextColor.GREEN));
                        logger.info(Component.text("Then, restart this server.", (TextColor)NamedTextColor.GREEN));
                    }
                }
            })).join();
        }
        if (config.getRemote().authType() == AuthType.FLOODGATE) {
            try {
                Key key = new AesKeyProducer().produceFrom(config.getFloodgateKeyPath());
                this.cipher = new AesCipher(new Base64Topping());
                this.cipher.init(key);
                logger.debug("Loaded Floodgate key!");
                this.skinUploader = new FloodgateSkinUploader(this).start();
            }
            catch (Exception exception) {
                logger.severe(GeyserLocale.getLocaleStringLog("geyser.auth.floodgate.bad_key"), exception);
            }
        }
        if (config.getMetrics().isEnabled()) {
            this.metrics = new Metrics(this, "GeyserMC", config.getMetrics().getUniqueId(), false, Logger.getLogger(""));
            this.metrics.addCustomChart(new Metrics.SingleLineChart("players", this.sessionManager::size));
            this.metrics.addCustomChart(new Metrics.SimplePie("authMode", () -> config.getRemote().authType().toString().toLowerCase(Locale.ROOT)));
            this.metrics.addCustomChart(new Metrics.SimplePie("platform", this.platformType::platformName));
            this.metrics.addCustomChart(new Metrics.SimplePie("defaultLocale", GeyserLocale::getDefaultLocale));
            this.metrics.addCustomChart(new Metrics.SimplePie("version", () -> VERSION));
            this.metrics.addCustomChart(new Metrics.AdvancedPie("playerPlatform", () -> {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                for (GeyserSession session : this.sessionManager.getAllSessions()) {
                    if (session == null || session.getClientData() == null) continue;
                    String os = session.getClientData().getDeviceOs().toString();
                    if (!valueMap.containsKey(os)) {
                        valueMap.put(os, 1);
                        continue;
                    }
                    valueMap.put(os, (Integer)valueMap.get(os) + 1);
                }
                return valueMap;
            }));
            this.metrics.addCustomChart(new Metrics.AdvancedPie("playerVersion", () -> {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                for (GeyserSession session : this.sessionManager.getAllSessions()) {
                    if (session == null || session.getClientData() == null) continue;
                    String version = session.getClientData().getGameVersion();
                    if (!valueMap.containsKey(version)) {
                        valueMap.put(version, 1);
                        continue;
                    }
                    valueMap.put(version, (Integer)valueMap.get(version) + 1);
                }
                return valueMap;
            }));
            String minecraftVersion = this.bootstrap.getMinecraftServerVersion();
            if (minecraftVersion != null) {
                HashMap versionMap = new HashMap();
                HashMap<String, Integer> platformMap = new HashMap<String, Integer>();
                platformMap.put(this.platformType.platformName(), 1);
                versionMap.put(minecraftVersion, platformMap);
                this.metrics.addCustomChart(new Metrics.DrilldownPie("minecraftServerVersion", () -> versionMap));
            }
            this.metrics.addCustomChart(new Metrics.DrilldownPie("javaVersion", () -> {
                String release;
                HashMap map = new HashMap();
                String javaVersion = System.getProperty("java.version");
                HashMap<String, Integer> entry = new HashMap<String, Integer>();
                entry.put(javaVersion, 1);
                String majorVersion = javaVersion.split("\\.")[0];
                int indexOf = javaVersion.lastIndexOf(46);
                if (majorVersion.equals("1")) {
                    release = "Java " + javaVersion.substring(0, indexOf);
                } else {
                    Matcher versionMatcher = Pattern.compile("\\d+").matcher(majorVersion);
                    if (versionMatcher.find()) {
                        majorVersion = versionMatcher.group(0);
                    }
                    release = "Java " + majorVersion;
                }
                map.put((CallSite)((Object)release), entry);
                return map;
            }));
        } else {
            this.metrics = null;
        }
        if (config.getRemote().authType() == AuthType.ONLINE) {
            this.savedRefreshTokens = new ConcurrentHashMap<String, String>();
            File tokensFile = this.bootstrap.getSavedUserLoginsFolder().resolve("saved-refresh-tokens.json").toFile();
            if (tokensFile.exists()) {
                TypeReference<Map<String, String>> type = new TypeReference<Map<String, String>>(){};
                Map<String, String> refreshTokenFile = null;
                try {
                    refreshTokenFile = JSON_MAPPER.readValue(tokensFile, type);
                }
                catch (IOException e) {
                    logger.error("Cannot load saved user tokens!", e);
                }
                if (refreshTokenFile != null) {
                    List<String> validUsers = config.getSavedUserLogins();
                    boolean doWrite = false;
                    for (Map.Entry<String, String> entry : refreshTokenFile.entrySet()) {
                        String user = entry.getKey();
                        if (!validUsers.contains(user)) {
                            doWrite = true;
                            continue;
                        }
                        this.savedRefreshTokens.put(user, entry.getValue());
                    }
                    if (doWrite) {
                        this.scheduleRefreshTokensWrite();
                    }
                }
            }
        } else {
            this.savedRefreshTokens = null;
        }
        this.newsHandler.handleNews(null, NewsItemAction.ON_SERVER_STARTED);
        this.eventBus.fire(new GeyserPostInitializeEvent(this.extensionManager, this.eventBus));
        if (config.isNotifyOnNewBedrockUpdate()) {
            VersionCheckUtils.checkForGeyserUpdate(this::getLogger);
        }
        VersionCheckUtils.checkForOutdatedJava(logger);
    }

    public @NonNull List<GeyserSession> onlineConnections() {
        return this.sessionManager.getAllSessions();
    }

    @Override
    public int onlineConnectionsCount() {
        return this.sessionManager.size();
    }

    @Override
    public @MonotonicNonNull String usernamePrefix() {
        return null;
    }

    @Override
    public @Nullable GeyserSession connectionByUuid(@NonNull UUID uuid) {
        return this.sessionManager.getSessions().get(uuid);
    }

    @Override
    public @Nullable GeyserSession connectionByXuid(@NonNull String xuid) {
        return this.sessionManager.sessionByXuid(xuid);
    }

    @Override
    public boolean isBedrockPlayer(@NonNull UUID uuid) {
        return this.connectionByUuid(uuid) != null;
    }

    @Override
    public boolean sendForm(@NonNull UUID uuid, @NonNull Form form) {
        Objects.requireNonNull(uuid);
        Objects.requireNonNull(form);
        GeyserSession session = this.connectionByUuid(uuid);
        if (session == null) {
            return false;
        }
        return session.sendForm(form);
    }

    @Override
    public boolean sendForm(@NonNull UUID uuid, @NonNull FormBuilder<?, ?, ?> formBuilder) {
        return this.sendForm(uuid, (Form)formBuilder.build());
    }

    @Override
    public boolean transfer(@NonNull UUID uuid, @NonNull String address, int port) {
        Objects.requireNonNull(uuid);
        GeyserSession session = this.connectionByUuid(uuid);
        if (session == null) {
            return false;
        }
        return session.transfer(address, port);
    }

    public void shutdown() {
        this.bootstrap.getGeyserLogger().info(GeyserLocale.getLocaleStringLog("geyser.core.shutdown"));
        this.shuttingDown = true;
        if (this.sessionManager.size() >= 1) {
            this.bootstrap.getGeyserLogger().info(GeyserLocale.getLocaleStringLog("geyser.core.shutdown.kick.log", this.sessionManager.size()));
            this.sessionManager.disconnectAll("geyser.core.shutdown.kick.message");
            this.bootstrap.getGeyserLogger().info(GeyserLocale.getLocaleStringLog("geyser.core.shutdown.kick.done"));
        }
        this.scheduledThread.shutdown();
        this.geyserServer.shutdown();
        if (this.skinUploader != null) {
            this.skinUploader.close();
        }
        this.newsHandler.shutdown();
        this.commandManager().getCommands().clear();
        if (this.erosionUnixListener != null) {
            this.erosionUnixListener.close();
        }
        Registries.RESOURCE_PACKS.get().clear();
        this.eventBus.fire(new GeyserShutdownEvent(this.extensionManager, this.eventBus));
        this.extensionManager.disableExtensions();
        this.bootstrap.getGeyserLogger().info(GeyserLocale.getLocaleStringLog("geyser.core.shutdown.done"));
    }

    public void reload() {
        this.shutdown();
        this.extensionManager.enableExtensions();
        this.bootstrap.onEnable();
    }

    public boolean isProductionEnvironment() {
        return !"git-local/dev-0000000".equals(GIT_VERSION) && !GIT_VERSION.equals(GIT_VERSION);
    }

    @Override
    public @NonNull GeyserExtensionManager extensionManager() {
        return this.extensionManager;
    }

    public @NonNull GeyserCommandManager commandManager() {
        return this.bootstrap.getGeyserCommandManager();
    }

    @Override
    public <R extends T, T> @NonNull R provider(@NonNull Class<T> apiClass, Object ... args) {
        ProviderSupplier provider = (ProviderSupplier)Registries.PROVIDERS.get(apiClass);
        if (provider == null) {
            throw new IllegalArgumentException("No provider found for " + apiClass);
        }
        return (R)provider.create(args);
    }

    @Override
    public @NonNull EventBus<EventRegistrar> eventBus() {
        return this.eventBus;
    }

    @Override
    public @NonNull RemoteServer defaultRemoteServer() {
        return this.getConfig().getRemote();
    }

    @Override
    public @NonNull BedrockListener bedrockListener() {
        return this.getConfig().getBedrock();
    }

    @Override
    public @NonNull Path configDirectory() {
        return this.bootstrap.getConfigFolder();
    }

    @Override
    public @NonNull Path packDirectory() {
        return this.bootstrap.getConfigFolder().resolve("packs");
    }

    @Override
    public @NonNull PlatformType platformType() {
        return this.platformType;
    }

    public int buildNumber() {
        if (!this.isProductionEnvironment()) {
            return 0;
        }
        return Integer.parseInt(BUILD_NUMBER);
    }

    public static GeyserImpl load(PlatformType platformType, GeyserBootstrap bootstrap) {
        if (instance == null) {
            return new GeyserImpl(platformType, bootstrap);
        }
        return instance;
    }

    public static void start() {
        if (instance == null) {
            throw new RuntimeException("Geyser has not been loaded yet!");
        }
        if (instance.isShuttingDown()) {
            GeyserImpl.instance.shuttingDown = false;
            instance.startInstance();
        } else {
            instance.initialize();
        }
    }

    public GeyserLogger getLogger() {
        return this.bootstrap.getGeyserLogger();
    }

    public GeyserConfiguration getConfig() {
        return this.bootstrap.getGeyserConfig();
    }

    public WorldManager getWorldManager() {
        return this.bootstrap.getWorldManager();
    }

    public @Nullable String refreshTokenFor(@NonNull String bedrockName) {
        return this.savedRefreshTokens.get(bedrockName);
    }

    public void saveRefreshToken(@NonNull String bedrockName, @NonNull String refreshToken) {
        if (!this.getConfig().getSavedUserLogins().contains(bedrockName)) {
            return;
        }
        if (!Objects.equals(refreshToken, this.savedRefreshTokens.put(bedrockName, refreshToken))) {
            this.scheduleRefreshTokensWrite();
        }
    }

    private void scheduleRefreshTokensWrite() {
        this.scheduledThread.execute(() -> {
            File savedTokens = this.getBootstrap().getSavedUserLoginsFolder().resolve("saved-refresh-tokens.json").toFile();
            TypeReference<Map<String, String>> type = new TypeReference<Map<String, String>>(){};
            try (FileWriter writer = new FileWriter(savedTokens);){
                JSON_MAPPER.writerFor(type).withDefaultPrettyPrinter().writeValue(writer, this.savedRefreshTokens);
            }
            catch (IOException e) {
                this.getLogger().error("Unable to write saved refresh tokens!", e);
            }
        });
    }

    public static GeyserImpl getInstance() {
        return instance;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public FloodgateCipher getCipher() {
        return this.cipher;
    }

    public FloodgateSkinUploader getSkinUploader() {
        return this.skinUploader;
    }

    public NewsHandler getNewsHandler() {
        return this.newsHandler;
    }

    public UnixSocketClientListener getErosionUnixListener() {
        return this.erosionUnixListener;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public ScheduledExecutorService getScheduledThread() {
        return this.scheduledThread;
    }

    public GeyserServer getGeyserServer() {
        return this.geyserServer;
    }

    public PlatformType getPlatformType() {
        return this.platformType;
    }

    public GeyserBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public EventBus<EventRegistrar> getEventBus() {
        return this.eventBus;
    }

    public GeyserExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public PendingMicrosoftAuthentication getPendingMicrosoftAuthentication() {
        return this.pendingMicrosoftAuthentication;
    }

    public static void setShouldStartListener(boolean shouldStartListener) {
        GeyserImpl.shouldStartListener = shouldStartListener;
    }
}

