/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster.raid;

import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.monster.raid.AbstractIllagerEntity;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;

public class PillagerEntity
extends AbstractIllagerEntity {
    public PillagerEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    public void updateMainHand(GeyserSession session) {
        this.checkForCrossbow();
        super.updateMainHand(session);
    }

    @Override
    public void updateOffHand(GeyserSession session) {
        this.checkForCrossbow();
        super.updateOffHand(session);
    }

    protected void checkForCrossbow() {
        ItemMapping crossbow = this.session.getItemMappings().getStoredItems().crossbow();
        boolean hasCrossbow = this.hand.getDefinition() == crossbow.getBedrockDefinition() || this.offHand.getDefinition() == crossbow.getBedrockDefinition();
        this.setFlag(EntityFlag.USING_ITEM, hasCrossbow);
        this.setFlag(EntityFlag.CHARGED, hasCrossbow);
        this.updateBedrockMetadata();
    }
}

