/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import com.github.steveice10.mc.protocol.data.game.inventory.ContainerType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.PlayerInventory;

public class CrafterContainer
extends Container {
    private boolean triggered = false;
    private short disabledSlotsMask = 0;

    public CrafterContainer(String title, int id, int size, ContainerType containerType, PlayerInventory playerInventory) {
        super(title, id, size, containerType, playerInventory);
    }

    public void setSlot(int slot, boolean enabled) {
        if (slot < 0 || slot > 8) {
            GeyserImpl.getInstance().getLogger().warning("Crafter slot out of bounds: " + slot);
            return;
        }
        this.disabledSlotsMask = enabled ? (short)(this.disabledSlotsMask & ~(1 << slot)) : (short)(this.disabledSlotsMask | 1 << slot);
    }

    public boolean isTriggered() {
        return this.triggered;
    }

    public short getDisabledSlotsMask() {
        return this.disabledSlotsMask;
    }

    public void setTriggered(boolean triggered) {
        this.triggered = triggered;
    }
}

