/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.github.steveice10.mc.protocol.data.game.Identifier;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.ShortTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.item.Enchantment;
import org.geysermc.geyser.item.type.EnchantedBookItem;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.InventoryUtils;

public class Item {
    private final String javaIdentifier;
    private int javaId = -1;
    private final int stackSize;
    private final String toolType;
    private final int maxDamage;

    public Item(String javaIdentifier, Builder builder) {
        this.javaIdentifier = Identifier.formalize(javaIdentifier).intern();
        this.stackSize = builder.stackSize;
        this.toolType = builder.toolType;
        this.maxDamage = builder.maxDamage;
    }

    public String javaIdentifier() {
        return this.javaIdentifier;
    }

    public int javaId() {
        return this.javaId;
    }

    public int maxDamage() {
        return this.maxDamage;
    }

    public int maxStackSize() {
        return this.stackSize;
    }

    public boolean isValidRepairItem(Item other) {
        return false;
    }

    public ItemData.Builder translateToBedrock(ItemStack itemStack, ItemMapping mapping, ItemMappings mappings) {
        if (InventoryUtils.isEmpty(itemStack)) {
            return ItemData.builder();
        }
        ItemData.Builder builder = ItemData.builder().definition(mapping.getBedrockDefinition()).damage(mapping.getBedrockData()).count(itemStack.getAmount());
        if (itemStack.getNbt() != null) {
            builder.tag(ItemTranslator.translateNbtToBedrock(itemStack.getNbt()));
        }
        CompoundTag nbt = itemStack.getNbt();
        ItemTranslator.translateCustomItem(nbt, builder, mapping);
        return builder;
    }

    public @NonNull ItemStack translateToJava(@NonNull ItemData itemData, @NonNull ItemMapping mapping, @NonNull ItemMappings mappings) {
        if (itemData.getTag() == null) {
            return new ItemStack(this.javaId, itemData.getCount(), new CompoundTag(""));
        }
        return new ItemStack(this.javaId, itemData.getCount(), ItemTranslator.translateToJavaNBT("", itemData.getTag()));
    }

    public ItemMapping toBedrockDefinition(CompoundTag nbt, ItemMappings mappings) {
        return mappings.getMapping(this.javaId);
    }

    public void translateNbtToBedrock(@NonNull GeyserSession session, @NonNull CompoundTag tag) {
        Tag subTag;
        Iterator iterator;
        CompoundTag displayTag;
        Object t;
        Object t2 = tag.get("display");
        if (t2 instanceof CompoundTag && (t = (displayTag = (CompoundTag)t2).get("Lore")) instanceof ListTag) {
            ListTag listTag = (ListTag)t;
            ArrayList<Tag> lore = new ArrayList<Tag>();
            iterator = listTag.getValue().iterator();
            while (iterator.hasNext()) {
                subTag = (Tag)iterator.next();
                if (!(subTag instanceof StringTag)) continue;
                lore.add(new StringTag("", MessageTranslator.convertMessageLenient(((StringTag)subTag).getValue(), session.locale())));
            }
            displayTag.put(new ListTag("Lore", lore));
        }
        ArrayList<Tag> newTags = new ArrayList<Tag>();
        Object enchantmentTag = tag.remove("Enchantments");
        if (enchantmentTag instanceof ListTag) {
            ListTag listTag = (ListTag)enchantmentTag;
            iterator = listTag.getValue().iterator();
            while (iterator.hasNext()) {
                CompoundTag bedrockTag;
                subTag = (Tag)iterator.next();
                if (!(subTag instanceof CompoundTag) || (bedrockTag = this.remapEnchantment(session, (CompoundTag)subTag, tag)) == null) continue;
                newTags.add(bedrockTag);
            }
        }
        if (!newTags.isEmpty()) {
            tag.put(new ListTag("ench", newTags));
        }
    }

    public void translateNbtToJava(@NonNull CompoundTag tag, @NonNull ItemMapping mapping) {
        ListTag enchantmentTag;
        Iterator iterator;
        CompoundTag displayTag = (CompoundTag)tag.get("display");
        if (displayTag != null) {
            if (displayTag.contains("Name")) {
                StringTag nameTag = (StringTag)displayTag.get("Name");
                displayTag.put(new StringTag("Name", MessageTranslator.convertToJavaMessage(nameTag.getValue())));
            }
            if (displayTag.contains("Lore")) {
                ListTag loreTag = (ListTag)displayTag.get("Lore");
                ArrayList<Tag> lore = new ArrayList<Tag>();
                iterator = loreTag.getValue().iterator();
                while (iterator.hasNext()) {
                    Tag subTag = (Tag)iterator.next();
                    if (!(subTag instanceof StringTag)) continue;
                    lore.add(new StringTag("", MessageTranslator.convertToJavaMessage(((StringTag)subTag).getValue())));
                }
                displayTag.put(new ListTag("Lore", lore));
            }
        }
        if ((enchantmentTag = (ListTag)tag.remove("ench")) != null) {
            ArrayList<Tag> enchantments = new ArrayList<Tag>();
            iterator = enchantmentTag.getValue().iterator();
            while (iterator.hasNext()) {
                CompoundTag tagValue;
                ShortTag bedrockId;
                Tag value = (Tag)iterator.next();
                if (!(value instanceof CompoundTag) || (bedrockId = (ShortTag)(tagValue = (CompoundTag)value).get("id")) == null) continue;
                Enchantment enchantment = Enchantment.getByBedrockId(bedrockId.getValue().shortValue());
                if (enchantment != null) {
                    CompoundTag javaTag = new CompoundTag("");
                    Object javaValue = javaTag.getValue();
                    javaValue.put("id", new StringTag("id", enchantment.getJavaIdentifier()));
                    ShortTag levelTag = (ShortTag)tagValue.get("lvl");
                    javaValue.put("lvl", new IntTag("lvl", levelTag != null ? (int)levelTag.getValue().shortValue() : 1));
                    javaTag.setValue((Map<String, Tag>)javaValue);
                    enchantments.add(javaTag);
                    continue;
                }
                GeyserImpl.getInstance().getLogger().debug("Unknown bedrock enchantment: " + bedrockId);
            }
            if (!enchantments.isEmpty()) {
                if (this instanceof EnchantedBookItem) {
                    tag.put(new ListTag("StoredEnchantments", enchantments));
                } else {
                    tag.put(new ListTag("Enchantments", enchantments));
                }
            }
        }
    }

    protected final @Nullable CompoundTag remapEnchantment(GeyserSession session, CompoundTag tag, CompoundTag rootTag) {
        short s;
        Object object;
        Object javaEnchId = tag.get("id");
        if (!(javaEnchId instanceof StringTag)) {
            return null;
        }
        Enchantment enchantment = Enchantment.getByJavaIdentifier(((StringTag)javaEnchId).getValue());
        if (enchantment == null) {
            if (Identifier.formalize((String)((Tag)javaEnchId).getValue()).equals("minecraft:sweeping")) {
                int n;
                Object object2;
                Object javaEnchLvl = tag.get("lvl");
                if (javaEnchLvl != null && (object2 = ((Tag)javaEnchLvl).getValue()) instanceof Number) {
                    Number lvl = (Number)object2;
                    n = lvl.intValue();
                } else {
                    n = 0;
                }
                int sweepingLvl = n;
                this.addSweeping(session, rootTag, sweepingLvl);
                return null;
            }
            GeyserImpl.getInstance().getLogger().debug("Unknown Java enchantment while NBT item translating: " + ((Tag)javaEnchId).getValue());
            return null;
        }
        Object javaEnchLvl = tag.get("lvl");
        CompoundTag bedrockTag = new CompoundTag("");
        bedrockTag.put(new ShortTag("id", (short)enchantment.ordinal()));
        if (javaEnchLvl != null && (object = ((Tag)javaEnchLvl).getValue()) instanceof Number) {
            Number lvl = (Number)object;
            s = lvl.shortValue();
        } else {
            s = 0;
        }
        bedrockTag.put(new ShortTag("lvl", s));
        return bedrockTag;
    }

    private void addSweeping(GeyserSession session, CompoundTag itemTag, int level) {
        ListTag loreTag;
        CompoundTag displayTag = (CompoundTag)itemTag.get("display");
        if (displayTag == null) {
            displayTag = new CompoundTag("display");
            itemTag.put(displayTag);
        }
        if ((loreTag = (ListTag)displayTag.get("Lore")) == null) {
            loreTag = new ListTag("Lore");
            displayTag.put(loreTag);
        }
        String sweepingTranslation = MinecraftLocale.getLocaleString("enchantment.minecraft.sweeping", session.locale());
        String lvlTranslation = MinecraftLocale.getLocaleString("enchantment.level." + level, session.locale());
        loreTag.add(new StringTag("", "\u00a7r\u00a77" + sweepingTranslation + " " + lvlTranslation));
    }

    public ItemStack newItemStack(int count, CompoundTag tag) {
        return new ItemStack(this.javaId, count, tag);
    }

    public void setJavaId(int javaId) {
        if (this.javaId != -1) {
            throw new RuntimeException("Item ID has already been set!");
        }
        this.javaId = javaId;
    }

    public String toString() {
        return "Item{javaIdentifier='" + this.javaIdentifier + "', javaId=" + this.javaId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int stackSize = 64;
        private String toolType;
        private int maxDamage;

        public Builder stackSize(int stackSize) {
            this.stackSize = stackSize;
            return this;
        }

        public Builder setToolType(String toolType) {
            this.toolType = toolType;
            return this;
        }

        public Builder maxDamage(int maxDamage) {
            this.maxDamage = maxDamage;
            return this;
        }

        private Builder() {
        }
    }
}

