/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.recipe.Ingredient;
import com.github.steveice10.mc.protocol.data.game.recipe.RecipeType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtUtils;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.MultiRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.RecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.ShapedRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.ShapelessRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.recipe.GeyserRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapedRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapelessRecipe;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;
import org.geysermc.geyser.util.InventoryUtils;

public class RecipeRegistryPopulator {
    public static void populate() {
        JsonNode items;
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow("mappings/recipes.json");){
            items = GeyserImpl.JSON_MAPPER.readTree(stream);
        }
        catch (Exception e) {
            throw new AssertionError(GeyserLocale.getLocaleStringLog("geyser.toolbox.fail.runtime_java"), e);
        }
        int currentRecipeId = InventoryUtils.LAST_RECIPE_NET_ID;
        for (Int2ObjectMap.Entry entry : ((Int2ObjectMap)Registries.ITEMS.get()).int2ObjectEntrySet()) {
            InventoryUtils.LAST_RECIPE_NET_ID = currentRecipeId;
            EnumMap<RecipeType, List> craftingData = new EnumMap<RecipeType, List>(RecipeType.class);
            Int2ObjectOpenHashMap<GeyserRecipe> recipes = new Int2ObjectOpenHashMap<GeyserRecipe>();
            craftingData.put(RecipeType.CRAFTING_SPECIAL_BOOKCLONING, Collections.singletonList(MultiRecipeData.of(UUID.fromString("d1ca6b84-338e-4f2f-9c6b-76cc8b4bd98d"), ++InventoryUtils.LAST_RECIPE_NET_ID)));
            craftingData.put(RecipeType.CRAFTING_SPECIAL_REPAIRITEM, Collections.singletonList(MultiRecipeData.of(UUID.fromString("00000000-0000-0000-0000-000000000001"), ++InventoryUtils.LAST_RECIPE_NET_ID)));
            craftingData.put(RecipeType.CRAFTING_SPECIAL_MAPEXTENDING, Collections.singletonList(MultiRecipeData.of(UUID.fromString("d392b075-4ba1-40ae-8789-af868d56f6ce"), ++InventoryUtils.LAST_RECIPE_NET_ID)));
            craftingData.put(RecipeType.CRAFTING_SPECIAL_MAPCLONING, Collections.singletonList(MultiRecipeData.of(UUID.fromString("85939755-ba10-4d9d-a4cc-efb7a8e943c4"), ++InventoryUtils.LAST_RECIPE_NET_ID)));
            for (JsonNode entry2 : items.get("leather_armor")) {
                craftingData.computeIfAbsent(RecipeType.CRAFTING_SPECIAL_ARMORDYE, c -> new ObjectArrayList()).add(RecipeRegistryPopulator.getCraftingDataFromJsonNode(entry2, recipes, (ItemMappings)entry.getValue()));
            }
            for (JsonNode entry2 : items.get("firework_rockets")) {
                craftingData.computeIfAbsent(RecipeType.CRAFTING_SPECIAL_FIREWORK_ROCKET, c -> new ObjectArrayList()).add(RecipeRegistryPopulator.getCraftingDataFromJsonNode(entry2, recipes, (ItemMappings)entry.getValue()));
            }
            for (JsonNode entry2 : items.get("firework_stars")) {
                craftingData.computeIfAbsent(RecipeType.CRAFTING_SPECIAL_FIREWORK_STAR, c -> new ObjectArrayList()).add(RecipeRegistryPopulator.getCraftingDataFromJsonNode(entry2, recipes, (ItemMappings)entry.getValue()));
            }
            for (JsonNode entry2 : items.get("shulker_boxes")) {
                craftingData.computeIfAbsent(RecipeType.CRAFTING_SPECIAL_SHULKERBOXCOLORING, c -> new ObjectArrayList()).add(RecipeRegistryPopulator.getCraftingDataFromJsonNode(entry2, recipes, (ItemMappings)entry.getValue()));
            }
            for (JsonNode entry2 : items.get("suspicious_stew")) {
                craftingData.computeIfAbsent(RecipeType.CRAFTING_SPECIAL_SUSPICIOUSSTEW, c -> new ObjectArrayList()).add(RecipeRegistryPopulator.getCraftingDataFromJsonNode(entry2, recipes, (ItemMappings)entry.getValue()));
            }
            for (JsonNode entry2 : items.get("tipped_arrows")) {
                craftingData.computeIfAbsent(RecipeType.CRAFTING_SPECIAL_TIPPEDARROW, c -> new ObjectArrayList()).add(RecipeRegistryPopulator.getCraftingDataFromJsonNode(entry2, recipes, (ItemMappings)entry.getValue()));
            }
            Registries.CRAFTING_DATA.register(entry.getIntKey(), craftingData);
            Registries.RECIPES.register(entry.getIntKey(), recipes);
        }
    }

    private static RecipeData getCraftingDataFromJsonNode(JsonNode node, Int2ObjectMap<GeyserRecipe> recipes, ItemMappings mappings) {
        int netId = ++InventoryUtils.LAST_RECIPE_NET_ID;
        int type = node.get("bedrockRecipeType").asInt();
        JsonNode outputNode = node.get("output");
        ItemMapping outputEntry = mappings.getMapping(outputNode.get("identifier").asText());
        ItemData output = RecipeRegistryPopulator.getBedrockItemFromIdentifierJson(outputEntry, outputNode);
        UUID uuid = UUID.randomUUID();
        if (type == 1) {
            ArrayList<String> shape = new ArrayList<String>();
            for (JsonNode chars : node.get("shape")) {
                shape.add(chars.asText());
            }
            HashMap<String, ItemData> letterToRecipe = new HashMap<String, ItemData>();
            Iterator<Map.Entry<String, JsonNode>> iterator = node.get("inputs").fields();
            while (iterator.hasNext()) {
                Map.Entry<String, JsonNode> entry = iterator.next();
                JsonNode inputNode = entry.getValue();
                ItemMapping inputEntry = mappings.getMapping(inputNode.get("identifier").asText());
                letterToRecipe.put(entry.getKey(), RecipeRegistryPopulator.getBedrockItemFromIdentifierJson(inputEntry, inputNode));
            }
            ArrayList<ItemData> inputs = new ArrayList<ItemData>(shape.size() * ((String)shape.get(0)).length());
            int i = 0;
            int j = 0;
            while (i < shape.size() * ((String)shape.get(0)).length()) {
                for (char c : ((String)shape.get(j)).toCharArray()) {
                    ItemData data = letterToRecipe.getOrDefault(String.valueOf(c), ItemData.AIR);
                    inputs.add(data);
                    ++i;
                }
                ++j;
            }
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            Object object = inputs.iterator();
            while (object.hasNext()) {
                ItemData input = (ItemData)object.next();
                ingredients.add(new Ingredient(new ItemStack[]{ItemTranslator.translateToJava(input, mappings)}));
            }
            GeyserShapedRecipe recipe = new GeyserShapedRecipe(((String)shape.get(0)).length(), shape.size(), ingredients.toArray(new Ingredient[0]), ItemTranslator.translateToJava(output, mappings));
            recipes.put(netId, (GeyserRecipe)recipe);
            return ShapedRecipeData.shaped(uuid.toString(), ((String)shape.get(0)).length(), shape.size(), inputs.stream().map(ItemDescriptorWithCount::fromItem).toList(), Collections.singletonList(output), uuid, "crafting_table", 0, netId);
        }
        ObjectArrayList inputs = new ObjectArrayList();
        for (Object entry : node.get("inputs")) {
            ItemMapping inputEntry = mappings.getMapping(((JsonNode)entry).get("identifier").asText());
            inputs.add(RecipeRegistryPopulator.getBedrockItemFromIdentifierJson(inputEntry, (JsonNode)entry));
        }
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (ItemData input : inputs) {
            ingredients.add(new Ingredient(new ItemStack[]{ItemTranslator.translateToJava(input, mappings)}));
        }
        GeyserShapelessRecipe recipe = new GeyserShapelessRecipe(ingredients.toArray(new Ingredient[0]), ItemTranslator.translateToJava(output, mappings));
        recipes.put(netId, (GeyserRecipe)recipe);
        if (type == 5) {
            return ShapelessRecipeData.shulkerBox(uuid.toString(), inputs.stream().map(ItemDescriptorWithCount::fromItem).toList(), Collections.singletonList(output), uuid, "crafting_table", 0, netId);
        }
        return ShapelessRecipeData.shapeless(uuid.toString(), inputs.stream().map(ItemDescriptorWithCount::fromItem).toList(), Collections.singletonList(output), uuid, "crafting_table", 0, netId);
    }

    private static ItemData getBedrockItemFromIdentifierJson(ItemMapping mapping, JsonNode itemNode) {
        JsonNode nbtNode;
        JsonNode countNode;
        int count = 1;
        short damage = 0;
        NbtMap tag = null;
        JsonNode damageNode = itemNode.get("bedrockDamage");
        if (damageNode != null) {
            damage = damageNode.numberValue().shortValue();
        }
        if ((countNode = itemNode.get("count")) != null) {
            count = countNode.asInt();
        }
        if ((nbtNode = itemNode.get("bedrockNbt")) != null) {
            byte[] bytes = Base64.getDecoder().decode(nbtNode.asText());
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            try {
                tag = (NbtMap)NbtUtils.createReaderLE(bais).readTag();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ItemData.builder().definition(mapping.getBedrockDefinition()).damage(damage).count(count).blockDefinition(mapping.getBedrockBlockDefinition()).tag(tag).build();
    }
}

