/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector2d;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.LevelEventType;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;

public class WorldBorder {
    private static final double DEFAULT_WORLD_BORDER_SIZE = 5.9999968E7;
    private @NonNull Vector2d center = Vector2d.ZERO;
    private double oldDiameter = 5.9999968E7;
    private double newDiameter = 5.9999968E7;
    private long speed = 0L;
    private int warningDelay = 15;
    private int warningBlocks = 5;
    private int absoluteMaxSize = 29999984;
    private double worldCoordinateScale = 1.0;
    private boolean resizing;
    private double currentDiameter;
    private double minX = 0.0;
    private double minZ = 0.0;
    private double maxX = 0.0;
    private double maxZ = 0.0;
    private double warningMaxX = 0.0;
    private double warningMaxZ = 0.0;
    private double warningMinX = 0.0;
    private double warningMinZ = 0.0;
    private int currentWallTick;
    private long lastUpdatedWorldBorderTime = 0L;
    private final GeyserSession session;
    private static final int CLOSE_TO_BORDER = 5;
    private static final LevelEventType WORLD_BORDER_PARTICLE = LevelEvent.PARTICLE_DENY_BLOCK;

    public WorldBorder(GeyserSession session) {
        this.session = session;
        this.update();
    }

    public void setWorldCoordinateScale(double worldCoordinateScale) {
        boolean needsUpdate = worldCoordinateScale != this.worldCoordinateScale;
        this.worldCoordinateScale = worldCoordinateScale;
        if (needsUpdate) {
            this.update();
        }
    }

    public boolean isInsideBorderBoundaries() {
        return this.isInsideBorderBoundaries(this.session.getPlayerEntity().getPosition());
    }

    public boolean isInsideBorderBoundaries(Vector3f position) {
        return (double)position.getX() > this.minX && (double)position.getX() < this.maxX && (double)position.getZ() > this.minZ && (double)position.getZ() < this.maxZ;
    }

    public boolean isCloseToBorderBoundaries() {
        Vector3f position = this.session.getPlayerEntity().getPosition();
        return !((double)position.getX() > this.minX + 5.0 && (double)position.getX() < this.maxX - 5.0 && (double)position.getZ() > this.minZ + 5.0 && (double)position.getZ() < this.maxZ - 5.0);
    }

    public boolean isPassingIntoBorderBoundaries(Vector3f newPosition, boolean adjustPosition) {
        boolean isInWorldBorder = this.isPassingIntoBorderBoundaries(newPosition);
        if (isInWorldBorder && adjustPosition) {
            SessionPlayerEntity playerEntity = this.session.getPlayerEntity();
            playerEntity.moveAbsolute(Vector3f.from(playerEntity.getPosition().getX(), newPosition.getY() - EntityDefinitions.PLAYER.offset(), playerEntity.getPosition().getZ()), playerEntity.getYaw(), playerEntity.getPitch(), playerEntity.getHeadYaw(), playerEntity.isOnGround(), playerEntity.getVehicle() == null);
        }
        return isInWorldBorder;
    }

    public boolean isPassingIntoBorderBoundaries(Vector3f newEntityPosition) {
        int entityX = GenericMath.floor(newEntityPosition.getX());
        int entityZ = GenericMath.floor(newEntityPosition.getZ());
        Vector3f currentEntityPosition = this.session.getPlayerEntity().getPosition();
        return entityX == (int)this.minX && currentEntityPosition.getX() > newEntityPosition.getX() || entityX == (int)this.maxX && currentEntityPosition.getX() < newEntityPosition.getX() || entityZ == (int)this.minZ && currentEntityPosition.getZ() > newEntityPosition.getZ() || entityZ == (int)this.maxZ && currentEntityPosition.getZ() < newEntityPosition.getZ();
    }

    public boolean isWithinWarningBoundaries() {
        Vector3f entityPosition = this.session.getPlayerEntity().getPosition();
        return (double)entityPosition.getX() > this.warningMinX && (double)entityPosition.getX() < this.warningMaxX && (double)entityPosition.getZ() > this.warningMinZ && (double)entityPosition.getZ() < this.warningMaxZ;
    }

    public void update() {
        double radius = this.resizing ? this.currentDiameter / 2.0 : this.newDiameter / 2.0;
        double absoluteMinSize = -this.absoluteMaxSize;
        double centerX = this.center.getX() / this.worldCoordinateScale;
        double centerZ = this.center.getY() / this.worldCoordinateScale;
        this.minX = GenericMath.clamp(centerX - radius, absoluteMinSize, (double)this.absoluteMaxSize);
        this.minZ = GenericMath.clamp(centerZ - radius, absoluteMinSize, (double)this.absoluteMaxSize);
        this.maxX = GenericMath.clamp(centerX + radius, absoluteMinSize, (double)this.absoluteMaxSize);
        this.maxZ = GenericMath.clamp(centerZ + radius, absoluteMinSize, (double)this.absoluteMaxSize);
        this.warningMinX = this.minX + (double)this.warningBlocks;
        this.warningMinZ = this.minZ + (double)this.warningBlocks;
        this.warningMaxX = this.maxX - (double)this.warningBlocks;
        this.warningMaxZ = this.maxZ - (double)this.warningBlocks;
    }

    public void resize() {
        if (this.lastUpdatedWorldBorderTime >= this.speed) {
            this.resizing = false;
            this.lastUpdatedWorldBorderTime = 0L;
        } else if (this.resizing) {
            this.currentDiameter = this.oldDiameter + (double)this.lastUpdatedWorldBorderTime / (double)this.speed * (this.newDiameter - this.oldDiameter);
            this.lastUpdatedWorldBorderTime += 50L;
        }
        this.update();
    }

    public void setResizing(boolean resizing) {
        this.resizing = resizing;
        if (!resizing) {
            this.lastUpdatedWorldBorderTime = 0L;
        }
    }

    public void drawWall() {
        if (this.currentWallTick++ != 20) {
            return;
        }
        this.currentWallTick = 0;
        Vector3f entityPosition = this.session.getPlayerEntity().getPosition();
        float particlePosX = entityPosition.getX();
        float particlePosY = entityPosition.getY();
        float particlePosZ = entityPosition.getZ();
        if ((double)entityPosition.getX() > Math.min(this.warningMaxX, this.maxX - 5.0)) {
            this.drawWall(Vector3f.from(this.maxX, (double)particlePosY, (double)particlePosZ), true);
        }
        if ((double)entityPosition.getX() < Math.max(this.warningMinX, this.minX + 5.0)) {
            this.drawWall(Vector3f.from(this.minX, (double)particlePosY, (double)particlePosZ), true);
        }
        if ((double)entityPosition.getZ() > Math.min(this.warningMaxZ, this.maxZ - 5.0)) {
            this.drawWall(Vector3f.from((double)particlePosX, (double)particlePosY, this.maxZ), false);
        }
        if ((double)entityPosition.getZ() < Math.max(this.warningMinZ, this.minZ + 5.0)) {
            this.drawWall(Vector3f.from((double)particlePosX, (double)particlePosY, this.minZ), false);
        }
    }

    private void drawWall(Vector3f position, boolean drawWallX) {
        int initialY;
        block0: for (int y = initialY = (int)(position.getY() - EntityDefinitions.PLAYER.offset() - 1.0f); y < initialY + 5; ++y) {
            if (drawWallX) {
                float x = position.getX();
                for (int z = (int)position.getZ() - 3; z < (int)position.getZ() + 3; ++z) {
                    if ((double)z < this.minZ) continue;
                    if ((double)z > this.maxZ) continue block0;
                    this.sendWorldBorderParticle(x, y, z);
                }
                continue;
            }
            float z = position.getZ();
            for (int x = (int)position.getX() - 3; x < (int)position.getX() + 3; ++x) {
                if ((double)x < this.minX) continue;
                if ((double)x > this.maxX) continue block0;
                this.sendWorldBorderParticle(x, y, z);
            }
        }
    }

    private void sendWorldBorderParticle(float x, float y, float z) {
        LevelEventPacket effectPacket = new LevelEventPacket();
        effectPacket.setPosition(Vector3f.from(x, y, z));
        effectPacket.setType(WORLD_BORDER_PARTICLE);
        this.session.getUpstream().sendPacket(effectPacket);
    }

    public void setCenter(@NonNull Vector2d center) {
        if (center == null) {
            throw new NullPointerException("center is marked non-null but is null");
        }
        this.center = center;
    }

    public void setOldDiameter(double oldDiameter) {
        this.oldDiameter = oldDiameter;
    }

    public void setNewDiameter(double newDiameter) {
        this.newDiameter = newDiameter;
    }

    public void setSpeed(long speed) {
        this.speed = speed;
    }

    public void setWarningDelay(int warningDelay) {
        this.warningDelay = warningDelay;
    }

    public void setWarningBlocks(int warningBlocks) {
        this.warningBlocks = warningBlocks;
    }

    public void setAbsoluteMaxSize(int absoluteMaxSize) {
        this.absoluteMaxSize = absoluteMaxSize;
    }

    public boolean isResizing() {
        return this.resizing;
    }
}

