/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.item;

import com.github.steveice10.mc.protocol.data.game.Identifier;
import com.github.steveice10.mc.protocol.data.game.entity.attribute.ModifierOperation;
import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.opennbt.tag.builtin.ByteArrayTag;
import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.DoubleTag;
import com.github.steveice10.opennbt.tag.builtin.FloatTag;
import com.github.steveice10.opennbt.tag.builtin.IntArrayTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.LongArrayTag;
import com.github.steveice10.opennbt.tag.builtin.LongTag;
import com.github.steveice10.opennbt.tag.builtin.ShortTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.TextComponent;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.NamedTextColor;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.CustomSkull;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.inventory.item.CustomItemTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.InventoryUtils;

public final class ItemTranslator {
    private static final String[] ALL_SLOTS = new String[]{"mainhand", "offhand", "feet", "legs", "chest", "head"};
    private static final DecimalFormat ATTRIBUTE_FORMAT = new DecimalFormat("0.#####");
    private static final byte HIDE_ATTRIBUTES_FLAG = 2;

    private ItemTranslator() {
    }

    public static ItemStack translateToJava(ItemData data, ItemMappings mappings) {
        if (data == null) {
            return new ItemStack(Items.AIR_ID);
        }
        ItemMapping bedrockItem = mappings.getMapping(data);
        Item javaItem = bedrockItem.getJavaItem();
        ItemStack itemStack = javaItem.translateToJava(data, bedrockItem, mappings);
        if (itemStack.getNbt() != null) {
            javaItem.translateNbtToJava(itemStack.getNbt(), bedrockItem);
            if (itemStack.getNbt().isEmpty()) {
                itemStack = new ItemStack(itemStack.getId(), itemStack.getAmount(), null);
            }
        }
        return itemStack;
    }

    public static @NonNull ItemData.Builder translateToBedrock(GeyserSession session, int javaId, int count, CompoundTag tag) {
        ItemMapping bedrockItem = session.getItemMappings().getMapping(javaId);
        if (bedrockItem == ItemMapping.AIR) {
            session.getGeyser().getLogger().debug("ItemMapping returned air: " + javaId);
            return ItemData.builder();
        }
        return ItemTranslator.translateToBedrock(session, (Item)((List)Registries.JAVA_ITEMS.get()).get(javaId), bedrockItem, count, tag);
    }

    public static @NonNull ItemData translateToBedrock(GeyserSession session, ItemStack stack) {
        if (InventoryUtils.isEmpty(stack)) {
            return ItemData.AIR;
        }
        ItemMapping bedrockItem = session.getItemMappings().getMapping(stack);
        if (bedrockItem == ItemMapping.AIR) {
            session.getGeyser().getLogger().debug("ItemMapping returned air: " + stack);
            return ItemData.AIR;
        }
        return ItemTranslator.translateToBedrock(session, (Item)((List)Registries.JAVA_ITEMS.get()).get(stack.getId()), bedrockItem, stack.getAmount(), stack.getNbt()).build();
    }

    private static @NonNull ItemData.Builder translateToBedrock(GeyserSession session, Item javaItem, ItemMapping bedrockItem, int count, CompoundTag tag) {
        Object hideFlags;
        CompoundTag nbt;
        CompoundTag compoundTag = nbt = tag != null ? tag.clone() : null;
        if (nbt != null) {
            javaItem.translateNbtToBedrock(session, nbt);
        }
        if (!((nbt = ItemTranslator.translateDisplayProperties(session, nbt, bedrockItem)) == null || (hideFlags = nbt.get("HideFlags")) != null && ItemTranslator.hasFlagPresent(hideFlags, (byte)2))) {
            ItemTranslator.addAttributeLore(nbt, session.locale());
        }
        if (session.isAdvancedTooltips()) {
            nbt = ItemTranslator.addAdvancedTooltips(nbt, javaItem, session.locale());
        }
        ItemStack itemStack = new ItemStack(javaItem.javaId(), count, nbt);
        ItemData.Builder builder = javaItem.translateToBedrock(itemStack, bedrockItem, session.getItemMappings());
        if (bedrockItem.isBlock()) {
            CustomBlockData customBlockData = BlockRegistries.CUSTOM_BLOCK_ITEM_OVERRIDES.getOrDefault(bedrockItem.getJavaItem().javaIdentifier(), null);
            if (customBlockData != null) {
                ItemTranslator.translateCustomBlock(customBlockData, session, builder);
            } else {
                builder.blockDefinition(bedrockItem.getBedrockBlockDefinition());
            }
        }
        if (bedrockItem.getJavaItem().equals(Items.PLAYER_HEAD)) {
            ItemTranslator.translatePlayerHead(session, nbt, builder);
        }
        ItemTranslator.translateCustomItem(nbt, builder, bedrockItem);
        if (nbt != null) {
            ListTag canDestroy = (ListTag)nbt.get("CanDestroy");
            ListTag canPlaceOn = (ListTag)nbt.get("CanPlaceOn");
            String[] canBreak = ItemTranslator.getCanModify(canDestroy);
            String[] canPlace = ItemTranslator.getCanModify(canPlaceOn);
            if (canBreak != null) {
                builder.canBreak(canBreak);
            }
            if (canPlace != null) {
                builder.canPlace(canPlace);
            }
        }
        return builder;
    }

    private static void addAttributeLore(CompoundTag nbt, String language) {
        ListTag lore;
        ListTag attributeModifiers = (ListTag)nbt.get("AttributeModifiers");
        if (attributeModifiers == null) {
            return;
        }
        CompoundTag displayTag = (CompoundTag)nbt.get("display");
        if (displayTag == null) {
            displayTag = new CompoundTag("display");
        }
        if ((lore = (ListTag)displayTag.get("Lore")) == null) {
            lore = new ListTag("Lore");
        }
        HashMap<String, List> slotsToModifiers = new HashMap<String, List>();
        for (Tag modifier : attributeModifiers) {
            CompoundTag modifierTag = (CompoundTag)modifier;
            String loreEntry = ItemTranslator.attributeToLore(modifierTag, language);
            if (loreEntry == null) continue;
            StringTag loreTag = new StringTag("", loreEntry);
            StringTag slotTag = (StringTag)modifierTag.get("Slot");
            if (slotTag == null) {
                for (String slot : ALL_SLOTS) {
                    slotsToModifiers.computeIfAbsent(slot, s -> new ArrayList()).add(loreTag);
                }
                continue;
            }
            slotsToModifiers.computeIfAbsent(slotTag.getValue(), s -> new ArrayList()).add(loreTag);
        }
        for (String slot : ALL_SLOTS) {
            List modifiers = (List)slotsToModifiers.get(slot);
            if (modifiers == null || modifiers.isEmpty()) continue;
            Object slotComponent = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().resetStyle()).color(NamedTextColor.GRAY)).append(Component.newline(), Component.translatable("item.modifiers." + slot))).build();
            lore.add(new StringTag("", MessageTranslator.convertMessage((Component)slotComponent, language)));
            for (StringTag modifier : modifiers) {
                lore.add(modifier);
            }
        }
        displayTag.put(lore);
        nbt.put(displayTag);
    }

    private static @Nullable String attributeToLore(CompoundTag modifier, String language) {
        Object operationTotal;
        ModifierOperation operation;
        Object object;
        Object amountTag = modifier.get("Amount");
        if (amountTag == null || !((object = ((Tag)amountTag).getValue()) instanceof Number)) {
            return null;
        }
        Number number = (Number)object;
        double amount = number.doubleValue();
        if (amount == 0.0) {
            return null;
        }
        Object t = modifier.get("AttributeName");
        if (!(t instanceof StringTag)) {
            return null;
        }
        StringTag nameTag = (StringTag)t;
        String name = nameTag.getValue().replace("minecraft:", "");
        Object operationTag = modifier.get("Operation");
        if (operationTag == null || (operation = ModifierOperation.from((Integer)((Tag)operationTag).getValue())) == ModifierOperation.ADD) {
            if (name.equals("generic.knockback_resistance")) {
                amount *= 10.0;
            }
            operationTotal = ATTRIBUTE_FORMAT.format(amount);
        } else if (operation == ModifierOperation.ADD_MULTIPLIED || operation == ModifierOperation.MULTIPLY) {
            operationTotal = ATTRIBUTE_FORMAT.format(amount * 100.0) + "%";
        } else {
            GeyserImpl.getInstance().getLogger().warning("Unhandled ModifierOperation while adding item attributes: " + operation);
            return null;
        }
        if (amount > 0.0) {
            operationTotal = "+" + (String)operationTotal;
        }
        Object attributeComponent = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().resetStyle()).color(amount > 0.0 ? NamedTextColor.BLUE : NamedTextColor.RED)).append(Component.text((String)operationTotal + " "), Component.translatable("attribute.name." + name))).build();
        return MessageTranslator.convertMessage((Component)attributeComponent, language);
    }

    private static CompoundTag addAdvancedTooltips(CompoundTag nbt, Item item, String language) {
        int durability;
        Object durabilityTag;
        int maxDurability;
        ListTag listTag;
        CompoundTag compoundTag;
        CompoundTag newNbt = nbt;
        if (newNbt == null) {
            newNbt = new CompoundTag("nbt");
            CompoundTag display = new CompoundTag("display");
            display.put(new ListTag("Lore"));
            newNbt.put(display);
        }
        if ((compoundTag = (CompoundTag)newNbt.get("display")) == null) {
            compoundTag = new CompoundTag("display");
        }
        if ((listTag = (ListTag)compoundTag.get("Lore")) == null) {
            listTag = new ListTag("Lore");
        }
        if ((maxDurability = item.maxDamage()) != 0 && (durabilityTag = newNbt.get("Damage")) instanceof IntTag && (durability = maxDurability - ((IntTag)durabilityTag).getValue()) != maxDurability) {
            Object component = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().resetStyle()).color(NamedTextColor.WHITE)).append((Component)Component.translatable("item.durability", Component.text(durability), Component.text(maxDurability)))).build();
            listTag.add(new StringTag("", MessageTranslator.convertMessage((Component)component, language)));
        }
        listTag.add(new StringTag("", "\u00a7r\u00a78" + item.javaIdentifier()));
        if (nbt != null) {
            Object component = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().resetStyle()).color(NamedTextColor.DARK_GRAY)).append((Component)Component.translatable("item.nbt_tags", Component.text(nbt.size())))).build();
            listTag.add(new StringTag("", MessageTranslator.convertMessage((Component)component, language)));
        }
        compoundTag.put(listTag);
        newNbt.put(compoundTag);
        return newNbt;
    }

    private static String @Nullable [] getCanModify(ListTag canModifyJava) {
        if (canModifyJava != null && canModifyJava.size() > 0) {
            String[] canModifyBedrock = new String[canModifyJava.size()];
            for (int i = 0; i < canModifyBedrock.length; ++i) {
                String block = Identifier.formalize(((StringTag)canModifyJava.get(i)).getValue());
                canModifyBedrock[i] = BlockRegistries.JAVA_TO_BEDROCK_IDENTIFIERS.getOrDefault(block, block).replace("minecraft:", "");
            }
            return canModifyBedrock;
        }
        return null;
    }

    public static @NonNull ItemDefinition getBedrockItemDefinition(GeyserSession session, @NonNull GeyserItemStack itemStack) {
        ItemDefinition definition;
        CustomSkull customSkull;
        if (itemStack.isEmpty()) {
            return ItemDefinition.AIR;
        }
        ItemMapping mapping = itemStack.asItem().toBedrockDefinition(itemStack.getNbt(), session.getItemMappings());
        ItemDefinition itemDefinition = mapping.getBedrockDefinition();
        CustomBlockData customBlockData = BlockRegistries.CUSTOM_BLOCK_ITEM_OVERRIDES.getOrDefault(mapping.getJavaItem().javaIdentifier(), null);
        if (customBlockData != null) {
            itemDefinition = (ItemDefinition)session.getItemMappings().getCustomBlockItemDefinitions().get(customBlockData);
        }
        if (mapping.getJavaItem().equals(Items.PLAYER_HEAD) && (customSkull = ItemTranslator.getCustomSkull(session, itemStack.getNbt())) != null) {
            itemDefinition = (ItemDefinition)session.getItemMappings().getCustomBlockItemDefinitions().get(customSkull.getCustomBlockData());
        }
        if ((definition = CustomItemTranslator.getCustomItem(itemStack.getNbt(), mapping)) == null) {
            return itemDefinition;
        }
        return definition;
    }

    public static NbtMap translateNbtToBedrock(CompoundTag tag) {
        if (!tag.getValue().isEmpty()) {
            NbtMapBuilder builder = NbtMap.builder();
            for (Tag javaTag : tag.values()) {
                Object translatedTag = ItemTranslator.translateToBedrockNBT(javaTag);
                if (translatedTag == null) continue;
                builder.put(javaTag.getName(), translatedTag);
            }
            return builder.build();
        }
        return NbtMap.EMPTY;
    }

    private static @Nullable Object translateToBedrockNBT(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return ItemTranslator.translateNbtToBedrock(compoundTag);
        }
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            ArrayList<Object> tagList = new ArrayList<Object>();
            for (Tag value : listTag) {
                tagList.add(ItemTranslator.translateToBedrockNBT(value));
            }
            NbtType<NbtMap> type = NbtType.COMPOUND;
            if (!tagList.isEmpty()) {
                type = NbtType.byClass(tagList.get(0).getClass());
            }
            return new NbtList<NbtMap>(type, (Collection<NbtMap>)tagList);
        }
        if (tag instanceof LongArrayTag) {
            return null;
        }
        return tag.getValue();
    }

    public static CompoundTag translateToJavaNBT(String name, NbtMap tag) {
        CompoundTag javaTag = new CompoundTag(name);
        Object javaValue = javaTag.getValue();
        if (tag != null && !tag.isEmpty()) {
            for (Map.Entry<String, Object> entry : tag.entrySet()) {
                Tag translatedTag = ItemTranslator.translateToJavaNBT(entry.getKey(), entry.getValue());
                if (translatedTag == null) continue;
                javaValue.put(translatedTag.getName(), translatedTag);
            }
        }
        javaTag.setValue((Map<String, Tag>)javaValue);
        return javaTag;
    }

    private static @Nullable Tag translateToJavaNBT(String name, Object object) {
        if (object instanceof int[]) {
            return new IntArrayTag(name, (int[])object);
        }
        if (object instanceof byte[]) {
            return new ByteArrayTag(name, (byte[])object);
        }
        if (object instanceof Byte) {
            return new ByteTag(name, (Byte)object);
        }
        if (object instanceof Float) {
            return new FloatTag(name, ((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return new DoubleTag(name, (Double)object);
        }
        if (object instanceof Integer) {
            return new IntTag(name, (Integer)object);
        }
        if (object instanceof long[]) {
            return new LongArrayTag(name, (long[])object);
        }
        if (object instanceof Long) {
            return new LongTag(name, (Long)object);
        }
        if (object instanceof Short) {
            return new ShortTag(name, (Short)object);
        }
        if (object instanceof String) {
            return new StringTag(name, (String)object);
        }
        if (object instanceof List) {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (Object value : (List)object) {
                Tag javaTag = ItemTranslator.translateToJavaNBT("", value);
                if (javaTag == null) continue;
                tags.add(javaTag);
            }
            return new ListTag(name, tags);
        }
        if (object instanceof NbtMap) {
            NbtMap map = (NbtMap)object;
            return ItemTranslator.translateToJavaNBT(name, map);
        }
        return null;
    }

    public static CompoundTag translateDisplayProperties(GeyserSession session, CompoundTag tag, ItemMapping mapping) {
        return ItemTranslator.translateDisplayProperties(session, tag, mapping, 'f');
    }

    public static CompoundTag translateDisplayProperties(GeyserSession session, CompoundTag tag, ItemMapping mapping, char translationColor) {
        CompoundTag display;
        Object t;
        boolean hasCustomName = false;
        if (tag != null && (t = tag.get("display")) instanceof CompoundTag && (t = (display = (CompoundTag)t).get("Name")) instanceof StringTag) {
            StringTag tagName = (StringTag)t;
            String name = tagName.getValue();
            name = MessageTranslator.convertMessageLenient(name, session.locale());
            display.put(new StringTag("Name", name));
            hasCustomName = true;
            tag.put(display);
        }
        if (!hasCustomName && mapping.hasTranslation()) {
            if (tag == null) {
                tag = new CompoundTag("");
            }
            if ((t = tag.get("display")) instanceof CompoundTag) {
                CompoundTag oldDisplay;
                display = oldDisplay = (CompoundTag)t;
            } else {
                display = new CompoundTag("display");
                tag.put(display);
            }
            String translationKey = mapping.getTranslationString();
            display.put(new StringTag("Name", "\u00a7r\u00a7" + translationColor + MinecraftLocale.getLocaleString(translationKey, session.locale())));
        }
        return tag;
    }

    public static void translateCustomItem(CompoundTag nbt, ItemData.Builder builder, ItemMapping mapping) {
        ItemDefinition definition = CustomItemTranslator.getCustomItem(nbt, mapping);
        if (definition != null) {
            builder.definition(definition);
            builder.blockDefinition(null);
        }
    }

    private static void translateCustomBlock(CustomBlockData customBlockData, GeyserSession session, ItemData.Builder builder) {
        ItemDefinition itemDefinition = (ItemDefinition)session.getItemMappings().getCustomBlockItemDefinitions().get(customBlockData);
        BlockDefinition blockDefinition = (BlockDefinition)session.getBlockMappings().getCustomBlockStateDefinitions().get(customBlockData.defaultBlockState());
        builder.definition(itemDefinition);
        builder.blockDefinition(blockDefinition);
    }

    private static @Nullable CustomSkull getCustomSkull(GeyserSession session, CompoundTag nbt) {
        if (nbt != null && nbt.contains("SkullOwner")) {
            Object t = nbt.get("SkullOwner");
            if (!(t instanceof CompoundTag)) {
                return null;
            }
            CompoundTag skullOwner = (CompoundTag)t;
            SkinManager.GameProfileData data = SkinManager.GameProfileData.from(skullOwner);
            if (data == null) {
                session.getGeyser().getLogger().debug("Not sure how to handle skull head item display. " + nbt);
                return null;
            }
            String skinHash = data.skinUrl().substring(data.skinUrl().lastIndexOf(47) + 1);
            return (CustomSkull)BlockRegistries.CUSTOM_SKULLS.get(skinHash);
        }
        return null;
    }

    private static void translatePlayerHead(GeyserSession session, CompoundTag nbt, ItemData.Builder builder) {
        CustomSkull customSkull = ItemTranslator.getCustomSkull(session, nbt);
        if (customSkull != null) {
            CustomBlockData customBlockData = customSkull.getCustomBlockData();
            ItemDefinition itemDefinition = (ItemDefinition)session.getItemMappings().getCustomBlockItemDefinitions().get(customBlockData);
            BlockDefinition blockDefinition = (BlockDefinition)session.getBlockMappings().getCustomBlockStateDefinitions().get(customBlockData.defaultBlockState());
            builder.definition(itemDefinition);
            builder.blockDefinition(blockDefinition);
        }
    }

    private static boolean hasFlagPresent(Tag hideFlags, byte flagMask) {
        Object object = hideFlags.getValue();
        if (object instanceof Number) {
            Number flags = (Number)object;
            return (flags.byteValue() & flagMask) == flagMask;
        }
        return false;
    }
}

