/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import com.github.steveice10.mc.protocol.data.game.level.block.BlockEntityType;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.geyser.item.type.BannerItem;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.level.block.entity.RequiresBlockState;

@BlockEntity(type={BlockEntityType.BANNER})
public class BannerBlockEntityTranslator
extends BlockEntityTranslator
implements RequiresBlockState {
    @Override
    public void translateTag(NbtMapBuilder builder, CompoundTag tag, int blockState) {
        Object customName;
        int bannerColor = BlockStateValues.getBannerColor(blockState);
        if (bannerColor != -1) {
            builder.put("Base", (Object)(15 - bannerColor));
        }
        if (tag == null) {
            return;
        }
        Object t = tag.get("Patterns");
        if (t instanceof ListTag) {
            ListTag patterns = (ListTag)t;
            if (patterns.equals(BannerItem.OMINOUS_BANNER_PATTERN)) {
                builder.putInt("Type", 1);
            } else {
                builder.put("Patterns", (Object)BannerItem.convertBannerPattern(patterns));
            }
        }
        if ((customName = tag.get("CustomName")) != null) {
            builder.put("CustomName", ((Tag)customName).getValue());
        }
    }
}

