/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import com.github.steveice10.mc.protocol.data.game.level.block.BlockEntityType;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.block.DoubleChestValue;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.BedrockOnlyBlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.util.BlockEntityUtils;

@BlockEntity(type={BlockEntityType.CHEST, BlockEntityType.TRAPPED_CHEST})
public class DoubleChestBlockEntityTranslator
extends BlockEntityTranslator
implements BedrockOnlyBlockEntity {
    @Override
    public boolean isBlock(int blockState) {
        return BlockStateValues.getDoubleChestValues().containsKey(blockState);
    }

    @Override
    public void updateBlock(GeyserSession session, int blockState, Vector3i position) {
        NbtMapBuilder tagBuilder = this.getConstantBedrockTag(BlockEntityUtils.getBedrockBlockEntityId(BlockEntityType.CHEST), position.getX(), position.getY(), position.getZ());
        this.translateTag(tagBuilder, null, blockState);
        BlockEntityUtils.updateBlockEntity(session, tagBuilder.build(), position);
    }

    @Override
    public void translateTag(NbtMapBuilder builder, CompoundTag tag, int blockState) {
        DoubleChestValue chestValues = (DoubleChestValue)BlockStateValues.getDoubleChestValues().get(blockState);
        if (chestValues != null) {
            int x = (Integer)builder.get("x");
            int z = (Integer)builder.get("z");
            DoubleChestBlockEntityTranslator.translateChestValue(builder, chestValues, x, z);
        }
    }

    public static void translateChestValue(NbtMapBuilder builder, DoubleChestValue chestValues, int x, int z) {
        if (chestValues.isFacingEast()) {
            z = chestValues.isDirectionPositive() ? (z += chestValues.isLeft() ? 1 : -1) : (z += chestValues.isLeft() ? -1 : 1);
        } else {
            x = chestValues.isDirectionPositive() ? (x += chestValues.isLeft() ? -1 : 1) : (x += chestValues.isLeft() ? 1 : -1);
        }
        builder.put("pairx", (Object)x);
        builder.put("pairz", (Object)z);
        if (!chestValues.isLeft()) {
            builder.put("pairlead", (Object)1);
        }
    }
}

