/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import com.github.steveice10.mc.protocol.packet.configuration.clientbound.ClientboundRegistryDataPacket;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import java.util.Map;
import org.geysermc.geyser.level.JavaDimension;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.TextDecoration;
import org.geysermc.geyser.translator.level.BiomeTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.JavaCodecUtil;

@Translator(packet=ClientboundRegistryDataPacket.class)
public class JavaRegistryDataTranslator
extends PacketTranslator<ClientboundRegistryDataPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundRegistryDataPacket packet) {
        Map<String, JavaDimension> dimensions = session.getDimensions();
        dimensions.clear();
        JavaDimension.load(packet.getRegistry(), dimensions);
        Int2ObjectMap<TextDecoration> chatTypes = session.getChatTypes();
        chatTypes.clear();
        for (CompoundTag tag : JavaCodecUtil.iterateAsTag((CompoundTag)packet.getRegistry().get("minecraft:chat_type"))) {
            int id = ((IntTag)tag.get("id")).getValue();
            CompoundTag element = (CompoundTag)tag.get("element");
            CompoundTag chat = (CompoundTag)element.get("chat");
            TextDecoration textDecoration = null;
            if (chat != null) {
                textDecoration = new TextDecoration(chat);
            }
            chatTypes.put(id, textDecoration);
        }
        BiomeTranslator.loadServerBiomes(session, packet.getRegistry());
    }
}

