/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import com.github.steveice10.mc.protocol.packet.ingame.clientbound.level.ClientboundExplodePacket;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventGenericPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelSoundEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityMotionPacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.ChunkUtils;

@Translator(packet=ClientboundExplodePacket.class)
public class JavaExplodeTranslator
extends PacketTranslator<ClientboundExplodePacket> {
    @Override
    public void translate(GeyserSession session, ClientboundExplodePacket packet) {
        LevelEventGenericPacket levelEventPacket = new LevelEventGenericPacket();
        levelEventPacket.setType(LevelEvent.PARTICLE_BLOCK_EXPLOSION);
        NbtMapBuilder builder = NbtMap.builder();
        builder.putFloat("originX", (float)packet.getX());
        builder.putFloat("originY", (float)packet.getY());
        builder.putFloat("originZ", (float)packet.getZ());
        builder.putFloat("radius", packet.getRadius());
        builder.putInt("size", packet.getExploded().size());
        int i = 0;
        for (Vector3i position : packet.getExploded()) {
            Vector3i pos = Vector3i.from(packet.getX() + (double)position.getX(), packet.getY() + (double)position.getY(), packet.getZ() + (double)position.getZ());
            ChunkUtils.updateBlock(session, 0, pos);
            builder.putFloat("pos" + i + "x", pos.getX());
            builder.putFloat("pos" + i + "y", pos.getY());
            builder.putFloat("pos" + i + "z", pos.getZ());
            ++i;
        }
        levelEventPacket.setTag(builder.build());
        session.sendUpstreamPacket(levelEventPacket);
        Vector3f pos = Vector3f.from(packet.getX(), packet.getY(), packet.getZ());
        LevelSoundEventPacket levelSoundEventPacket = new LevelSoundEventPacket();
        levelSoundEventPacket.setRelativeVolumeDisabled(false);
        levelSoundEventPacket.setBabySound(false);
        levelSoundEventPacket.setExtraData(-1);
        levelSoundEventPacket.setSound(SoundEvent.EXPLODE);
        levelSoundEventPacket.setIdentifier(":");
        levelSoundEventPacket.setPosition(pos);
        session.sendUpstreamPacket(levelSoundEventPacket);
        if (packet.getPushX() != 0.0f || packet.getPushY() != 0.0f || packet.getPushZ() != 0.0f) {
            SetEntityMotionPacket motionPacket = new SetEntityMotionPacket();
            motionPacket.setRuntimeEntityId(session.getPlayerEntity().getGeyserId());
            motionPacket.setMotion(Vector3f.from(packet.getPushX(), packet.getPushY(), packet.getPushZ()));
            session.sendUpstreamPacket(motionPacket);
        }
    }
}

