/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop;

import java.util.Arrays;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class BootError {
    private final String[] errors;

    public BootError(@NotNull Logger logger, String ... errors) {
        this.errors = errors;
        for (String err : errors) {
            logger.severe(err);
        }
    }

    public void printErrors(CommandSender sender) {
        sender.sendMessage(ChatColor.RED + "#####################################################");
        sender.sendMessage(ChatColor.RED + " QuickShop is disabled, Please fix any errors and restart");
        for (String issue : this.errors) {
            sender.sendMessage(ChatColor.WHITE + "- " + ChatColor.YELLOW + issue);
        }
        sender.sendMessage(ChatColor.RED + "#####################################################");
    }

    public String[] getErrors() {
        return Arrays.copyOf(this.errors, this.errors.length);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BootError)) {
            return false;
        }
        BootError other = (BootError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getErrors(), other.getErrors());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BootError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getErrors());
        return result;
    }

    public String toString() {
        return "BootError(errors=" + Arrays.deepToString(this.getErrors()) + ")";
    }
}

