/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class BuildInfo {
    private final int buildId;
    private final String buildTag;
    private final String buildUrl;
    private final String jobUrl;
    private final String gitCommit;
    private final String gitBranch;
    private final String pomGroupId;
    private final String pomArtifactId;
    private final String jobName;

    public BuildInfo(@Nullable InputStream inputStream) {
        if (inputStream == null) {
            this.buildId = 0;
            this.buildTag = "Unknown";
            this.buildUrl = "Unknown";
            this.gitCommit = "Custom Build";
            this.gitBranch = "Unknown";
            this.pomGroupId = "Unknown";
            this.pomArtifactId = "Unknown";
            this.jobName = "Unknown";
            this.jobUrl = "https://ci.codemc.io/job/Ghost-chu/job/QuickShop-Reremake/";
            return;
        }
        YamlConfiguration buildInfo = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream));
        this.buildId = buildInfo.getInt("build-id", 0);
        this.buildTag = buildInfo.getString("build-tag", "Unknown");
        this.buildUrl = buildInfo.getString("build-url", "Unknown");
        this.gitCommit = buildInfo.getString("git-commit", "Invalid");
        this.gitBranch = buildInfo.getString("git-branch", "Unknown");
        this.pomGroupId = buildInfo.getString("pom-groupid", "Unknown");
        this.pomArtifactId = buildInfo.getString("pom-artifactid", "Unknown");
        this.jobUrl = buildInfo.getString("job-url", "https://ci.codemc.io/job/Ghost-chu/job/QuickShop-Reremake/");
        this.jobName = buildInfo.getString("job-name", "Unknown");
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getBuildId() {
        return this.buildId;
    }

    public String getBuildTag() {
        return this.buildTag;
    }

    public String getBuildUrl() {
        return this.buildUrl;
    }

    public String getJobUrl() {
        return this.jobUrl;
    }

    public String getGitCommit() {
        return this.gitCommit;
    }

    public String getGitBranch() {
        return this.gitBranch;
    }

    public String getPomGroupId() {
        return this.pomGroupId;
    }

    public String getPomArtifactId() {
        return this.pomArtifactId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildInfo)) {
            return false;
        }
        BuildInfo other = (BuildInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBuildId() != other.getBuildId()) {
            return false;
        }
        String this$buildTag = this.getBuildTag();
        String other$buildTag = other.getBuildTag();
        if (this$buildTag == null ? other$buildTag != null : !this$buildTag.equals(other$buildTag)) {
            return false;
        }
        String this$buildUrl = this.getBuildUrl();
        String other$buildUrl = other.getBuildUrl();
        if (this$buildUrl == null ? other$buildUrl != null : !this$buildUrl.equals(other$buildUrl)) {
            return false;
        }
        String this$jobUrl = this.getJobUrl();
        String other$jobUrl = other.getJobUrl();
        if (this$jobUrl == null ? other$jobUrl != null : !this$jobUrl.equals(other$jobUrl)) {
            return false;
        }
        String this$gitCommit = this.getGitCommit();
        String other$gitCommit = other.getGitCommit();
        if (this$gitCommit == null ? other$gitCommit != null : !this$gitCommit.equals(other$gitCommit)) {
            return false;
        }
        String this$gitBranch = this.getGitBranch();
        String other$gitBranch = other.getGitBranch();
        if (this$gitBranch == null ? other$gitBranch != null : !this$gitBranch.equals(other$gitBranch)) {
            return false;
        }
        String this$pomGroupId = this.getPomGroupId();
        String other$pomGroupId = other.getPomGroupId();
        if (this$pomGroupId == null ? other$pomGroupId != null : !this$pomGroupId.equals(other$pomGroupId)) {
            return false;
        }
        String this$pomArtifactId = this.getPomArtifactId();
        String other$pomArtifactId = other.getPomArtifactId();
        if (this$pomArtifactId == null ? other$pomArtifactId != null : !this$pomArtifactId.equals(other$pomArtifactId)) {
            return false;
        }
        String this$jobName = this.getJobName();
        String other$jobName = other.getJobName();
        return !(this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBuildId();
        String $buildTag = this.getBuildTag();
        result = result * 59 + ($buildTag == null ? 43 : $buildTag.hashCode());
        String $buildUrl = this.getBuildUrl();
        result = result * 59 + ($buildUrl == null ? 43 : $buildUrl.hashCode());
        String $jobUrl = this.getJobUrl();
        result = result * 59 + ($jobUrl == null ? 43 : $jobUrl.hashCode());
        String $gitCommit = this.getGitCommit();
        result = result * 59 + ($gitCommit == null ? 43 : $gitCommit.hashCode());
        String $gitBranch = this.getGitBranch();
        result = result * 59 + ($gitBranch == null ? 43 : $gitBranch.hashCode());
        String $pomGroupId = this.getPomGroupId();
        result = result * 59 + ($pomGroupId == null ? 43 : $pomGroupId.hashCode());
        String $pomArtifactId = this.getPomArtifactId();
        result = result * 59 + ($pomArtifactId == null ? 43 : $pomArtifactId.hashCode());
        String $jobName = this.getJobName();
        result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
        return result;
    }

    public String toString() {
        return "BuildInfo(buildId=" + this.getBuildId() + ", buildTag=" + this.getBuildTag() + ", buildUrl=" + this.getBuildUrl() + ", jobUrl=" + this.getJobUrl() + ", gitCommit=" + this.getGitCommit() + ", gitBranch=" + this.getGitBranch() + ", pomGroupId=" + this.getPomGroupId() + ", pomArtifactId=" + this.getPomArtifactId() + ", jobName=" + this.getJobName() + ")";
    }
}

