/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.logging.Level;
import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.listeners.ItemMergeListener;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.BootError;
import org.maxgamer.quickshop.BuildInfo;
import org.maxgamer.quickshop.BuiltInSolution;
import org.maxgamer.quickshop.Cache;
import org.maxgamer.quickshop.ConfigurationFixer;
import org.maxgamer.quickshop.Language;
import org.maxgamer.quickshop.Metrics;
import org.maxgamer.quickshop.ServiceInjector;
import org.maxgamer.quickshop.api.QuickShopAPI;
import org.maxgamer.quickshop.builtinlistener.InternalListener;
import org.maxgamer.quickshop.chat.QuickChat;
import org.maxgamer.quickshop.chat.QuickChatType;
import org.maxgamer.quickshop.chat.platform.minedown.BungeeQuickChat;
import org.maxgamer.quickshop.command.CommandManager;
import org.maxgamer.quickshop.database.AbstractDatabaseCore;
import org.maxgamer.quickshop.database.DatabaseHelper;
import org.maxgamer.quickshop.database.DatabaseManager;
import org.maxgamer.quickshop.database.MySQLCore;
import org.maxgamer.quickshop.database.SQLiteCore;
import org.maxgamer.quickshop.economy.Economy;
import org.maxgamer.quickshop.economy.EconomyCore;
import org.maxgamer.quickshop.economy.EconomyType;
import org.maxgamer.quickshop.economy.Economy_GemsEconomy;
import org.maxgamer.quickshop.economy.Economy_TNE;
import org.maxgamer.quickshop.economy.Economy_Vault;
import org.maxgamer.quickshop.event.QSReloadEvent;
import org.maxgamer.quickshop.integration.IntegrateStage;
import org.maxgamer.quickshop.integration.IntegrationHelper;
import org.maxgamer.quickshop.integration.worldguard.WorldGuardIntegration;
import org.maxgamer.quickshop.listener.BlockListener;
import org.maxgamer.quickshop.listener.ChatListener;
import org.maxgamer.quickshop.listener.ChunkListener;
import org.maxgamer.quickshop.listener.ClearLaggListener;
import org.maxgamer.quickshop.listener.CustomInventoryListener;
import org.maxgamer.quickshop.listener.DisplayProtectionListener;
import org.maxgamer.quickshop.listener.LockListener;
import org.maxgamer.quickshop.listener.PlayerListener;
import org.maxgamer.quickshop.listener.PluginListener;
import org.maxgamer.quickshop.listener.ShopProtectionListener;
import org.maxgamer.quickshop.listener.WorldListener;
import org.maxgamer.quickshop.listener.worldedit.WorldEditAdapter;
import org.maxgamer.quickshop.nonquickshopstuff.com.rylinaux.plugman.util.PluginUtil;
import org.maxgamer.quickshop.permission.PermissionManager;
import org.maxgamer.quickshop.shop.DisplayItem;
import org.maxgamer.quickshop.shop.DisplayType;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.shop.ShopControlPanel;
import org.maxgamer.quickshop.shop.ShopLoader;
import org.maxgamer.quickshop.shop.ShopManager;
import org.maxgamer.quickshop.util.AsyncPacketSender;
import org.maxgamer.quickshop.util.GameVersion;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.PermissionChecker;
import org.maxgamer.quickshop.util.ReflectFactory;
import org.maxgamer.quickshop.util.Timer;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.compatibility.CompatibilityManager;
import org.maxgamer.quickshop.util.config.ConfigProvider;
import org.maxgamer.quickshop.util.envcheck.CheckResult;
import org.maxgamer.quickshop.util.envcheck.EnvCheckEntry;
import org.maxgamer.quickshop.util.envcheck.EnvironmentChecker;
import org.maxgamer.quickshop.util.envcheck.ResultContainer;
import org.maxgamer.quickshop.util.envcheck.ResultReport;
import org.maxgamer.quickshop.util.matcher.item.BukkitItemMatcherImpl;
import org.maxgamer.quickshop.util.matcher.item.ItemMatcher;
import org.maxgamer.quickshop.util.matcher.item.QuickShopItemMatcherImpl;
import org.maxgamer.quickshop.util.reporter.error.RollbarErrorReporter;
import org.maxgamer.quickshop.watcher.CalendarWatcher;
import org.maxgamer.quickshop.watcher.DisplayAutoDespawnWatcher;
import org.maxgamer.quickshop.watcher.DisplayDupeRemoverWatcher;
import org.maxgamer.quickshop.watcher.DisplayWatcher;
import org.maxgamer.quickshop.watcher.LogWatcher;
import org.maxgamer.quickshop.watcher.OngoingFeeWatcher;
import org.maxgamer.quickshop.watcher.ShopContainerWatcher;
import org.maxgamer.quickshop.watcher.SignUpdateWatcher;
import org.maxgamer.quickshop.watcher.UpdateWatcher;

public class QuickShop
extends JavaPlugin {
    @Deprecated
    public static QuickShop instance;
    private static PermissionManager permissionManager;
    private static boolean loaded;
    private static volatile boolean testing;
    private final CompatibilityManager compatibilityTool = new CompatibilityManager(this);
    private final Map<String, Integer> limits = new HashMap<String, Integer>(15);
    private final ConfigProvider configProvider = new ConfigProvider(this);
    private final List<BukkitTask> timerTaskList = new ArrayList<BukkitTask>(3);
    private final GameVersion gameVersion = GameVersion.get(Util.getNMSVersion());
    boolean onLoadCalled = false;
    private IntegrationHelper integrationHelper;
    @Nullable
    private BootError bootError;
    private CommandManager commandManager;
    private DatabaseHelper databaseHelper;
    private DatabaseManager databaseManager;
    private String dbPrefix = "";
    private boolean display = true;
    private int displayItemCheckTicks;
    private DisplayWatcher displayWatcher;
    private Economy economy;
    private ItemMatcher itemMatcher;
    private Language language;
    private boolean limit = false;
    @Nullable
    private LogWatcher logWatcher;
    private Metrics metrics;
    private Plugin openInvPlugin;
    private Plugin placeHolderAPI;
    private PermissionChecker permissionChecker;
    private boolean priceChangeRequiresFee = false;
    private RollbarErrorReporter sentryErrorReporter;
    private UUID serverUniqueID;
    private boolean setupDBonEnableding = false;
    private ShopLoader shopLoader;
    private ShopManager shopManager;
    private DisplayAutoDespawnWatcher displayAutoDespawnWatcher;
    private OngoingFeeWatcher ongoingFeeWatcher;
    private SignUpdateWatcher signUpdateWatcher;
    private ShopContainerWatcher shopContainerWatcher;
    @Deprecated
    private DisplayDupeRemoverWatcher displayDupeRemoverWatcher;
    private boolean enabledAsyncDisplayDespawn;
    private String previewProtectionLore;
    private Plugin blockHubPlugin;
    private Plugin lwcPlugin;
    private Cache shopCache;
    private boolean allowStack;
    private EnvironmentChecker environmentChecker;
    @Nullable
    private UpdateWatcher updateWatcher;
    private BuildInfo buildInfo;
    private QuickChatType quickChatType = QuickChatType.BUNGEECHAT;
    private QuickChat quickChat = new BungeeQuickChat();
    @Nullable
    private String currency = null;
    private ShopControlPanel shopControlPanelManager;
    private CalendarWatcher calendarWatcher;
    private Plugin worldEditPlugin;
    private WorldEditAdapter worldEditAdapter;

    public QuickShop() {
    }

    protected QuickShop(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
        System.getProperties().setProperty("org.maxgamer.quickshop.util.envcheck.skip.SIGNATURE_VERIFY", "true");
    }

    @NotNull
    public static QuickShop getInstance() {
        return instance;
    }

    public static String getVersion() {
        return instance.getDescription().getVersion();
    }

    public static PermissionManager getPermissionManager() {
        return permissionManager;
    }

    public static String getFork() {
        return "Reremake";
    }

    public int getShopLimit(@NotNull Player p) {
        int max = this.getConfig().getInt("limits.default");
        for (Map.Entry<String, Integer> entry : this.limits.entrySet()) {
            if (entry.getValue() <= max || !QuickShop.getPermissionManager().hasPermission((CommandSender)p, entry.getKey())) continue;
            max = entry.getValue();
        }
        return max;
    }

    private void load3rdParty() {
        if (this.getConfig().getBoolean("plugin.OpenInv")) {
            this.openInvPlugin = Bukkit.getPluginManager().getPlugin("OpenInv");
            if (this.openInvPlugin != null) {
                this.getLogger().info("Successfully loaded OpenInv support!");
            }
        }
        if (this.getConfig().getBoolean("plugin.PlaceHolderAPI")) {
            this.placeHolderAPI = Bukkit.getPluginManager().getPlugin("PlaceholderAPI");
            if (this.placeHolderAPI != null) {
                this.getLogger().info("Successfully loaded PlaceHolderAPI support!");
            }
        }
        if (this.getConfig().getBoolean("plugin.BlockHub")) {
            this.blockHubPlugin = Bukkit.getPluginManager().getPlugin("BlockHub");
            if (this.blockHubPlugin != null) {
                this.getLogger().info("Successfully loaded BlockHub support!");
            }
        }
        if (this.getConfig().getBoolean("plugin.WorldEdit")) {
            String nmsVersion = Util.getNMSVersion();
            GameVersion gameVersion = GameVersion.get(nmsVersion);
            this.worldEditPlugin = Bukkit.getPluginManager().getPlugin("WorldEdit");
            if (this.worldEditPlugin != null) {
                this.worldEditAdapter = new WorldEditAdapter(this, (WorldEditPlugin)this.worldEditPlugin);
                this.worldEditAdapter.register();
                this.getLogger().info("Successfully loaded WorldEdit support!");
            }
        }
        if (this.getConfig().getBoolean("plugin.LWC")) {
            this.lwcPlugin = Bukkit.getPluginManager().getPlugin("LWC");
            if (this.lwcPlugin != null) {
                if (Util.isMethodAvailable("com.griefcraft.lwc.LWC", "findProtection", Location.class)) {
                    this.getLogger().info("Successfully loaded LWC support!");
                } else {
                    this.getLogger().warning("Unsupported LWC version, please make sure you are using the modern version of LWC!");
                    this.lwcPlugin = null;
                }
            }
        }
        this.compatibilityTool.searchAndRegisterPlugins();
        if (this.display) {
            if (DisplayItem.getNowUsing() == DisplayType.VIRTUALITEM) {
                this.getLogger().info("Using Virtual Item display, loading ProtocolLib support...");
                Plugin protocolLibPlugin = Bukkit.getPluginManager().getPlugin("ProtocolLib");
                if (protocolLibPlugin != null && protocolLibPlugin.isEnabled()) {
                    this.getLogger().info("Successfully loaded ProtocolLib support!");
                } else {
                    this.getLogger().warning("Failed to load ProtocolLib support, fallback to real item display");
                    this.getConfig().set("shop.display-type", (Object)0);
                    this.saveConfig();
                }
            }
            if (DisplayItem.getNowUsing() == DisplayType.REALITEM && Bukkit.getPluginManager().getPlugin("ClearLag") != null) {
                try {
                    Clearlag clearlag = (Clearlag)Bukkit.getPluginManager().getPlugin("ClearLag");
                    for (RegisteredListener clearLagListener : ItemSpawnEvent.getHandlerList().getRegisteredListeners()) {
                        if (!clearLagListener.getPlugin().equals(clearlag) || !clearLagListener.getListener().getClass().equals(ItemMergeListener.class)) continue;
                        ItemSpawnEvent.getHandlerList().unregister(clearLagListener.getListener());
                        this.getLogger().warning("+++++++++++++++++++++++++++++++++++++++++++");
                        this.getLogger().severe("Detected incompatible module of ClearLag-ItemMerge module, it will broken the QuickShop display, we already unregister this module listener!");
                        this.getLogger().severe("Please turn off it in the ClearLag config.yml or turn off the QuickShop display feature!");
                        this.getLogger().severe("If you didn't do that, this message will keep spam in your console every times you server boot up!");
                        this.getLogger().warning("+++++++++++++++++++++++++++++++++++++++++++");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private boolean loadEcon() {
        try {
            EconomyCore core = null;
            switch (EconomyType.fromID(this.getConfig().getInt("economy-type"))) {
                case UNKNOWN: {
                    this.setupBootError(new BootError(this.getLogger(), "Can't load the Economy provider, invaild value in config.yml."));
                    return false;
                }
                case VAULT: {
                    core = new Economy_Vault(this);
                    Util.debugLog("Now using the Vault economy system.");
                    if (!(this.getConfig().getDouble("tax", 0.0) > 0.0)) break;
                    try {
                        Economy_Vault vault;
                        OfflinePlayer tax;
                        String taxAccount = this.getConfig().getString("tax-account", "tax");
                        if (taxAccount == null || taxAccount.isEmpty() || (tax = Util.isUUID(taxAccount) ? Bukkit.getOfflinePlayer((UUID)UUID.fromString(taxAccount)) : Bukkit.getOfflinePlayer((String)Objects.requireNonNull(taxAccount))).hasPlayedBefore() || !(vault = (Economy_Vault)core).isValid() || Objects.requireNonNull(vault.getVault()).hasAccount(tax)) break;
                        try {
                            Util.debugLog("Tax account not exists! Creating...");
                            this.getLogger().warning("QuickShop detected tax account not exists, we're trying to create one. If you see any errors, please change tax-account in config.yml to server owner in-game username");
                            if (vault.getVault().createPlayerAccount(tax)) {
                                this.getLogger().info("Tax account created.");
                            } else {
                                this.getLogger().warning("Cannot to create tax-account,  please change tax-account in config.yml to server owner in-game username");
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (vault.getVault().hasAccount(tax)) break;
                        this.getLogger().warning("Tax account's player never played this server before, that may cause server lagg or economy system error, you should change that name. But if this warning not cause any issues, you can safety ignore this.");
                    }
                    catch (Exception ignored) {
                        Util.debugLog("Failed to fix account issue.");
                    }
                    break;
                }
                case GEMS_ECONOMY: {
                    core = new Economy_GemsEconomy(this);
                    Util.debugLog("Now using the GemsEconomy economy system.");
                    break;
                }
                case TNE: {
                    core = new Economy_TNE(this);
                    Util.debugLog("Now using the TNE economy system.");
                    break;
                }
                default: {
                    Util.debugLog("No any economy provider selected.");
                }
            }
            if (core == null) {
                return false;
            }
            if (!core.isValid()) {
                this.setupBootError(BuiltInSolution.econError());
                return false;
            }
            this.economy = new Economy(this, ServiceInjector.getEconomyCore(core));
            return true;
        }
        catch (Exception e) {
            this.getSentryErrorReporter().ignoreThrow();
            this.getLogger().log(Level.WARNING, "Something going wrong when loading up economy system", e);
            this.getLogger().severe("QuickShop could not hook into a economy/Not found Vault or Reserve!");
            this.getLogger().severe("QuickShop CANNOT start!");
            this.setupBootError(BuiltInSolution.econError());
            this.getLogger().severe("Plugin listeners was disabled, please fix the economy issue.");
            return false;
        }
    }

    public void log(@NotNull String s) {
        Util.debugLog("[SHOP LOG] " + s);
        if (this.getLogWatcher() == null) {
            return;
        }
        this.getLogWatcher().log(s);
    }

    @NotNull
    public FileConfiguration getConfig() {
        return this.configProvider.get();
    }

    public void saveConfig() {
        this.configProvider.save();
    }

    public void reloadConfig() {
        this.configProvider.reload();
        this.display = this.getConfig().getBoolean("shop.display-items");
        this.priceChangeRequiresFee = this.getConfig().getBoolean("shop.price-change-requires-fee");
        this.displayItemCheckTicks = this.getConfig().getInt("shop.display-items-check-ticks");
        this.allowStack = this.getConfig().getBoolean("shop.allow-stacks");
        this.quickChatType = QuickChatType.fromID(this.getConfig().getInt("chat-type"));
        this.quickChat = QuickChatType.createByType(this.quickChatType);
        this.currency = this.getConfig().getString("currency");
        if (StringUtils.isEmpty((String)this.currency)) {
            this.currency = null;
        }
        this.language = new Language(this);
        this.logWatcher = this.getConfig().getBoolean("logging.enable") ? new LogWatcher(this, new File(this.getDataFolder(), "qs.log")) : null;
    }

    public void onLoad() {
        Plugin wg;
        this.onLoadCalled = true;
        this.getLogger().info("QuickShop " + QuickShop.getFork() + " - Early boot step - Booting up...");
        instance = this;
        this.buildInfo = new BuildInfo(this.getResource("BUILDINFO"));
        this.runtimeCheck(EnvCheckEntry.Stage.ON_LOAD);
        this.getLogger().info("Reading the configuration...");
        this.initConfiguration();
        QuickShopAPI._internal_access_only_setupApi(this);
        this.getDataFolder().mkdirs();
        this.bootError = null;
        this.getLogger().info("Loading up integration modules.");
        this.integrationHelper = new IntegrationHelper(this);
        this.integrationHelper.callIntegrationsLoad(IntegrateStage.onLoadBegin);
        if (this.getConfig().getBoolean("integration.worldguard.enable") && (wg = Bukkit.getPluginManager().getPlugin("WorldGuard")) != null) {
            this.integrationHelper.register(new WorldGuardIntegration(this));
        }
        this.integrationHelper.callIntegrationsLoad(IntegrateStage.onLoadAfter);
        this.getLogger().info("QuickShop " + QuickShop.getFork() + " - Early boot step - Booted up...");
    }

    public void onDisable() {
        this.getLogger().info("QuickShop is finishing remaining work, this may need a while...");
        if (this.sentryErrorReporter != null) {
            this.sentryErrorReporter.unregister();
        }
        if (this.integrationHelper != null) {
            this.integrationHelper.callIntegrationsUnload(IntegrateStage.onUnloadBegin);
        }
        Util.debugLog("Unloading all shops...");
        try {
            if (this.getShopManager() != null) {
                this.getShopManager().getLoadedShops().forEach(Shop::onUnload);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Util.debugLog("Unregister hooks...");
        if (this.worldEditAdapter != null) {
            this.worldEditAdapter.unregister();
        }
        Util.debugLog("Calling integrations...");
        if (this.integrationHelper != null) {
            this.integrationHelper.callIntegrationsUnload(IntegrateStage.onUnloadAfter);
            this.integrationHelper.unregisterAll();
        }
        this.compatibilityTool.unregisterAll();
        Util.debugLog("Cleaning up resources and unloading all shops...");
        if (this.shopManager != null) {
            this.shopManager.clear();
        }
        Util.debugLog("Cleaning up database queues...");
        if (this.getDatabaseManager() != null) {
            this.getDatabaseManager().unInit();
        }
        Util.debugLog("Unregistering tasks...");
        if (this.logWatcher != null) {
            this.logWatcher.close();
        }
        for (BukkitTask bukkitTask : this.timerTaskList) {
            if (bukkitTask.isCancelled()) continue;
            bukkitTask.cancel();
        }
        if (this.calendarWatcher != null) {
            this.calendarWatcher.stop();
        }
        if (this.updateWatcher != null) {
            this.updateWatcher.uninit();
        }
        AsyncPacketSender.stop();
        Util.debugLog("Cleanup tasks...");
        try {
            Bukkit.getScheduler().cancelTasks((Plugin)this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Util.debugLog("Cleanup listeners...");
        HandlerList.unregisterAll((Plugin)this);
        Util.debugLog("All shutdown work is finished.");
    }

    public void reload() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        try {
            File updatedJar;
            File file = Paths.get(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).toFile();
            if (this.getUpdateWatcher() != null && (updatedJar = this.getUpdateWatcher().getUpdater().getUpdatedJar()) != null) {
                throw new IllegalStateException("Failed to reload QuickShop! Please consider restarting the server. (Plugin was updated)");
            }
            if (!file.exists()) {
                throw new IllegalStateException("Failed to reload QuickShop! Please consider restarting the server. (Failed to find plugin jar)");
            }
            Throwable throwable = PluginUtil.unload((Plugin)this);
            if (throwable != null) {
                throw new IllegalStateException("Failed to reload QuickShop! Please consider restarting the server. (Plugin unloading has failed)", throwable);
            }
            Plugin plugin = pluginManager.loadPlugin(file);
            if (plugin == null) {
                throw new IllegalStateException("Failed to reload QuickShop! Please consider restarting the server. (Plugin loading has failed)");
            }
            plugin.onLoad();
            pluginManager.enablePlugin(plugin);
        }
        catch (URISyntaxException | InvalidDescriptionException | InvalidPluginException e) {
            throw new RuntimeException("Failed to reload QuickShop! Please consider restarting the server.", e);
        }
    }

    private void initConfiguration() {
        try {
            this.saveDefaultConfig();
        }
        catch (IllegalArgumentException resourceNotFoundException) {
            this.getLogger().severe("Failed to save config.yml from jar, The binary file of QuickShop may damaged. Please re-download from our website.");
        }
        this.reloadConfig();
        this.getConfig().options().copyHeader(false).header("=================================\n=    QuickShop  Configuration   =\n=================================\n\nNotes:\nPlease read the example-configuration.yml file to get a commented example config.\nPlease read the example-configuration.yml file to get a commented example config.\nPlease read the example-configuration.yml file to get a commented example config.\n");
        if (this.getConfig().getInt("config-version", 0) == 0) {
            this.getConfig().set("config-version", (Object)1);
        }
        this.serverUniqueID = UUID.fromString(Objects.requireNonNull(this.getConfig().getString("server-uuid", String.valueOf(UUID.randomUUID()))));
        try {
            this.updateConfig(this.getConfig().getInt("config-version"));
        }
        catch (IOException exception) {
            this.getLogger().log(Level.WARNING, "Failed to update configuration", exception);
        }
        try {
            MsgUtil.loadI18nFile();
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Error when loading translation", e);
        }
    }

    private void runtimeCheck(@NotNull EnvCheckEntry.Stage stage) {
        testing = true;
        this.environmentChecker = new EnvironmentChecker(this);
        ResultReport resultReport = this.environmentChecker.run(stage);
        if (resultReport.getFinalResult().ordinal() > CheckResult.WARNING.ordinal()) {
            StringJoiner joiner = new StringJoiner("\n", "", "");
            for (Map.Entry<EnvCheckEntry, ResultContainer> result : resultReport.getResults().entrySet()) {
                if (result.getValue().getResult().ordinal() <= CheckResult.WARNING.ordinal()) continue;
                joiner.add(String.format("- [%s/%s] %s", result.getValue().getResult().getDisplay(), result.getKey().name(), result.getValue().getResultMessage()));
            }
            this.setupBootError(new BootError(this.getLogger(), joiner.toString()));
            Util.mainThreadRun(() -> this.getCommand("qs").setTabCompleter((TabCompleter)this));
        }
        testing = false;
    }

    public void onEnable() {
        if (!this.onLoadCalled) {
            this.getLogger().severe("FATAL: onLoad not called and QuickShop trying patching them... Some Integrations will won't work or work incorrectly!");
            try {
                this.onLoad();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Timer enableTimer = new Timer(true);
        this.integrationHelper.callIntegrationsLoad(IntegrateStage.onEnableBegin);
        this.getLogger().info("QuickShop " + QuickShop.getFork());
        this.getLogger().info("Starting plugin self-test, please wait...");
        this.runtimeCheck(EnvCheckEntry.Stage.ON_ENABLE);
        QuickShopAPI._internal_access_only_setupApi(this);
        this.getLogger().info("Reading the configuration...");
        this.initConfiguration();
        this.getLogger().info("Developers: " + Util.list2String(this.getDescription().getAuthors()));
        this.getLogger().info("Original author: Netherfoam, Timtower, KaiNoMood");
        this.getLogger().info("Let's start loading the plugin");
        this.getLogger().info("Chat processor selected: " + this.quickChatType.name());
        this.metrics = new Metrics((Plugin)this, 3320);
        try {
            if (!this.getConfig().getBoolean("auto-report-errors")) {
                Util.debugLog("Error reporter was disabled!");
            } else {
                this.sentryErrorReporter = new RollbarErrorReporter(this);
            }
        }
        catch (Throwable th) {
            this.getLogger().warning("Cannot load the Sentry Error Reporter: " + th.getMessage());
            this.getLogger().warning("Because our error reporter doesn't work, please report this error to developer, thank you!");
        }
        this.loadItemMatcher();
        Util.initialize();
        try {
            MsgUtil.loadI18nFile();
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Error when loading translation", e);
        }
        MsgUtil.loadItemi18n();
        MsgUtil.loadEnchi18n();
        MsgUtil.loadPotioni18n();
        this.shopControlPanelManager = new ShopControlPanel(this);
        this.previewProtectionLore = MsgUtil.getMessageOfflinePlayer("quickshop-gui-preview", null, new String[0]);
        if (this.previewProtectionLore == null || this.previewProtectionLore.isEmpty()) {
            this.previewProtectionLore = ChatColor.RED + "FIXME: DON'T SET THIS TO EMPTY STRING";
        }
        this.load3rdParty();
        this.setupDBonEnableding = true;
        this.setupDatabase();
        this.setupDBonEnableding = false;
        permissionManager = new PermissionManager(this);
        if (this.display && this.getConfig().getBoolean("shop.display-auto-despawn")) {
            this.enabledAsyncDisplayDespawn = true;
            this.displayAutoDespawnWatcher = new DisplayAutoDespawnWatcher(this);
            this.displayAutoDespawnWatcher.runTaskTimer((Plugin)this, 20L, this.getConfig().getInt("shop.display-check-time"));
        }
        this.getLogger().info("Registering commands...");
        this.commandManager = new CommandManager(this);
        this.getCommand("qs").setExecutor((CommandExecutor)this.commandManager);
        this.getCommand("qs").setTabCompleter((TabCompleter)this.commandManager);
        this.registerCustomCommands();
        this.shopManager = new ShopManager(this);
        this.permissionChecker = new PermissionChecker(this);
        ConfigurationSection limitCfg = this.getConfig().getConfigurationSection("limits");
        if (limitCfg != null) {
            this.limit = limitCfg.getBoolean("use", false);
            limitCfg = limitCfg.getConfigurationSection("ranks");
            for (String key : Objects.requireNonNull(limitCfg).getKeys(true)) {
                this.limits.put(key, limitCfg.getInt(key));
            }
        }
        if (this.getConfig().getInt("shop.finding.distance") > 100) {
            this.getLogger().severe("Shop find distance is too high! It may cause lag! Pick a number under 100!");
        }
        this.shopCache = this.getConfig().getBoolean("use-caching") ? new Cache(this) : null;
        this.signUpdateWatcher = new SignUpdateWatcher();
        this.shopContainerWatcher = new ShopContainerWatcher();
        if (this.display && DisplayItem.getNowUsing() != DisplayType.VIRTUALITEM) {
            this.displayDupeRemoverWatcher = new DisplayDupeRemoverWatcher();
        }
        if (this.display && DisplayItem.getNowUsing() != DisplayType.VIRTUALITEM) {
            this.timerTaskList.add(this.displayDupeRemoverWatcher.runTaskTimerAsynchronously((Plugin)this, 0L, 1L));
        }
        if (this.display && DisplayItem.getNowUsing() == DisplayType.VIRTUALITEM) {
            AsyncPacketSender.start(this);
        }
        this.shopLoader = new ShopLoader(this);
        this.shopLoader.loadShops();
        this.getLogger().info("Registering listeners...");
        new BlockListener(this, this.shopCache).register();
        new PlayerListener(this).register();
        new WorldListener(this).register();
        new ChatListener(this).register();
        new ChunkListener(this).register();
        new CustomInventoryListener(this).register();
        new ShopProtectionListener(this, this.shopCache).register();
        new PluginListener(this).register();
        this.ongoingFeeWatcher = new OngoingFeeWatcher(this);
        InternalListener internalListener = new InternalListener(this);
        Bukkit.getPluginManager().registerEvents((Listener)internalListener, (Plugin)this);
        if (this.isDisplay() && DisplayItem.getNowUsing() != DisplayType.VIRTUALITEM) {
            this.displayWatcher = new DisplayWatcher(this);
            new DisplayProtectionListener(this, this.shopCache).register();
            if (Bukkit.getPluginManager().getPlugin("ClearLag") != null) {
                new ClearLaggListener(this).register();
            }
        }
        if (this.getConfig().getBoolean("shop.lock")) {
            new LockListener(this, this.shopCache).register();
        }
        this.getLogger().info("Cleaning MsgUtils...");
        MsgUtil.loadTransactionMessages();
        MsgUtil.clean();
        if (this.getConfig().getBoolean("updater", true)) {
            this.updateWatcher = new UpdateWatcher();
            this.updateWatcher.init();
        }
        Util.debugLog("Loading economy system...");
        new BukkitRunnable(){

            public void run() {
                QuickShop.this.loadEcon();
            }
        }.runTaskLater((Plugin)this, 1L);
        Util.debugLog("Registering watchers...");
        this.calendarWatcher = new CalendarWatcher(this);
        this.signUpdateWatcher.runTaskTimer((Plugin)this, 0L, 10L);
        this.shopContainerWatcher.runTaskTimer((Plugin)this, 0L, 5L);
        if (this.logWatcher != null) {
            this.timerTaskList.add(this.logWatcher.runTaskTimerAsynchronously((Plugin)this, 10L, 10L));
            this.getLogger().info("Log actions is enabled, actions will log in the qs.log file!");
        }
        if (this.getConfig().getBoolean("shop.ongoing-fee.enable")) {
            this.getLogger().info("Ongoing fee feature is enabled.");
            this.timerTaskList.add(this.ongoingFeeWatcher.runTaskTimerAsynchronously((Plugin)this, 0L, this.getConfig().getInt("shop.ongoing-fee.ticks")));
        }
        this.integrationHelper.searchAndRegisterPlugins();
        this.integrationHelper.callIntegrationsLoad(IntegrateStage.onEnableAfter);
        new BukkitRunnable(){

            public void run() {
                QuickShop.this.getLogger().info("Registering bStats metrics...");
                QuickShop.this.submitMeritcs();
            }
        }.runTask((Plugin)this);
        if (loaded) {
            this.getServer().getPluginManager().callEvent((Event)new QSReloadEvent(this));
        } else {
            loaded = true;
        }
        this.calendarWatcher = new CalendarWatcher(this);
        this.calendarWatcher.start();
        Util.debugLog("Now using display-type: " + DisplayItem.getNowUsing().name());
        this.getLogger().info("QuickShop Loaded! " + enableTimer.stopAndGetTimePassed() + " ms.");
    }

    private void loadItemMatcher() {
        ItemMatcher defItemMatcher;
        switch (this.getConfig().getInt("matcher.work-type")) {
            case 1: {
                defItemMatcher = new BukkitItemMatcherImpl(this);
                break;
            }
            default: {
                defItemMatcher = new QuickShopItemMatcherImpl(this);
            }
        }
        this.itemMatcher = ServiceInjector.getItemMatcher(defItemMatcher);
    }

    private boolean setupDatabase() {
        this.getLogger().info("Setting up database...");
        try {
            AbstractDatabaseCore dbCore;
            ConfigurationSection dbCfg = this.getConfig().getConfigurationSection("database");
            if (Objects.requireNonNull(dbCfg).getBoolean("mysql")) {
                this.dbPrefix = dbCfg.getString("prefix");
                if (this.dbPrefix == null || "none".equals(this.dbPrefix)) {
                    this.dbPrefix = "";
                }
                String user = dbCfg.getString("user");
                String pass = dbCfg.getString("password");
                String host = dbCfg.getString("host");
                String port = dbCfg.getString("port");
                String database = dbCfg.getString("database");
                boolean useSSL = dbCfg.getBoolean("usessl");
                dbCore = new MySQLCore(this, Objects.requireNonNull(host, "MySQL host can't be null"), Objects.requireNonNull(user, "MySQL username can't be null"), Objects.requireNonNull(pass, "MySQL password can't be null"), Objects.requireNonNull(database, "MySQL database name can't be null"), Objects.requireNonNull(port, "MySQL port can't be null"), useSSL);
            } else {
                dbCore = new SQLiteCore(this, new File(this.getDataFolder(), "shops.db"));
            }
            this.databaseManager = new DatabaseManager(this, ServiceInjector.getDatabaseCore(dbCore));
            this.databaseHelper = new DatabaseHelper(this, this.databaseManager);
        }
        catch (DatabaseManager.ConnectionException e) {
            this.getLogger().log(Level.SEVERE, "Error when connecting to the database", e);
            if (this.setupDBonEnableding) {
                this.bootError = BuiltInSolution.databaseError();
            }
            return false;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error when setup database", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            if (this.setupDBonEnableding) {
                this.bootError = BuiltInSolution.databaseError();
            }
            return false;
        }
        return true;
    }

    private void submitMeritcs() {
        if (!this.getConfig().getBoolean("disabled-metrics")) {
            Plugin vault = Bukkit.getPluginManager().getPlugin("Vault");
            String vaultVer = vault != null ? vault.getDescription().getVersion() : "Vault not found";
            String economyType = Economy.getNowUsing().name();
            if (this.getEconomy() != null) {
                economyType = this.getEconomy().getName();
            }
            String eventAdapter = this.getConfig().getInt("shop.protection-checking-handler") == 1 ? "QUICKSHOP" : "BUKKIT";
            this.metrics.addCustomChart(new Metrics.SimplePie("server_version", Bukkit::getVersion));
            this.metrics.addCustomChart(new Metrics.SimplePie("bukkit_version", Bukkit::getBukkitVersion));
            this.metrics.addCustomChart(new Metrics.SimplePie("vault_version", () -> vaultVer));
            this.metrics.addCustomChart(new Metrics.SimplePie("use_display_items", () -> Util.boolean2Status(this.getConfig().getBoolean("shop.display-items"))));
            this.metrics.addCustomChart(new Metrics.SimplePie("use_locks", () -> Util.boolean2Status(this.getConfig().getBoolean("shop.lock"))));
            this.metrics.addCustomChart(new Metrics.SimplePie("use_sneak_action", () -> Util.boolean2Status(this.getConfig().getBoolean("shop.interact.sneak-to-create") || this.getConfig().getBoolean("shop.interact.sneak-to-trade") || this.getConfig().getBoolean("shop.interact.sneak-to-control"))));
            this.metrics.addCustomChart(new Metrics.SimplePie("shop_find_distance", () -> this.getConfig().getString("shop.finding.distance")));
            String finalEconomyType = economyType;
            this.metrics.addCustomChart(new Metrics.SimplePie("economy_type", () -> finalEconomyType));
            this.metrics.addCustomChart(new Metrics.SimplePie("use_display_auto_despawn", () -> String.valueOf(this.getConfig().getBoolean("shop.display-auto-despawn"))));
            this.metrics.addCustomChart(new Metrics.SimplePie("use_enhance_display_protect", () -> String.valueOf(this.getConfig().getBoolean("shop.enchance-display-protect"))));
            this.metrics.addCustomChart(new Metrics.SimplePie("use_enhance_shop_protect", () -> String.valueOf(this.getConfig().getBoolean("shop.enchance-shop-protect"))));
            this.metrics.addCustomChart(new Metrics.SimplePie("use_ongoing_fee", () -> String.valueOf(this.getConfig().getBoolean("shop.ongoing-fee.enable"))));
            this.metrics.addCustomChart(new Metrics.SimplePie("database_type", () -> this.getDatabaseManager().getDatabase().getName()));
            this.metrics.addCustomChart(new Metrics.SimplePie("display_type", () -> DisplayItem.getNowUsing().name()));
            this.metrics.addCustomChart(new Metrics.SimplePie("itemmatcher_type", () -> this.getItemMatcher().getName()));
            this.metrics.addCustomChart(new Metrics.SimplePie("use_stack_item", () -> String.valueOf(this.isAllowStack())));
            this.metrics.addCustomChart(new Metrics.SimplePie("chat_adapter", () -> this.getQuickChatType().name()));
            this.metrics.addCustomChart(new Metrics.SimplePie("event_adapter", () -> eventAdapter));
            this.metrics.addCustomChart(new Metrics.SingleLineChart("shops_created_on_all_servers", () -> this.getShopManager().getAllShops().size()));
            this.getLogger().info("Metrics submitted.");
        } else {
            this.getLogger().info("You have disabled mertics, Skipping...");
        }
    }

    private void updateConfig(int selectedVersion) throws IOException {
        String serverUUID = this.getConfig().getString("server-uuid");
        if (serverUUID == null || serverUUID.isEmpty()) {
            UUID uuid = UUID.randomUUID();
            serverUUID = uuid.toString();
            this.getConfig().set("server-uuid", (Object)serverUUID);
        }
        if (selectedVersion == 1) {
            this.getConfig().set("disabled-metrics", (Object)false);
            this.getConfig().set("config-version", (Object)2);
            selectedVersion = 2;
        }
        if (selectedVersion == 2) {
            this.getConfig().set("protect.minecart", (Object)true);
            this.getConfig().set("protect.entity", (Object)true);
            this.getConfig().set("protect.redstone", (Object)true);
            this.getConfig().set("protect.structuregrow", (Object)true);
            this.getConfig().set("protect.explode", (Object)true);
            this.getConfig().set("protect.hopper", (Object)true);
            this.getConfig().set("config-version", (Object)3);
            selectedVersion = 3;
        }
        if (selectedVersion == 3) {
            this.getConfig().set("shop.alternate-currency-symbol", (Object)Character.valueOf('$'));
            this.getConfig().set("config-version", (Object)4);
            selectedVersion = 4;
        }
        if (selectedVersion == 4) {
            this.getConfig().set("updater", (Object)true);
            this.getConfig().set("config-version", (Object)5);
            selectedVersion = 5;
        }
        if (selectedVersion == 5) {
            this.getConfig().set("config-version", (Object)6);
            selectedVersion = 6;
        }
        if (selectedVersion == 6) {
            this.getConfig().set("shop.sneak-to-control", (Object)false);
            this.getConfig().set("config-version", (Object)7);
            selectedVersion = 7;
        }
        if (selectedVersion == 7) {
            this.getConfig().set("database.prefix", (Object)"none");
            this.getConfig().set("config-version", (Object)8);
            selectedVersion = 8;
        }
        if (selectedVersion == 8) {
            this.getConfig().set("limits.old-algorithm", (Object)false);
            this.getConfig().set("plugin.ProtocolLib", (Object)false);
            this.getConfig().set("shop.ignore-unlimited", (Object)false);
            this.getConfig().set("config-version", (Object)9);
            selectedVersion = 9;
        }
        if (selectedVersion == 9) {
            this.getConfig().set("shop.enable-enderchest", (Object)true);
            this.getConfig().set("config-version", (Object)10);
            selectedVersion = 10;
        }
        if (selectedVersion == 10) {
            this.getConfig().set("shop.pay-player-from-unlimited-shop-owner", null);
            this.getConfig().set("config-version", (Object)11);
            selectedVersion = 11;
        }
        if (selectedVersion == 11) {
            this.getConfig().set("shop.enable-enderchest", null);
            this.getConfig().set("plugin.OpenInv", (Object)true);
            List shoppable = this.getConfig().getStringList("shop-blocks");
            shoppable.add("ENDER_CHEST");
            this.getConfig().set("shop-blocks", (Object)shoppable);
            this.getConfig().set("config-version", (Object)12);
            selectedVersion = 12;
        }
        if (selectedVersion == 12) {
            this.getConfig().set("plugin.ProtocolLib", null);
            this.getConfig().set("plugin.BKCommonLib", null);
            this.getConfig().set("database.use-varchar", null);
            this.getConfig().set("database.reconnect", null);
            this.getConfig().set("display-items-check-ticks", (Object)1200);
            this.getConfig().set("shop.bypass-owner-check", null);
            this.getConfig().set("config-version", (Object)13);
            selectedVersion = 13;
        }
        if (selectedVersion == 13) {
            this.getConfig().set("config-version", (Object)14);
            selectedVersion = 14;
        }
        if (selectedVersion == 14) {
            this.getConfig().set("plugin.AreaShop", null);
            this.getConfig().set("shop.special-region-only", null);
            this.getConfig().set("config-version", (Object)15);
            selectedVersion = 15;
        }
        if (selectedVersion == 15) {
            this.getConfig().set("ongoingfee", null);
            this.getConfig().set("shop.display-item-show-name", (Object)false);
            this.getConfig().set("shop.auto-fetch-shop-messages", (Object)true);
            this.getConfig().set("config-version", (Object)16);
            selectedVersion = 16;
        }
        if (selectedVersion == 16) {
            this.getConfig().set("config-version", (Object)17);
            selectedVersion = 17;
        }
        if (selectedVersion == 17) {
            this.getConfig().set("ignore-cancel-chat-event", (Object)false);
            this.getConfig().set("float", null);
            this.getConfig().set("config-version", (Object)18);
            selectedVersion = 18;
        }
        if (selectedVersion == 18) {
            this.getConfig().set("shop.disable-vault-format", (Object)false);
            this.getConfig().set("config-version", (Object)19);
            selectedVersion = 19;
        }
        if (selectedVersion == 19) {
            this.getConfig().set("shop.allow-shop-without-space-for-sign", (Object)true);
            this.getConfig().set("config-version", (Object)20);
            selectedVersion = 20;
        }
        if (selectedVersion == 20) {
            this.getConfig().set("shop.maximum-price", (Object)-1);
            this.getConfig().set("config-version", (Object)21);
            selectedVersion = 21;
        }
        if (selectedVersion == 21) {
            this.getConfig().set("shop.sign-material", (Object)"OAK_WALL_SIGN");
            this.getConfig().set("config-version", (Object)22);
            selectedVersion = 22;
        }
        if (selectedVersion == 22) {
            this.getConfig().set("include-offlineplayer-list", (Object)"false");
            this.getConfig().set("config-version", (Object)23);
            selectedVersion = 23;
        }
        if (selectedVersion == 23) {
            this.getConfig().set("lockette.enable", null);
            this.getConfig().set("lockette.item", null);
            this.getConfig().set("lockette.lore", null);
            this.getConfig().set("lockette.displayname", null);
            this.getConfig().set("float", null);
            this.getConfig().set("lockette.enable", (Object)true);
            this.getConfig().set("shop.blacklist-world", Lists.newArrayList("disabled_world_name"));
            this.getConfig().set("config-version", (Object)24);
            selectedVersion = 24;
        }
        if (selectedVersion == 24) {
            this.getConfig().set("config-version", (Object)25);
            selectedVersion = 25;
        }
        if (selectedVersion == 25) {
            String language = this.getConfig().getString("language");
            if (language == null || language.isEmpty() || "default".equals(language)) {
                this.getConfig().set("language", (Object)"en");
            }
            this.getConfig().set("config-version", (Object)26);
            selectedVersion = 26;
        }
        if (selectedVersion == 26) {
            this.getConfig().set("database.usessl", (Object)false);
            this.getConfig().set("config-version", (Object)27);
            selectedVersion = 27;
        }
        if (selectedVersion == 27) {
            this.getConfig().set("queue.enable", (Object)true);
            this.getConfig().set("queue.shops-per-tick", (Object)20);
            this.getConfig().set("config-version", (Object)28);
            selectedVersion = 28;
        }
        if (selectedVersion == 28) {
            this.getConfig().set("database.queue", (Object)true);
            this.getConfig().set("config-version", (Object)29);
            selectedVersion = 29;
        }
        if (selectedVersion == 29) {
            this.getConfig().set("plugin.Multiverse-Core", null);
            this.getConfig().set("shop.protection-checking", (Object)true);
            this.getConfig().set("config-version", (Object)30);
            selectedVersion = 30;
        }
        if (selectedVersion == 30) {
            this.getConfig().set("auto-report-errors", (Object)true);
            this.getConfig().set("config-version", (Object)31);
            selectedVersion = 31;
        }
        if (selectedVersion == 31) {
            this.getConfig().set("shop.display-type", (Object)0);
            this.getConfig().set("config-version", (Object)32);
            selectedVersion = 32;
        }
        if (selectedVersion == 32) {
            this.getConfig().set("effect.sound.ontabcomplete", (Object)true);
            this.getConfig().set("effect.sound.oncommand", (Object)true);
            this.getConfig().set("effect.sound.ononclick", (Object)true);
            this.getConfig().set("config-version", (Object)33);
            selectedVersion = 33;
        }
        if (selectedVersion == 33) {
            this.getConfig().set("matcher.item.damage", (Object)true);
            this.getConfig().set("matcher.item.displayname", (Object)true);
            this.getConfig().set("matcher.item.lores", (Object)true);
            this.getConfig().set("matcher.item.enchs", (Object)true);
            this.getConfig().set("matcher.item.potions", (Object)true);
            this.getConfig().set("matcher.item.attributes", (Object)true);
            this.getConfig().set("matcher.item.itemflags", (Object)true);
            this.getConfig().set("matcher.item.custommodeldata", (Object)true);
            this.getConfig().set("config-version", (Object)34);
            selectedVersion = 34;
        }
        if (selectedVersion == 34) {
            if (this.getConfig().getInt("shop.display-items-check-ticks") == 1200) {
                this.getConfig().set("shop.display-items-check-ticks", (Object)6000);
            }
            this.getConfig().set("config-version", (Object)35);
            selectedVersion = 35;
        }
        if (selectedVersion == 35) {
            this.getConfig().set("queue", null);
            this.getConfig().set("config-version", (Object)36);
            selectedVersion = 36;
        }
        if (selectedVersion == 36) {
            this.getConfig().set("economy-type", (Object)0);
            this.getConfig().set("config-version", (Object)37);
            selectedVersion = 37;
        }
        if (selectedVersion == 37) {
            this.getConfig().set("shop.ignore-cancel-chat-event", (Object)true);
            this.getConfig().set("config-version", (Object)38);
            selectedVersion = 38;
        }
        if (selectedVersion == 38) {
            this.getConfig().set("protect.inventorymove", (Object)true);
            this.getConfig().set("protect.spread", (Object)true);
            this.getConfig().set("protect.fromto", (Object)true);
            this.getConfig().set("protect.minecart", null);
            this.getConfig().set("protect.hopper", null);
            this.getConfig().set("config-version", (Object)39);
            selectedVersion = 39;
        }
        if (selectedVersion == 39) {
            this.getConfig().set("update-sign-when-inventory-moving", (Object)true);
            this.getConfig().set("config-version", (Object)40);
            selectedVersion = 39;
        }
        if (selectedVersion == 40) {
            this.getConfig().set("allow-economy-loan", (Object)false);
            this.getConfig().set("config-version", (Object)41);
            selectedVersion = 41;
        }
        if (selectedVersion == 41) {
            this.getConfig().set("send-display-item-protection-alert", (Object)true);
            this.getConfig().set("config-version", (Object)42);
            selectedVersion = 42;
        }
        if (selectedVersion == 42) {
            this.getConfig().set("config-version", (Object)43);
            selectedVersion = 43;
        }
        if (selectedVersion == 43) {
            this.getConfig().set("config-version", (Object)44);
            selectedVersion = 44;
        }
        if (selectedVersion == 44) {
            this.getConfig().set("matcher.item.repaircost", (Object)false);
            this.getConfig().set("config-version", (Object)45);
            selectedVersion = 45;
        }
        if (selectedVersion == 45) {
            this.getConfig().set("shop.display-item-use-name", (Object)true);
            this.getConfig().set("config-version", (Object)46);
            selectedVersion = 46;
        }
        if (selectedVersion == 46) {
            this.getConfig().set("shop.max-shops-checks-in-once", (Object)100);
            this.getConfig().set("config-version", (Object)47);
            selectedVersion = 47;
        }
        if (selectedVersion == 47) {
            this.getConfig().set("config-version", (Object)48);
            selectedVersion = 48;
        }
        if (selectedVersion == 48) {
            this.getConfig().set("permission-type", null);
            this.getConfig().set("shop.use-protection-checking-filter", null);
            this.getConfig().set("shop.protection-checking-filter", null);
            this.getConfig().set("config-version", (Object)49);
            selectedVersion = 49;
        }
        if (selectedVersion == 49 || selectedVersion == 50) {
            this.getConfig().set("shop.enchance-display-protect", (Object)false);
            this.getConfig().set("shop.enchance-shop-protect", (Object)false);
            this.getConfig().set("protect", null);
            this.getConfig().set("config-version", (Object)51);
            selectedVersion = 51;
        }
        if (selectedVersion < 60) {
            this.getConfig().set("config-version", (Object)60);
            selectedVersion = 60;
        }
        if (selectedVersion == 60) {
            this.getConfig().set("shop.strict-matches-check", null);
            this.getConfig().set("shop.display-auto-despawn", (Object)true);
            this.getConfig().set("shop.display-despawn-range", (Object)10);
            this.getConfig().set("shop.display-check-time", (Object)10);
            this.getConfig().set("config-version", (Object)61);
            selectedVersion = 61;
        }
        if (selectedVersion == 61) {
            this.getConfig().set("shop.word-for-sell-all-items", (Object)"all");
            this.getConfig().set("plugin.PlaceHolderAPI", (Object)true);
            this.getConfig().set("config-version", (Object)62);
            selectedVersion = 62;
        }
        if (selectedVersion == 62) {
            this.getConfig().set("shop.display-auto-despawn", (Object)false);
            this.getConfig().set("shop.word-for-trade-all-items", (Object)this.getConfig().getString("shop.word-for-sell-all-items"));
            this.getConfig().set("config-version", (Object)63);
            selectedVersion = 63;
        }
        if (selectedVersion == 63) {
            this.getConfig().set("shop.ongoing-fee.enable", (Object)false);
            this.getConfig().set("shop.ongoing-fee.ticks", (Object)42000);
            this.getConfig().set("shop.ongoing-fee.cost-per-shop", (Object)2);
            this.getConfig().set("shop.ongoing-fee.ignore-unlimited", (Object)true);
            this.getConfig().set("config-version", (Object)64);
            selectedVersion = 64;
        }
        if (selectedVersion == 64) {
            this.getConfig().set("shop.allow-free-shop", (Object)false);
            this.getConfig().set("config-version", (Object)65);
            selectedVersion = 65;
        }
        if (selectedVersion == 65) {
            this.getConfig().set("shop.minimum-price", (Object)0.01);
            this.getConfig().set("config-version", (Object)66);
            selectedVersion = 66;
        }
        if (selectedVersion == 66) {
            this.getConfig().set("use-decimal-format", (Object)false);
            this.getConfig().set("decimal-format", (Object)"#,###.##");
            this.getConfig().set("shop.show-owner-uuid-in-controlpanel-if-op", (Object)false);
            this.getConfig().set("config-version", (Object)67);
            selectedVersion = 67;
        }
        if (selectedVersion == 67) {
            this.getConfig().set("disable-debuglogger", (Object)false);
            this.getConfig().set("matcher.use-bukkit-matcher", null);
            this.getConfig().set("config-version", (Object)68);
            selectedVersion = 68;
        }
        if (selectedVersion == 68) {
            this.getConfig().set("shop.blacklist-lores", Lists.newArrayList("SoulBound"));
            this.getConfig().set("config-version", (Object)69);
            selectedVersion = 69;
        }
        if (selectedVersion == 69) {
            this.getConfig().set("shop.display-item-use-name", (Object)false);
            this.getConfig().set("config-version", (Object)70);
            selectedVersion = 70;
        }
        if (selectedVersion == 70) {
            this.getConfig().set("cachingpool.enable", (Object)false);
            this.getConfig().set("cachingpool.maxsize", (Object)100000000);
            this.getConfig().set("config-version", (Object)71);
            selectedVersion = 71;
        }
        if (selectedVersion == 71) {
            if (Objects.equals(this.getConfig().getString("language"), "en")) {
                this.getConfig().set("language", (Object)"en-US");
            }
            this.getConfig().set("server-platform", (Object)0);
            this.getConfig().set("config-version", (Object)72);
            selectedVersion = 72;
        }
        if (selectedVersion == 72) {
            if (this.getConfig().getBoolean("use-deciaml-format")) {
                this.getConfig().set("use-decimal-format", (Object)this.getConfig().getBoolean("use-deciaml-format"));
            } else {
                this.getConfig().set("use-decimal-format", (Object)false);
            }
            this.getConfig().set("use-deciaml-format", null);
            this.getConfig().set("shop.force-load-downgrade-items.enable", (Object)false);
            this.getConfig().set("shop.force-load-downgrade-items.method", (Object)0);
            this.getConfig().set("config-version", (Object)73);
            selectedVersion = 73;
        }
        if (selectedVersion == 73) {
            this.getConfig().set("mixedeconomy.deposit", (Object)"eco give {0} {1}");
            this.getConfig().set("mixedeconomy.withdraw", (Object)"eco take {0} {1}");
            this.getConfig().set("config-version", (Object)74);
            selectedVersion = 74;
        }
        if (selectedVersion == 74) {
            String langUtilsLanguage = this.getConfig().getString("langutils-language", "en_us");
            this.getConfig().set("langutils-language", null);
            if ("en_us".equals(langUtilsLanguage)) {
                langUtilsLanguage = "default";
            }
            this.getConfig().set("game-language", (Object)langUtilsLanguage);
            this.getConfig().set("maximum-digits-in-price", (Object)-1);
            this.getConfig().set("config-version", (Object)75);
            selectedVersion = 75;
        }
        if (selectedVersion == 75) {
            this.getConfig().set("langutils-language", null);
            if (this.getConfig().getString("game-language") == null) {
                this.getConfig().set("game-language", (Object)"default");
            }
            this.getConfig().set("config-version", (Object)76);
            selectedVersion = 76;
        }
        if (selectedVersion == 76) {
            this.getConfig().set("database.auto-fix-encoding-issue-in-database", (Object)false);
            this.getConfig().set("send-shop-protection-alert", (Object)false);
            this.getConfig().set("send-display-item-protection-alert", (Object)false);
            this.getConfig().set("shop.use-fast-shop-search-algorithm", (Object)false);
            this.getConfig().set("config-version", (Object)77);
            selectedVersion = 77;
        }
        if (selectedVersion == 77) {
            this.getConfig().set("integration.towny.enable", (Object)false);
            this.getConfig().set("integration.towny.create", (Object)new String[]{"SHOPTYPE", "MODIFY"});
            this.getConfig().set("integration.towny.trade", (Object)new String[0]);
            this.getConfig().set("integration.worldguard.enable", (Object)false);
            this.getConfig().set("integration.worldguard.create", (Object)new String[]{"FLAG", "CHEST_ACCESS"});
            this.getConfig().set("integration.worldguard.trade", (Object)new String[0]);
            this.getConfig().set("integration.plotsquared.enable", (Object)false);
            this.getConfig().set("integration.plotsquared.enable", (Object)false);
            this.getConfig().set("integration.plotsquared.enable", (Object)false);
            this.getConfig().set("integration.residence.enable", (Object)false);
            this.getConfig().set("integration.residence.create", (Object)new String[]{"FLAG", "interact", "use"});
            this.getConfig().set("integration.residence.trade", (Object)new String[0]);
            this.getConfig().set("integration.factions.enable", (Object)false);
            this.getConfig().set("integration.factions.create.flag", (Object)new String[0]);
            this.getConfig().set("integration.factions.trade.flag", (Object)new String[0]);
            this.getConfig().set("integration.factions.create.require.open", (Object)false);
            this.getConfig().set("integration.factions.create.require.normal", (Object)true);
            this.getConfig().set("integration.factions.create.require.wilderness", (Object)false);
            this.getConfig().set("integration.factions.create.require.peaceful", (Object)true);
            this.getConfig().set("integration.factions.create.require.permanent", (Object)false);
            this.getConfig().set("integration.factions.create.require.safezone", (Object)false);
            this.getConfig().set("integration.factions.create.require.own", (Object)false);
            this.getConfig().set("integration.factions.create.require.warzone", (Object)false);
            this.getConfig().set("integration.factions.trade.require.open", (Object)false);
            this.getConfig().set("integration.factions.trade.require.normal", (Object)true);
            this.getConfig().set("integration.factions.trade.require.wilderness", (Object)false);
            this.getConfig().set("integration.factions.trade.require.peaceful", (Object)false);
            this.getConfig().set("integration.factions.trade.require.permanent", (Object)false);
            this.getConfig().set("integration.factions.trade.require.safezone", (Object)false);
            this.getConfig().set("integration.factions.trade.require.own", (Object)false);
            this.getConfig().set("integration.factions.trade.require.warzone", (Object)false);
            this.getConfig().set("anonymous-metrics", null);
            this.getConfig().set("shop.ongoing-fee.async", (Object)true);
            this.getConfig().set("config-version", (Object)78);
            selectedVersion = 78;
        }
        if (selectedVersion == 78) {
            this.getConfig().set("shop.display-type-specifics", null);
            this.getConfig().set("config-version", (Object)79);
            selectedVersion = 79;
        }
        if (selectedVersion == 79) {
            this.getConfig().set("matcher.item.books", (Object)true);
            this.getConfig().set("config-version", (Object)80);
            selectedVersion = 80;
        }
        if (selectedVersion == 80) {
            this.getConfig().set("shop.use-fast-shop-search-algorithm", (Object)true);
            this.getConfig().set("config-version", (Object)81);
            selectedVersion = 81;
        }
        if (selectedVersion == 81) {
            this.getConfig().set("config-version", (Object)82);
            selectedVersion = 82;
        }
        if (selectedVersion == 82) {
            this.getConfig().set("matcher.item.banner", (Object)true);
            this.getConfig().set("config-version", (Object)83);
            selectedVersion = 83;
        }
        if (selectedVersion == 83) {
            this.getConfig().set("matcher.item.banner", (Object)true);
            this.getConfig().set("protect.explode", (Object)true);
            this.getConfig().set("config-version", (Object)84);
            selectedVersion = 84;
        }
        if (selectedVersion == 84) {
            this.getConfig().set("disable-debuglogger", null);
            this.getConfig().set("config-version", (Object)85);
            selectedVersion = 85;
        }
        if (selectedVersion == 85) {
            this.getConfig().set("config-version", (Object)86);
            selectedVersion = 86;
        }
        if (selectedVersion == 86) {
            this.getConfig().set("shop.use-fast-shop-search-algorithm", (Object)true);
            this.getConfig().set("config-version", (Object)87);
            selectedVersion = 87;
        }
        if (selectedVersion == 87) {
            this.getConfig().set("plugin.BlockHub.enable", (Object)true);
            this.getConfig().set("plugin.BlockHub.only", (Object)false);
            if (Bukkit.getPluginManager().getPlugin("ProtocolLib") != null) {
                this.getConfig().set("shop.display-type", (Object)2);
            }
            this.getConfig().set("config-version", (Object)88);
            selectedVersion = 88;
        }
        if (selectedVersion == 88) {
            this.getConfig().set("respect-item-flag", (Object)true);
            this.getConfig().set("config-version", (Object)89);
            selectedVersion = 89;
        }
        if (selectedVersion == 89) {
            this.getConfig().set("use-caching", (Object)true);
            this.getConfig().set("config-version", (Object)90);
            selectedVersion = 90;
        }
        if (selectedVersion == 90) {
            this.getConfig().set("protect.hopper", (Object)true);
            this.getConfig().set("config-version", (Object)91);
            selectedVersion = 91;
        }
        if (selectedVersion == 91) {
            this.getConfig().set("database.queue-commit-interval", (Object)2);
            this.getConfig().set("config-version", (Object)92);
            selectedVersion = 92;
        }
        if (selectedVersion == 92) {
            this.getConfig().set("send-display-item-protection-alert", (Object)false);
            this.getConfig().set("send-shop-protection-alert", (Object)false);
            this.getConfig().set("disable-creative-mode-trading", (Object)false);
            this.getConfig().set("disable-super-tool", (Object)false);
            this.getConfig().set("allow-owner-break-shop-sign", (Object)false);
            this.getConfig().set("matcher.item.skull", (Object)true);
            this.getConfig().set("matcher.item.firework", (Object)true);
            this.getConfig().set("matcher.item.map", (Object)true);
            this.getConfig().set("matcher.item.leatherArmor", (Object)true);
            this.getConfig().set("matcher.item.fishBucket", (Object)true);
            this.getConfig().set("matcher.item.suspiciousStew", (Object)true);
            this.getConfig().set("matcher.item.shulkerBox", (Object)true);
            this.getConfig().set("config-version", (Object)93);
            selectedVersion = 93;
        }
        if (selectedVersion == 93) {
            this.getConfig().set("disable-creative-mode-trading", null);
            this.getConfig().set("disable-super-tool", null);
            this.getConfig().set("allow-owner-break-shop-sign", null);
            this.getConfig().set("shop.disable-creative-mode-trading", (Object)true);
            this.getConfig().set("shop.disable-super-tool", (Object)true);
            this.getConfig().set("shop.allow-owner-break-shop-sign", (Object)false);
            this.getConfig().set("config-version", (Object)94);
            selectedVersion = 94;
        }
        if (selectedVersion == 94) {
            if (this.getConfig().isSet("price-restriction")) {
                this.getConfig().set("shop.price-restriction", (Object)this.getConfig().getStringList("price-restriction"));
                this.getConfig().set("price-restriction", null);
            } else {
                this.getConfig().set("shop.price-restriction", new ArrayList(0));
            }
            this.getConfig().set("enable-log4j", null);
            this.getConfig().set("config-version", (Object)95);
            selectedVersion = 95;
        }
        if (selectedVersion == 95) {
            this.getConfig().set("shop.allow-stacks", (Object)false);
            this.getConfig().set("shop.display-allow-stacks", (Object)false);
            this.getConfig().set("custom-item-stacksize", new ArrayList(0));
            this.getConfig().set("config-version", (Object)96);
            selectedVersion = 96;
        }
        if (selectedVersion == 96) {
            this.getConfig().set("shop.deny-non-shop-items-to-shop-container", (Object)false);
            this.getConfig().set("config-version", (Object)97);
            selectedVersion = 97;
        }
        if (selectedVersion == 97) {
            this.getConfig().set("shop.disable-quick-create", (Object)false);
            this.getConfig().set("config-version", (Object)98);
            selectedVersion = 98;
        }
        if (selectedVersion == 98) {
            this.getConfig().set("config-version", (Object)99);
            selectedVersion = 99;
        }
        if (selectedVersion == 99) {
            this.getConfig().set("shop.currency-symbol-on-right", (Object)false);
            this.getConfig().set("config-version", (Object)100);
            selectedVersion = 100;
        }
        if (selectedVersion == 100) {
            this.getConfig().set("integration.towny.ignore-disabled-worlds", (Object)false);
            this.getConfig().set("config-version", (Object)101);
            selectedVersion = 101;
        }
        if (selectedVersion == 101) {
            this.getConfig().set("matcher.work-type", (Object)1);
            this.getConfig().set("work-type", null);
            this.getConfig().set("plugin.LWC", (Object)true);
            this.getConfig().set("config-version", (Object)102);
            selectedVersion = 102;
        }
        if (selectedVersion == 102) {
            this.getConfig().set("protect.entity", (Object)true);
            this.getConfig().set("config-version", (Object)103);
            selectedVersion = 103;
        }
        if (selectedVersion == 103) {
            this.getConfig().set("integration.worldguard.whitelist-mode", (Object)false);
            this.getConfig().set("integration.factions.whitelist-mode", (Object)true);
            this.getConfig().set("integration.plotsquared.whitelist-mode", (Object)true);
            this.getConfig().set("integration.residence.whitelist-mode", (Object)true);
            this.getConfig().set("config-version", (Object)104);
            selectedVersion = 104;
        }
        if (selectedVersion == 104) {
            this.getConfig().set("cachingpool", null);
            this.getConfig().set("config-version", (Object)105);
            selectedVersion = 105;
        }
        if (selectedVersion == 105) {
            this.getConfig().set("shop.interact.sneak-to-create", (Object)this.getConfig().getBoolean("shop.sneak-to-create"));
            this.getConfig().set("shop.sneak-to-create", null);
            this.getConfig().set("shop.interact.sneak-to-trade", (Object)this.getConfig().getBoolean("shop.sneak-to-trade"));
            this.getConfig().set("shop.sneak-to-trade", null);
            this.getConfig().set("shop.interact.sneak-to-control", (Object)this.getConfig().getBoolean("shop.sneak-to-control"));
            this.getConfig().set("shop.sneak-to-control", null);
            this.getConfig().set("config-version", (Object)106);
            selectedVersion = 106;
        }
        if (selectedVersion == 106) {
            this.getConfig().set("shop.use-enchantment-for-enchanted-book", (Object)false);
            this.getConfig().set("config-version", (Object)107);
            selectedVersion = 107;
        }
        if (selectedVersion == 107) {
            this.getConfig().set("integration.lands.enable", (Object)false);
            this.getConfig().set("integration.lands.whitelist-mode", (Object)false);
            this.getConfig().set("integration.lands.ignore-disabled-worlds", (Object)true);
            this.getConfig().set("config-version", (Object)108);
            selectedVersion = 108;
        }
        if (selectedVersion == 108) {
            this.getConfig().set("debug.shop-deletion", (Object)false);
            this.getConfig().set("config-version", (Object)109);
            selectedVersion = 109;
        }
        if (selectedVersion == 109) {
            this.getConfig().set("shop.protection-checking-blacklist", Collections.singletonList("disabled_world"));
            this.getConfig().set("config-version", (Object)110);
            selectedVersion = 110;
        }
        if (selectedVersion == 110) {
            this.getConfig().set("integration.worldguard.any-owner", (Object)true);
            this.getConfig().set("config-version", (Object)111);
            selectedVersion = 111;
        }
        if (selectedVersion == 111) {
            this.getConfig().set("logging.enable", (Object)this.getConfig().getBoolean("log-actions"));
            this.getConfig().set("logging.log-actions", (Object)this.getConfig().getBoolean("log-actions"));
            this.getConfig().set("logging.log-balance", (Object)true);
            this.getConfig().set("logging.file-size", (Object)10);
            this.getConfig().set("debug.disable-debuglogger", (Object)false);
            this.getConfig().set("trying-fix-banlance-insuffient", (Object)false);
            this.getConfig().set("log-actions", null);
            this.getConfig().set("config-version", (Object)112);
            selectedVersion = 112;
        }
        if (selectedVersion == 112) {
            this.getConfig().set("integration.lands.delete-on-lose-permission", (Object)false);
            this.getConfig().set("config-version", (Object)113);
            selectedVersion = 113;
        }
        if (selectedVersion == 113) {
            this.getConfig().set("config-damaged", (Object)false);
            this.getConfig().set("config-version", (Object)114);
            selectedVersion = 114;
        }
        if (selectedVersion == 114) {
            this.getConfig().set("shop.interact.interact-mode", (Object)(this.getConfig().getBoolean("shop.interact.switch-mode") ? 0 : 1));
            this.getConfig().set("shop.interact.switch-mode", null);
            this.getConfig().set("config-version", (Object)115);
            selectedVersion = 115;
        }
        if (selectedVersion == 115) {
            this.getConfig().set("integration.griefprevention.enable", (Object)false);
            this.getConfig().set("integration.griefprevention.whitelist-mode", (Object)false);
            this.getConfig().set("integration.griefprevention.create", Collections.emptyList());
            this.getConfig().set("integration.griefprevention.trade", Collections.emptyList());
            this.getConfig().set("config-version", (Object)116);
            selectedVersion = 116;
        }
        if (selectedVersion == 116) {
            this.getConfig().set("shop.sending-stock-message-to-staffs", (Object)false);
            this.getConfig().set("integration.towny.delete-shop-on-resident-leave", (Object)false);
            this.getConfig().set("config-version", (Object)117);
            selectedVersion = 117;
        }
        if (selectedVersion == 117) {
            this.getConfig().set("shop.finding.distance", (Object)this.getConfig().getInt("shop.find-distance"));
            this.getConfig().set("shop.finding.limit", (Object)10);
            this.getConfig().set("shop.find-distance", null);
            this.getConfig().set("config-version", (Object)(++selectedVersion));
        }
        if (selectedVersion == 118) {
            this.getConfig().set("shop.finding.oldLogic", (Object)false);
            this.getConfig().set("config-version", (Object)(++selectedVersion));
        }
        if (selectedVersion == 119) {
            this.getConfig().set("debug.adventure", (Object)false);
            this.getConfig().set("shop.finding.all", (Object)false);
            this.getConfig().set("chat-type", (Object)0);
            this.getConfig().set("config-version", (Object)(++selectedVersion));
        }
        if (selectedVersion == 120) {
            this.getConfig().set("shop.finding.exclude-out-of-stock", (Object)false);
            this.getConfig().set("chat-type", (Object)0);
            this.getConfig().set("config-version", (Object)(++selectedVersion));
        }
        if (selectedVersion == 121) {
            this.getConfig().set("shop.protection-checking-handler", (Object)0);
            this.getConfig().set("shop.protection-checking-listener-blacklist", Collections.singletonList("ignored_listener"));
            this.getConfig().set("config-version", (Object)(++selectedVersion));
        }
        if (selectedVersion == 122) {
            this.getConfig().set("currency", (Object)"");
            this.getConfig().set("shop.alternate-currency-symbol-list", Arrays.asList("CNY;\u00a5", "USD;$"));
            this.getConfig().set("config-version", (Object)(++selectedVersion));
        }
        if (selectedVersion == 123) {
            this.getConfig().set("integration.fabledskyblock.enable", (Object)false);
            this.getConfig().set("integration.fabledskyblock.whitelist-mode", (Object)false);
            this.getConfig().set("config-version", (Object)(++selectedVersion));
        }
        if (selectedVersion == 124) {
            this.getConfig().set("plugin.BKCommonLib", (Object)true);
            this.getConfig().set("config-version", (Object)(++selectedVersion));
        }
        if (selectedVersion == 125) {
            this.getConfig().set("integration.superiorskyblock.enable", (Object)false);
            this.getConfig().set("integration.superiorskyblock.owner-create-only", (Object)false);
            this.getConfig().set("integration.superiorskyblock.delete-shop-on-member-leave", (Object)true);
            this.getConfig().set("shop.interact.swap-click-behavior", (Object)false);
            this.getConfig().set("config-version", (Object)(++selectedVersion));
        }
        if (selectedVersion == 126) {
            this.getConfig().set("debug.delete-corrupt-shops", (Object)false);
            this.getConfig().set("config-version", (Object)(++selectedVersion));
        }
        if (selectedVersion == 127) {
            this.getConfig().set("integration.plotsquared.delete-when-user-untrusted", (Object)true);
            this.getConfig().set("integration.towny.delete-shop-on-plot-clear", (Object)true);
            this.getConfig().set("config-version", (Object)(++selectedVersion));
        }
        if (selectedVersion == 128) {
            this.getConfig().set("shop.force-use-item-original-name", (Object)false);
            this.getConfig().set("integration.griefprevention.delete-on-untrusted", (Object)false);
            this.getConfig().set("config-version", (Object)(++selectedVersion));
        }
        if (selectedVersion == 129) {
            this.getConfig().set("shop.use-global-virtual-item-queue", (Object)false);
            this.getConfig().set("config-version", (Object)(++selectedVersion));
        }
        if (selectedVersion == 130) {
            this.getConfig().set("plugin.WorldEdit", (Object)true);
            this.getConfig().set("config-version", (Object)(++selectedVersion));
        }
        if (selectedVersion == 131) {
            this.getConfig().set("custom-commands", ImmutableList.of("shop", "chestshop", "cshop"));
            this.getConfig().set("unlimited-shop-owner-change", (Object)false);
            this.getConfig().set("unlimited-shop-owner-change-account", (Object)"quickshop");
            this.getConfig().set("config-version", (Object)(++selectedVersion));
        }
        if (selectedVersion == 132) {
            this.getConfig().set("shop.sign-glowing", (Object)false);
            this.getConfig().set("shop.sign-dye-color", (Object)"null");
            this.getConfig().set("unlimited-shop-owner-change-account", (Object)"quickshop");
            this.getConfig().set("config-version", (Object)(++selectedVersion));
        }
        if (this.getConfig().getInt("matcher.work-type") != 0 && GameVersion.get(ReflectFactory.getServerVersion()).name().contains("1_16")) {
            this.getLogger().warning("You are not using QS Matcher, it may meeting item comparing issue mentioned there: https://hub.spigotmc.org/jira/browse/SPIGOT-5063");
        }
        try (InputStreamReader buildInConfigReader = new InputStreamReader(new BufferedInputStream(Objects.requireNonNull(this.getResource("config.yml"))));){
            new ConfigurationFixer(this, (FileConfiguration)YamlConfiguration.loadConfiguration((Reader)buildInConfigReader)).fix();
        }
        this.saveConfig();
        this.reloadConfig();
        new File(this.getDataFolder(), "example.config.yml").delete();
        new File(this.getDataFolder(), "example-configuration.txt").delete();
        Path exampleConfigFile = new File(this.getDataFolder(), "example-configuration.yml").toPath();
        try {
            Files.copy(Objects.requireNonNull(this.getResource("config.yml")), exampleConfigFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ioe) {
            this.getLogger().warning("Error when creating the example config file: " + ioe.getMessage());
        }
    }

    public void setupBootError(BootError bootError) {
        this.bootError = bootError;
        HandlerList.unregisterAll((Plugin)this);
        Bukkit.getScheduler().cancelTasks((Plugin)this);
    }

    public void registerCustomCommands() {
        List customCommands = this.getConfig().getStringList("custom-commands");
        PluginCommand quickShopCommand = this.getCommand("qs");
        if (quickShopCommand == null) {
            this.getLogger().warning("Failed to get QuickShop PluginCommand instance.");
            return;
        }
        List aliases = quickShopCommand.getAliases();
        aliases.addAll(customCommands);
        quickShopCommand.setAliases(aliases);
        try {
            ReflectFactory.getCommandMap().register("qs", (Command)quickShopCommand);
            ReflectFactory.syncCommands();
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to register command aliases", e);
            return;
        }
        Util.debugLog("Command alias successfully registered.");
    }

    public static boolean isTesting() {
        return testing;
    }

    public CompatibilityManager getCompatibilityTool() {
        return this.compatibilityTool;
    }

    public Map<String, Integer> getLimits() {
        return this.limits;
    }

    public List<BukkitTask> getTimerTaskList() {
        return this.timerTaskList;
    }

    public GameVersion getGameVersion() {
        return this.gameVersion;
    }

    public IntegrationHelper getIntegrationHelper() {
        return this.integrationHelper;
    }

    @Nullable
    public BootError getBootError() {
        return this.bootError;
    }

    public void setBootError(@Nullable BootError bootError) {
        this.bootError = bootError;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public DatabaseHelper getDatabaseHelper() {
        return this.databaseHelper;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public String getDbPrefix() {
        return this.dbPrefix;
    }

    public boolean isDisplay() {
        return this.display;
    }

    public int getDisplayItemCheckTicks() {
        return this.displayItemCheckTicks;
    }

    public DisplayWatcher getDisplayWatcher() {
        return this.displayWatcher;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public ItemMatcher getItemMatcher() {
        return this.itemMatcher;
    }

    public Language getLanguage() {
        return this.language;
    }

    public boolean isLimit() {
        return this.limit;
    }

    @Nullable
    public LogWatcher getLogWatcher() {
        return this.logWatcher;
    }

    public Plugin getOpenInvPlugin() {
        return this.openInvPlugin;
    }

    public Plugin getPlaceHolderAPI() {
        return this.placeHolderAPI;
    }

    public PermissionChecker getPermissionChecker() {
        return this.permissionChecker;
    }

    public boolean isPriceChangeRequiresFee() {
        return this.priceChangeRequiresFee;
    }

    public RollbarErrorReporter getSentryErrorReporter() {
        return this.sentryErrorReporter;
    }

    public UUID getServerUniqueID() {
        return this.serverUniqueID;
    }

    public ShopLoader getShopLoader() {
        return this.shopLoader;
    }

    public ShopManager getShopManager() {
        return this.shopManager;
    }

    public DisplayAutoDespawnWatcher getDisplayAutoDespawnWatcher() {
        return this.displayAutoDespawnWatcher;
    }

    public OngoingFeeWatcher getOngoingFeeWatcher() {
        return this.ongoingFeeWatcher;
    }

    public SignUpdateWatcher getSignUpdateWatcher() {
        return this.signUpdateWatcher;
    }

    public ShopContainerWatcher getShopContainerWatcher() {
        return this.shopContainerWatcher;
    }

    @Deprecated
    public DisplayDupeRemoverWatcher getDisplayDupeRemoverWatcher() {
        return this.displayDupeRemoverWatcher;
    }

    public boolean isEnabledAsyncDisplayDespawn() {
        return this.enabledAsyncDisplayDespawn;
    }

    public String getPreviewProtectionLore() {
        return this.previewProtectionLore;
    }

    public Plugin getBlockHubPlugin() {
        return this.blockHubPlugin;
    }

    public Plugin getLwcPlugin() {
        return this.lwcPlugin;
    }

    public Cache getShopCache() {
        return this.shopCache;
    }

    public boolean isAllowStack() {
        return this.allowStack;
    }

    public EnvironmentChecker getEnvironmentChecker() {
        return this.environmentChecker;
    }

    @Nullable
    public UpdateWatcher getUpdateWatcher() {
        return this.updateWatcher;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public QuickChatType getQuickChatType() {
        return this.quickChatType;
    }

    public QuickChat getQuickChat() {
        return this.quickChat;
    }

    @Nullable
    public String getCurrency() {
        return this.currency;
    }

    public ShopControlPanel getShopControlPanelManager() {
        return this.shopControlPanelManager;
    }

    public CalendarWatcher getCalendarWatcher() {
        return this.calendarWatcher;
    }

    public Plugin getWorldEditPlugin() {
        return this.worldEditPlugin;
    }

    public WorldEditAdapter getWorldEditAdapter() {
        return this.worldEditAdapter;
    }

    static {
        loaded = false;
        testing = false;
    }
}

