/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.builtinlistener;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.event.ShopCreateEvent;
import org.maxgamer.quickshop.event.ShopDeleteEvent;
import org.maxgamer.quickshop.event.ShopModeratorChangedEvent;
import org.maxgamer.quickshop.event.ShopPriceChangeEvent;
import org.maxgamer.quickshop.event.ShopPurchaseEvent;
import org.maxgamer.quickshop.event.ShopSuccessPurchaseEvent;
import org.maxgamer.quickshop.shop.ShopType;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class InternalListener
implements Listener {
    private final QuickShop plugin;
    private final boolean loggingBalance;
    private final boolean loggingAction;

    public InternalListener(QuickShop plugin) {
        this.plugin = plugin;
        this.loggingBalance = plugin.getConfig().getBoolean("logging.log-balance");
        this.loggingAction = plugin.getConfig().getBoolean("logging.log-actions");
    }

    public boolean isForbidden(@NotNull Material shopMaterial, @NotNull Material itemMaterial) {
        if (!Objects.equals(shopMaterial, itemMaterial)) {
            return false;
        }
        return shopMaterial.isBlock() && shopMaterial.name().toUpperCase().endsWith("SHULKER_BOX");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void shopCreate(ShopCreateEvent event) {
        if (this.isForbidden(event.getShop().getLocation().getBlock().getType(), event.getShop().getItem().getType())) {
            event.setCancelled(true);
            MsgUtil.sendMessage(event.getCreator(), "forbidden-vanilla-behavior", new String[0]);
            return;
        }
        if (this.loggingAction) {
            Player creator = this.plugin.getServer().getPlayer(event.getCreator());
            this.plugin.log("Player " + (creator != null ? creator.getName() : event.getCreator()) + " created a shop at location " + event.getShop().getLocation());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void shopDelete(ShopDeleteEvent event) {
        if (this.loggingAction) {
            this.plugin.log("Shop at " + event.getShop().getLocation() + " was removed.");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void shopModeratorChanges(ShopModeratorChangedEvent event) {
        if (this.loggingAction) {
            this.plugin.log("Shop at location " + event.getShop().getLocation() + " moderator was changed to " + event.getModerator());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void shopPriceChanges(ShopPriceChangeEvent event) {
        if (this.loggingAction) {
            this.plugin.log("Shop at location " + event.getShop().getLocation() + " price was changed from " + event.getOldPrice() + " to " + event.getNewPrice());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void shopPrePurchase(ShopPurchaseEvent event) {
        if (this.isForbidden(event.getShop().getLocation().getBlock().getType(), event.getShop().getItem().getType())) {
            event.setCancelled(true);
            MsgUtil.sendMessage(event.getPurchaser(), "forbidden-vanilla-behavior", new String[0]);
            return;
        }
        if (this.loggingBalance) {
            Player creator = Bukkit.getPlayer((UUID)event.getPurchaser());
            this.plugin.log("Player " + (creator != null ? creator.getName() : event.getPurchaser()) + " had " + this.plugin.getEconomy().getBalance(event.getPurchaser(), event.getShop().getLocation().getWorld(), event.getShop().getCurrency()) + " before trading.");
            this.plugin.log("Shop Owner " + event.getShop().ownerName() + " had " + this.plugin.getEconomy().getBalance(event.getShop().getOwner(), event.getShop().getLocation().getWorld(), event.getShop().getCurrency()) + " before trading.");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void shopPurchase(ShopSuccessPurchaseEvent event) {
        Player player;
        Player creator = this.plugin.getServer().getPlayer(event.getPurchaser());
        if (this.loggingAction) {
            if (event.getShop().getShopType() == ShopType.BUYING) {
                this.plugin.log("Player " + (creator != null ? creator.getName() : event.getPurchaser()) + " sold " + event.getShop().ownerName() + " shop " + event.getShop() + " for" + Util.getItemStackName(event.getShop().getItem()) + "x" + event.getAmount() + " for " + event.getBalance() + " (" + event.getTax() + " tax).");
            }
            if (event.getShop().getShopType() == ShopType.SELLING) {
                this.plugin.log("Player " + (creator != null ? creator.getName() : event.getPurchaser()) + " bought " + event.getShop().ownerName() + " shop " + event.getShop() + " for " + Util.getItemStackName(event.getShop().getItem()) + " x" + event.getAmount() + " for " + event.getBalance() + " (" + event.getTax() + " tax).");
            }
        }
        if (this.loggingBalance) {
            this.plugin.log("Player " + (creator != null ? creator.getName() : event.getPurchaser()) + " had " + this.plugin.getEconomy().getBalance(event.getPurchaser(), event.getShop().getLocation().getWorld(), event.getShop().getCurrency()) + " after trading.");
            this.plugin.log("Shop Owner " + event.getShop().ownerName() + " had " + this.plugin.getEconomy().getBalance(event.getShop().getOwner(), event.getShop().getLocation().getWorld(), event.getShop().getCurrency()) + " after trading.");
        }
        if (event.getPurchaser().equals(event.getShop().getOwner()) && (player = Bukkit.getPlayer((UUID)event.getPurchaser())) != null) {
            MsgUtil.sendMessage((CommandSender)player, "shop-owner-self-trade", new String[0]);
        }
    }
}

