/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.util.MsgUtil;

public class CommandContainer {
    @NotNull
    private CommandHandler<?> executor;
    private boolean hidden;
    private List<String> selectivePermissions;
    private List<String> permissions;
    @NotNull
    private String prefix;
    @Nullable
    private String description;
    private boolean disabled;
    @Nullable
    private String disablePlaceholder;
    @Nullable
    private @Nullable Function<@Nullable CommandSender, @NotNull String> disableCallback;
    private Class<?> executorType;

    @NotNull
    public Class<?> getExecutorType() {
        if (this.executorType == null) {
            this.bakeExecutorType();
        }
        return this.executorType;
    }

    public void bakeExecutorType() {
        for (Method declaredMethod : this.getExecutor().getClass().getDeclaredMethods()) {
            if (!"onCommand".equals(declaredMethod.getName()) && !"onTabComplete".equals(declaredMethod.getName()) || declaredMethod.getParameterCount() != 3 || declaredMethod.getModifiers() != 1) continue;
            this.executorType = declaredMethod.getParameterTypes()[0];
            return;
        }
        this.executorType = Object.class;
    }

    @NotNull
    public final String getDisableText(@NotNull CommandSender sender) {
        if (this.getDisableCallback() != null) {
            return this.getDisableCallback().apply(sender);
        }
        if (StringUtils.isNotEmpty((String)this.getDisablePlaceholder())) {
            return this.getDisablePlaceholder();
        }
        return MsgUtil.getMessage("command.feature-not-enabled", null, new String[0]);
    }

    CommandContainer(@NotNull CommandHandler<?> executor, boolean hidden, List<String> selectivePermissions, List<String> permissions, @NotNull String prefix, @Nullable String description, boolean disabled, @Nullable String disablePlaceholder, @Nullable @Nullable Function<@Nullable CommandSender, @NotNull String> disableCallback, Class<?> executorType) {
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        this.executor = executor;
        this.hidden = hidden;
        this.selectivePermissions = selectivePermissions;
        this.permissions = permissions;
        this.prefix = prefix;
        this.description = description;
        this.disabled = disabled;
        this.disablePlaceholder = disablePlaceholder;
        this.disableCallback = disableCallback;
        this.executorType = executorType;
    }

    public static CommandContainerBuilder builder() {
        return new CommandContainerBuilder();
    }

    @NotNull
    public CommandHandler<?> getExecutor() {
        return this.executor;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public List<String> getSelectivePermissions() {
        return this.selectivePermissions;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    @NotNull
    public String getPrefix() {
        return this.prefix;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @Nullable
    public String getDisablePlaceholder() {
        return this.disablePlaceholder;
    }

    @Nullable
    public @Nullable Function<@Nullable CommandSender, @NotNull String> getDisableCallback() {
        return this.disableCallback;
    }

    public void setExecutor(@NotNull CommandHandler<?> executor) {
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.executor = executor;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setSelectivePermissions(List<String> selectivePermissions) {
        this.selectivePermissions = selectivePermissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public void setPrefix(@NotNull String prefix) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        this.prefix = prefix;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setDisablePlaceholder(@Nullable String disablePlaceholder) {
        this.disablePlaceholder = disablePlaceholder;
    }

    public void setDisableCallback(@Nullable @Nullable Function<@Nullable CommandSender, @NotNull String> disableCallback) {
        this.disableCallback = disableCallback;
    }

    public void setExecutorType(Class<?> executorType) {
        this.executorType = executorType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandContainer)) {
            return false;
        }
        CommandContainer other = (CommandContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHidden() != other.isHidden()) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        CommandHandler<?> this$executor = this.getExecutor();
        CommandHandler<?> other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        List<String> this$selectivePermissions = this.getSelectivePermissions();
        List<String> other$selectivePermissions = other.getSelectivePermissions();
        if (this$selectivePermissions == null ? other$selectivePermissions != null : !((Object)this$selectivePermissions).equals(other$selectivePermissions)) {
            return false;
        }
        List<String> this$permissions = this.getPermissions();
        List<String> other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$disablePlaceholder = this.getDisablePlaceholder();
        String other$disablePlaceholder = other.getDisablePlaceholder();
        if (this$disablePlaceholder == null ? other$disablePlaceholder != null : !this$disablePlaceholder.equals(other$disablePlaceholder)) {
            return false;
        }
        Function<CommandSender, String> this$disableCallback = this.getDisableCallback();
        Function<CommandSender, String> other$disableCallback = other.getDisableCallback();
        if (this$disableCallback == null ? other$disableCallback != null : !this$disableCallback.equals(other$disableCallback)) {
            return false;
        }
        Class<?> this$executorType = this.getExecutorType();
        Class<?> other$executorType = other.getExecutorType();
        return !(this$executorType == null ? other$executorType != null : !this$executorType.equals(other$executorType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHidden() ? 79 : 97);
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        CommandHandler<?> $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        List<String> $selectivePermissions = this.getSelectivePermissions();
        result = result * 59 + ($selectivePermissions == null ? 43 : ((Object)$selectivePermissions).hashCode());
        List<String> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $disablePlaceholder = this.getDisablePlaceholder();
        result = result * 59 + ($disablePlaceholder == null ? 43 : $disablePlaceholder.hashCode());
        Function<CommandSender, String> $disableCallback = this.getDisableCallback();
        result = result * 59 + ($disableCallback == null ? 43 : $disableCallback.hashCode());
        Class<?> $executorType = this.getExecutorType();
        result = result * 59 + ($executorType == null ? 43 : $executorType.hashCode());
        return result;
    }

    public String toString() {
        return "CommandContainer(executor=" + this.getExecutor() + ", hidden=" + this.isHidden() + ", selectivePermissions=" + this.getSelectivePermissions() + ", permissions=" + this.getPermissions() + ", prefix=" + this.getPrefix() + ", description=" + this.getDescription() + ", disabled=" + this.isDisabled() + ", disablePlaceholder=" + this.getDisablePlaceholder() + ", disableCallback=" + this.getDisableCallback() + ", executorType=" + this.getExecutorType() + ")";
    }

    public static class CommandContainerBuilder {
        private CommandHandler<?> executor;
        private boolean hidden;
        private ArrayList<String> selectivePermissions;
        private ArrayList<String> permissions;
        private String prefix;
        private String description;
        private boolean disabled;
        private String disablePlaceholder;
        private Function<@Nullable CommandSender, @NotNull String> disableCallback;
        private Class<?> executorType;

        CommandContainerBuilder() {
        }

        public CommandContainerBuilder executor(@NotNull CommandHandler<?> executor) {
            this.executor = executor;
            return this;
        }

        public CommandContainerBuilder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public CommandContainerBuilder selectivePermission(String selectivePermission) {
            if (this.selectivePermissions == null) {
                this.selectivePermissions = new ArrayList();
            }
            this.selectivePermissions.add(selectivePermission);
            return this;
        }

        public CommandContainerBuilder selectivePermissions(Collection<? extends String> selectivePermissions) {
            if (selectivePermissions == null) {
                throw new NullPointerException("selectivePermissions cannot be null");
            }
            if (this.selectivePermissions == null) {
                this.selectivePermissions = new ArrayList();
            }
            this.selectivePermissions.addAll(selectivePermissions);
            return this;
        }

        public CommandContainerBuilder clearSelectivePermissions() {
            if (this.selectivePermissions != null) {
                this.selectivePermissions.clear();
            }
            return this;
        }

        public CommandContainerBuilder permission(String permission) {
            if (this.permissions == null) {
                this.permissions = new ArrayList();
            }
            this.permissions.add(permission);
            return this;
        }

        public CommandContainerBuilder permissions(Collection<? extends String> permissions) {
            if (permissions == null) {
                throw new NullPointerException("permissions cannot be null");
            }
            if (this.permissions == null) {
                this.permissions = new ArrayList();
            }
            this.permissions.addAll(permissions);
            return this;
        }

        public CommandContainerBuilder clearPermissions() {
            if (this.permissions != null) {
                this.permissions.clear();
            }
            return this;
        }

        public CommandContainerBuilder prefix(@NotNull String prefix) {
            this.prefix = prefix;
            return this;
        }

        public CommandContainerBuilder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public CommandContainerBuilder disabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public CommandContainerBuilder disablePlaceholder(@Nullable String disablePlaceholder) {
            this.disablePlaceholder = disablePlaceholder;
            return this;
        }

        public CommandContainerBuilder disableCallback(@Nullable @Nullable Function<@Nullable CommandSender, @NotNull String> disableCallback) {
            this.disableCallback = disableCallback;
            return this;
        }

        public CommandContainerBuilder executorType(Class<?> executorType) {
            this.executorType = executorType;
            return this;
        }

        public CommandContainer build() {
            List<String> permissions;
            List<String> selectivePermissions;
            switch (this.selectivePermissions == null ? 0 : this.selectivePermissions.size()) {
                case 0: {
                    selectivePermissions = Collections.emptyList();
                    break;
                }
                case 1: {
                    selectivePermissions = Collections.singletonList(this.selectivePermissions.get(0));
                    break;
                }
                default: {
                    selectivePermissions = Collections.unmodifiableList(new ArrayList<String>(this.selectivePermissions));
                }
            }
            switch (this.permissions == null ? 0 : this.permissions.size()) {
                case 0: {
                    permissions = Collections.emptyList();
                    break;
                }
                case 1: {
                    permissions = Collections.singletonList(this.permissions.get(0));
                    break;
                }
                default: {
                    permissions = Collections.unmodifiableList(new ArrayList<String>(this.permissions));
                }
            }
            return new CommandContainer(this.executor, this.hidden, selectivePermissions, permissions, this.prefix, this.description, this.disabled, this.disablePlaceholder, this.disableCallback, this.executorType);
        }

        public String toString() {
            return "CommandContainer.CommandContainerBuilder(executor=" + this.executor + ", hidden=" + this.hidden + ", selectivePermissions=" + this.selectivePermissions + ", permissions=" + this.permissions + ", prefix=" + this.prefix + ", description=" + this.description + ", disabled=" + this.disabled + ", disablePlaceholder=" + this.disablePlaceholder + ", disableCallback=" + this.disableCallback + ", executorType=" + this.executorType + ")";
        }
    }
}

