/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.util.MsgUtil;

public class SubCommand_Reset
implements CommandHandler<CommandSender> {
    private final QuickShop plugin;
    private final List<String> tabCompleteList = Collections.unmodifiableList(Arrays.asList("lang", "config", "messages"));

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        if (cmdArg.length < 1) {
            MsgUtil.sendMessage(sender, "command.no-type-given", new String[0]);
            return;
        }
        switch (cmdArg[0]) {
            case "lang": {
                File cache = new File(this.plugin.getDataFolder(), "cache");
                File item = new File(this.plugin.getDataFolder(), "itemi18n.yml");
                File ench = new File(this.plugin.getDataFolder(), "enchi18n.yml");
                File potion = new File(this.plugin.getDataFolder(), "potioni18n.yml");
                cache.delete();
                item.delete();
                ench.delete();
                potion.delete();
                MsgUtil.loadGameLanguage(Objects.requireNonNull(this.plugin.getConfig().getString("game-language", "default")));
                MsgUtil.loadItemi18n();
                MsgUtil.loadEnchi18n();
                MsgUtil.loadPotioni18n();
                MsgUtil.sendMessage(sender, "complete", new String[0]);
                break;
            }
            case "config": {
                File config = new File(this.plugin.getDataFolder(), "config.yml");
                config.delete();
                this.plugin.saveDefaultConfig();
                this.plugin.reloadConfig();
                this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
                this.plugin.getServer().getPluginManager().enablePlugin((Plugin)this.plugin);
                MsgUtil.sendMessage(sender, "complete", new String[0]);
                break;
            }
            case "messages": {
                File msgs = new File(this.plugin.getDataFolder(), "messages.json");
                msgs.delete();
                MsgUtil.loadI18nFile();
                MsgUtil.sendMessage(sender, "complete", new String[0]);
                break;
            }
            default: {
                MsgUtil.sendMessage(sender, "command.wrong-args", new String[0]);
                break;
            }
        }
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        return this.tabCompleteList;
    }

    public SubCommand_Reset(QuickShop plugin) {
        this.plugin = plugin;
    }
}

