/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BlockIterator;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.shop.Info;
import org.maxgamer.quickshop.shop.ShopAction;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class SubCommand_SuperCreate
implements CommandHandler<Player> {
    private final QuickShop plugin;

    @Override
    public void onCommand(@NotNull Player sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        ItemStack item = sender.getInventory().getItemInMainHand();
        if (item.getType() == Material.AIR) {
            MsgUtil.sendMessage((CommandSender)sender, "no-anythings-in-your-hand", new String[0]);
            return;
        }
        BlockIterator bIt = new BlockIterator((LivingEntity)sender, 10);
        while (bIt.hasNext()) {
            Block b = bIt.next();
            if (!Util.canBeShop(b)) continue;
            if (cmdArg.length >= 1) {
                this.plugin.getShopManager().handleChat(sender, cmdArg[0], true);
                return;
            }
            Info info = new Info(b.getLocation(), ShopAction.CREATE, sender.getInventory().getItemInMainHand(), b.getRelative(sender.getFacing().getOppositeFace()));
            this.plugin.getShopManager().getActions().put(sender.getUniqueId(), info);
            MsgUtil.sendMessage((CommandSender)sender, "how-much-to-trade-for", Util.getItemStackName(item), Integer.toString(this.plugin.isAllowStack() && QuickShop.getPermissionManager().hasPermission((CommandSender)sender, "quickshop.create.stacks") ? item.getAmount() : 1));
            return;
        }
        MsgUtil.sendMessage((CommandSender)sender, "not-looking-at-shop", new String[0]);
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull Player sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        return cmdArg.length == 1 ? Collections.singletonList(MsgUtil.getMessage("tabcomplete.amount", (CommandSender)sender, new String[0])) : Collections.emptyList();
    }

    public SubCommand_SuperCreate(QuickShop plugin) {
        this.plugin = plugin;
    }
}

