/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.database;

import java.io.File;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.database.AbstractDatabaseCore;
import org.maxgamer.quickshop.database.DatabaseConnection;

public class SQLiteCore
extends AbstractDatabaseCore {
    private final File dbFile;
    @NotNull
    private final QuickShop plugin;
    private DatabaseConnection connection;

    public SQLiteCore(@NotNull QuickShop plugin, @NotNull File dbFile) {
        this.plugin = plugin;
        this.dbFile = dbFile;
    }

    @Override
    synchronized void close() {
        if (!this.connection.isUsing()) {
            if (this.connection != null && !this.connection.isValid()) {
                this.connection.close();
            }
        } else {
            this.waitForConnection();
            this.close();
        }
    }

    @Override
    protected synchronized DatabaseConnection getConnection0() {
        if (this.connection == null) {
            this.connection = this.genConnection();
            return this.connection;
        }
        if (!this.connection.isUsing()) {
            if (this.connection.isValid()) {
                return this.connection;
            }
            this.connection.close();
            this.connection = this.genConnection();
            return this.connection;
        }
        this.waitForConnection();
        return this.getConnection0();
    }

    @Nullable
    private synchronized DatabaseConnection genConnection() {
        if (this.dbFile.exists()) {
            try {
                Class.forName("org.sqlite.JDBC");
                this.connection = new DatabaseConnection(this, DriverManager.getConnection("jdbc:sqlite:" + this.dbFile));
                return this.connection;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Sqlite driver is not found", e);
            }
            catch (SQLException e) {
                throw new IllegalStateException("Start sqlite database connection failed", e);
            }
        }
        try {
            this.dbFile.createNewFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Sqlite database file create failed", e);
        }
        return this.genConnection();
    }

    @Override
    @NotNull
    public String getName() {
        return "BuiltIn-SQLite";
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }
}

