/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.file.newest.json.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.file.newest.json.SerializableSet;
import org.yaml.snakeyaml.error.YAMLException;

public class SerializationHelper {
    private static final Logger LOG = Logger.getLogger(SerializationHelper.class.getName());

    public static Object serialize(@NotNull Object value) {
        if (value instanceof Object[]) {
            value = new ArrayList<Object>(Arrays.asList((Object[])value));
        }
        if (value instanceof Set && !(value instanceof SerializableSet)) {
            value = new SerializableSet((Set)value);
        }
        if (value instanceof ConfigurationSection) {
            return SerializationHelper.buildMap(((ConfigurationSection)value).getValues(false));
        }
        if (value instanceof Map) {
            return SerializationHelper.buildMap((Map)((Object)value));
        }
        if (value instanceof List) {
            return SerializationHelper.buildList((List)value);
        }
        if (value instanceof ConfigurationSerializable) {
            ConfigurationSerializable serializable = (ConfigurationSerializable)value;
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            values.put("==", ConfigurationSerialization.getAlias(serializable.getClass()));
            values.putAll(serializable.serialize());
            return SerializationHelper.buildMap(values);
        }
        return value;
    }

    @NotNull
    private static Map<String, Object> buildMap(@NotNull Map<?, ?> map) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(map.size());
        try {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                result.put(entry.getKey().toString(), SerializationHelper.serialize(entry.getValue()));
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error while building configuration map.", e);
        }
        return result;
    }

    private static List<Object> buildList(@NotNull Collection<?> collection) {
        ArrayList<Object> result = new ArrayList<Object>(collection.size());
        try {
            for (Object o : collection) {
                result.add(SerializationHelper.serialize(o));
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error while building configuration list.", e);
        }
        return result;
    }

    public static Object deserialize(@NotNull Map<?, ?> input) {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>(input.size());
        for (Map.Entry<?, ?> e : input.entrySet()) {
            if (e.getValue() instanceof Map) {
                output.put(e.getKey().toString(), SerializationHelper.deserialize((Map)e.getValue()));
                continue;
            }
            if (e.getValue() instanceof List) {
                output.put(e.getKey().toString(), SerializationHelper.deserialize((List)e.getValue()));
                continue;
            }
            output.put(e.getKey().toString(), e.getValue());
        }
        if (output.containsKey("==")) {
            try {
                return ConfigurationSerialization.deserializeObject(output);
            }
            catch (IllegalArgumentException ex) {
                throw new YAMLException("Could not deserialize object", (Throwable)ex);
            }
        }
        return output;
    }

    private static Object deserialize(@NotNull List<?> input) {
        ArrayList<Object> output = new ArrayList<Object>(input.size());
        for (Object o : input) {
            if (o instanceof Map) {
                output.add(SerializationHelper.deserialize((Map)o));
                continue;
            }
            if (o instanceof List) {
                output.add(SerializationHelper.deserialize((List)o));
                continue;
            }
            output.add(o);
        }
        return output;
    }
}

