/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.integration;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.integration.IntegrateStage;
import org.maxgamer.quickshop.integration.IntegratedPlugin;
import org.maxgamer.quickshop.integration.IntegrationStage;
import org.maxgamer.quickshop.integration.InvalidIntegratedPluginClassException;
import org.maxgamer.quickshop.integration.factionsuuid.FactionsUUIDIntegration;
import org.maxgamer.quickshop.integration.griefprevention.GriefPreventionIntegration;
import org.maxgamer.quickshop.integration.lands.LandsIntegration;
import org.maxgamer.quickshop.integration.plotsquared.PlotSquaredIntegrationProxy;
import org.maxgamer.quickshop.integration.residence.ResidenceIntegration;
import org.maxgamer.quickshop.integration.superiorskyblock.SuperiorSkyblock2Integration;
import org.maxgamer.quickshop.integration.towny.TownyIntegration;
import org.maxgamer.quickshop.integration.worldguard.WorldGuardIntegration;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.holder.QuickShopInstanceHolder;
import org.maxgamer.quickshop.util.holder.Result;

public class IntegrationHelper
extends QuickShopInstanceHolder {
    private static final Map<String, Class<? extends IntegratedPlugin>> integratedPluginNameMap = new HashMap<String, Class<? extends IntegratedPlugin>>(7);
    private final Map<String, IntegratedPlugin> integrations = new HashMap<String, IntegratedPlugin>(7);

    public IntegrationHelper(QuickShop plugin) {
        super(plugin);
    }

    public Map<String, IntegratedPlugin> getIntegrationMap() {
        return Collections.unmodifiableMap(this.integrations);
    }

    public List<IntegratedPlugin> getIntegrations() {
        return Collections.unmodifiableList(new ArrayList<IntegratedPlugin>(this.integrations.values()));
    }

    public void searchAndRegisterPlugins() {
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        for (Map.Entry<String, Class<? extends IntegratedPlugin>> entry : integratedPluginNameMap.entrySet()) {
            String pluginName = entry.getKey();
            if (!pluginManager.isPluginEnabled(pluginName) || !this.plugin.getConfig().getBoolean("integration." + pluginName.toLowerCase() + ".enable")) continue;
            this.register(entry.getValue());
        }
    }

    public void register(@NotNull IntegratedPlugin integratedPlugin) {
        if (!this.isIntegrationClass(integratedPlugin.getClass())) {
            throw new InvalidIntegratedPluginClassException("Invaild Integration module: " + integratedPlugin.getName());
        }
        if (!this.integrations.containsKey(integratedPlugin.getName())) {
            this.plugin.getLogger().info("Registering " + integratedPlugin.getName() + " integration");
            Util.debugLog("Registering " + integratedPlugin.getName() + " integration");
            this.integrations.put(integratedPlugin.getName(), integratedPlugin);
        }
    }

    public void register(@NotNull Class<? extends IntegratedPlugin> integratedPluginClass) {
        IntegratedPlugin integratedPlugin;
        try {
            integratedPlugin = integratedPluginClass.getConstructor(((Object)((Object)this.plugin)).getClass()).newInstance(new Object[]{this.plugin});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
            throw new InvalidIntegratedPluginClassException("Invalid Integration module class: " + integratedPluginClass, e);
        }
        this.register(integratedPlugin);
    }

    public void register(@NotNull String integratedPluginName) {
        Class<? extends IntegratedPlugin> integratedPluginClass = integratedPluginNameMap.get(integratedPluginName);
        if (integratedPluginClass == null) {
            throw new InvalidIntegratedPluginClassException("Invalid Integration module name: " + integratedPluginName);
        }
        this.register(integratedPluginClass);
    }

    private boolean isIntegrationClass(@NotNull Class<?> clazz) {
        return clazz.getDeclaredAnnotation(IntegrationStage.class) != null;
    }

    public void unregister(@NotNull String integratedPluginName) {
        IntegratedPlugin integratedPlugin = this.integrations.get(integratedPluginName);
        if (integratedPlugin != null) {
            this.unregister(integratedPlugin);
        }
    }

    public void unregisterAll() {
        for (IntegratedPlugin integratedPlugin : new ArrayList<IntegratedPlugin>(this.integrations.values())) {
            this.unregister(integratedPlugin);
        }
    }

    public void unregister(@NotNull IntegratedPlugin integratedPlugin) {
        if (!this.isIntegrationClass(integratedPlugin.getClass())) {
            throw new InvalidIntegratedPluginClassException();
        }
        this.plugin.getLogger().info("Unregistering " + integratedPlugin.getName() + " integration");
        Util.debugLog("Unregistering " + integratedPlugin.getName() + " integration");
        this.integrations.remove(integratedPlugin.getName());
    }

    public void callIntegrationsLoad(@NotNull IntegrateStage stage) {
        this.integrations.values().forEach(integratedPlugin -> {
            if (integratedPlugin.getClass().getDeclaredAnnotation(IntegrationStage.class).loadStage() == stage) {
                Util.debugLog("Calling for load " + integratedPlugin.getName());
                integratedPlugin.load();
            } else {
                Util.debugLog("Ignored calling because " + integratedPlugin.getName() + " stage is " + (Object)((Object)integratedPlugin.getClass().getDeclaredAnnotation(IntegrationStage.class).loadStage()));
            }
        });
    }

    public void callIntegrationsUnload(@NotNull IntegrateStage stage) {
        this.integrations.values().forEach(integratedPlugin -> {
            if (integratedPlugin.getClass().getDeclaredAnnotation(IntegrationStage.class).unloadStage() == stage) {
                Util.debugLog("Calling for unload " + integratedPlugin.getName());
                integratedPlugin.unload();
            } else {
                Util.debugLog("Ignored calling because " + integratedPlugin.getName() + " stage is " + (Object)((Object)integratedPlugin.getClass().getDeclaredAnnotation(IntegrationStage.class).loadStage()));
            }
        });
    }

    public Result callIntegrationsCanCreate(@NotNull Player player, @NotNull Location location) {
        for (IntegratedPlugin plugin : this.integrations.values()) {
            if (plugin.canCreateShopHere(player, location)) continue;
            Util.debugLog("Cancelled by " + plugin.getName());
            return new Result(plugin.getName());
        }
        return Result.SUCCESS;
    }

    public Result callIntegrationsCanTrade(@NotNull Player player, @NotNull Location location) {
        for (IntegratedPlugin plugin : this.integrations.values()) {
            if (plugin.canTradeShopHere(player, location)) continue;
            Util.debugLog("Cancelled by " + plugin.getName());
            return new Result(plugin.getName());
        }
        return Result.SUCCESS;
    }

    public static Map<String, Class<? extends IntegratedPlugin>> getIntegratedPluginNameMap() {
        return integratedPluginNameMap;
    }

    static {
        integratedPluginNameMap.put("Factions", FactionsUUIDIntegration.class);
        integratedPluginNameMap.put("GriefPrevention", GriefPreventionIntegration.class);
        integratedPluginNameMap.put("Lands", LandsIntegration.class);
        integratedPluginNameMap.put("PlotSquared", PlotSquaredIntegrationProxy.class);
        integratedPluginNameMap.put("Residence", ResidenceIntegration.class);
        integratedPluginNameMap.put("Towny", TownyIntegration.class);
        integratedPluginNameMap.put("WorldGuard", WorldGuardIntegration.class);
        integratedPluginNameMap.put("SuperiorSkyblock", SuperiorSkyblock2Integration.class);
    }
}

