/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.integration.griefprevention;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.events.TrustChangedEvent;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.integration.IntegrateStage;
import org.maxgamer.quickshop.integration.IntegrationStage;
import org.maxgamer.quickshop.integration.QSIntegratedPlugin;
import org.maxgamer.quickshop.shop.Shop;

@IntegrationStage(loadStage=IntegrateStage.onEnableAfter)
public class GriefPreventionIntegration
extends QSIntegratedPlugin {
    final GriefPrevention griefPrevention = GriefPrevention.instance;
    private final List<Flag> createLimits = new ArrayList<Flag>(3);
    private final List<Flag> tradeLimits = new ArrayList<Flag>(3);
    private final boolean whiteList;
    private final boolean deleteOnUntrusted;

    public GriefPreventionIntegration(QuickShop plugin) {
        super(plugin);
        FileConfiguration configurationSection = plugin.getConfig();
        this.whiteList = configurationSection.getBoolean("integration.griefprevention.whitelist-mode");
        this.deleteOnUntrusted = configurationSection.getBoolean("integration.griefprevention.delete-on-untrusted");
        this.createLimits.addAll(this.toFlags(configurationSection.getStringList("integration.griefprevention.create")));
        this.tradeLimits.addAll(this.toFlags(configurationSection.getStringList("integration.griefprevention.trade")));
    }

    private List<Flag> toFlags(List<String> flags) {
        ArrayList<Flag> result = new ArrayList<Flag>(3);
        for (String flagStr : flags) {
            Flag flag = Flag.getFlag(flagStr);
            if (flag == null) continue;
            result.add(flag);
        }
        return result;
    }

    @Override
    @NotNull
    public String getName() {
        return "GriefPrevention";
    }

    @Override
    public boolean canCreateShopHere(@NotNull Player player, @NotNull Location location) {
        return this.checkPermission(player, location, this.createLimits);
    }

    @Override
    public boolean canTradeShopHere(@NotNull Player player, @NotNull Location location) {
        return this.checkPermission(player, location, this.tradeLimits);
    }

    private boolean checkPermission(@NotNull Player player, @NotNull Location location, List<Flag> limits) {
        if (!this.griefPrevention.claimsEnabledForWorld(location.getWorld())) {
            return true;
        }
        Claim claim = this.griefPrevention.dataStore.getClaimAt(location, false, this.griefPrevention.dataStore.getPlayerData((UUID)player.getUniqueId()).lastClaim);
        if (claim == null) {
            return !this.whiteList;
        }
        for (Flag flag : limits) {
            if (flag.check(claim, player)) continue;
            return false;
        }
        return true;
    }

    @EventHandler(ignoreCancelled=true)
    public void onUntrusted(TrustChangedEvent event) {
        if (!this.deleteOnUntrusted) {
            return;
        }
        if (event.isGiven()) {
            return;
        }
        for (Claim claim : event.getClaims()) {
            for (Chunk chunk : claim.getChunks()) {
                Map<Location, Shop> shops = this.plugin.getShopManager().getShops(chunk);
                if (shops == null) continue;
                for (Shop shop : shops.values()) {
                    if (shop.getOwner().equals(claim.getOwnerID())) {
                        return;
                    }
                    if (event.getIdentifier().equals(shop.getOwner().toString())) {
                        this.plugin.log("[SHOP DELETE] GP Integration: Single delete #" + event.getIdentifier());
                        shop.delete();
                        return;
                    }
                    if (event.getIdentifier().contains(shop.getOwner().toString())) {
                        this.plugin.log("[SHOP DELETE] GP Integration: Group delete #" + event.getIdentifier());
                        shop.delete();
                        return;
                    }
                    if (!"all".equals(event.getIdentifier()) && !"public".equals(event.getIdentifier())) continue;
                    this.plugin.log("[SHOP DELETE] GP Integration: All/Public delete #" + event.getIdentifier());
                    shop.delete();
                    return;
                }
            }
        }
    }

    @Override
    public void load() {
        this.registerListener();
    }

    @Override
    public void unload() {
        this.unregisterListener();
    }

    static enum Flag {
        BUILD{

            @Override
            boolean check(Claim claim, Player player) {
                return claim.allowBuild(player, Material.CHEST) == null;
            }
        }
        ,
        CONTAINER_ACCESS{

            @Override
            boolean check(Claim claim, Player player) {
                return claim.allowContainers(player) == null;
            }
        }
        ,
        ACCESS{

            @Override
            boolean check(Claim claim, Player player) {
                return claim.allowAccess(player) == null;
            }
        };


        public static Flag getFlag(String flag) {
            flag = flag.toUpperCase();
            for (Flag value : Flag.values()) {
                if (!value.name().equals(flag)) continue;
                return value;
            }
            return null;
        }

        abstract boolean check(Claim var1, Player var2);
    }
}

