/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.listener;

import java.util.Map;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.listener.QSListener;
import org.maxgamer.quickshop.shop.Shop;

public class ChunkListener
extends QSListener {
    public ChunkListener(QuickShop plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkLoad(ChunkLoadEvent e) {
        if (e.isNewChunk()) {
            return;
        }
        Map<Location, Shop> inChunk = this.plugin.getShopManager().getShops(e.getChunk());
        if (inChunk == null) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            for (Shop shop : inChunk.values()) {
                shop.onLoad();
            }
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkUnload(ChunkUnloadEvent e) {
        Map<Location, Shop> inChunk = this.plugin.getShopManager().getShops(e.getChunk());
        if (inChunk == null) {
            return;
        }
        for (Shop shop : inChunk.values()) {
            if (!shop.isLoaded()) continue;
            shop.onUnload();
        }
    }
}

