/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.listener;

import java.util.Set;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.integration.IntegratedPlugin;
import org.maxgamer.quickshop.integration.IntegrationHelper;
import org.maxgamer.quickshop.listener.QSListener;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.compatibility.CompatibilityManager;

public class PluginListener
extends QSListener {
    private static final Set<String> pluginCompatibilityModuleList = CompatibilityManager.getCompatibilityModuleNameMap().keySet();
    private static final Set<String> pluginIntegrationList = IntegrationHelper.getIntegratedPluginNameMap().keySet();
    private final IntegrationHelper integrationHelper;
    private final CompatibilityManager compatibilityManager;

    public PluginListener(QuickShop plugin) {
        super(plugin);
        this.integrationHelper = this.plugin.getIntegrationHelper();
        this.compatibilityManager = this.plugin.getCompatibilityTool();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPluginDisabled(PluginDisableEvent event) {
        IntegratedPlugin integratedPlugin;
        String pluginName = event.getPlugin().getName();
        if (pluginIntegrationList.contains(pluginName) && this.plugin.getConfig().getBoolean("integration." + pluginName.toLowerCase() + ".enable") && (integratedPlugin = this.integrationHelper.getIntegrationMap().get(pluginName)) != null) {
            Util.debugLog("[Hot Load] Calling for unloading " + integratedPlugin.getName());
            integratedPlugin.unload();
            this.integrationHelper.unregister(integratedPlugin);
        }
        if (pluginCompatibilityModuleList.contains(pluginName)) {
            this.compatibilityManager.unregister(pluginName);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPluginEnabled(PluginEnableEvent event) {
        String pluginName = event.getPlugin().getName();
        if (pluginIntegrationList.contains(pluginName) && this.plugin.getConfig().getBoolean("integration." + pluginName.toLowerCase() + ".enable")) {
            this.integrationHelper.register(pluginName);
            IntegratedPlugin integratedPlugin = this.integrationHelper.getIntegrationMap().get(pluginName);
            if (integratedPlugin != null) {
                Util.debugLog("[Hot Load] Calling for loading " + integratedPlugin.getName());
                integratedPlugin.load();
            }
        }
        if (pluginCompatibilityModuleList.contains(pluginName)) {
            this.compatibilityManager.register(pluginName);
        }
    }
}

