/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.listener;

import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.SpongeAbsorbEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.Cache;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.listener.ProtectionListenerBase;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class ShopProtectionListener
extends ProtectionListenerBase {
    private final boolean useEnhanceProtection;
    private final boolean sendProtectionAlert;

    public ShopProtectionListener(@NotNull QuickShop plugin, @Nullable Cache cache) {
        super(plugin, cache);
        this.sendProtectionAlert = plugin.getConfig().getBoolean("send-shop-protection-alert", false);
        this.useEnhanceProtection = plugin.getConfig().getBoolean("shop.enchance-shop-protect");
        this.scanAndFixPaperListener();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldLoad(WorldLoadEvent event) {
        this.scanAndFixPaperListener();
    }

    public void scanAndFixPaperListener() {
        if (!this.plugin.getConfig().getBoolean("protect.hopper")) {
            return;
        }
        if (!Util.isClassAvailable("com.destroystokyo.paper.PaperWorldConfig")) {
            return;
        }
        Util.debugLog("QuickShop is scanning all worlds settings about disableHopperMoveEvents disabled worlds");
        this.plugin.getServer().getWorlds().forEach(world -> {
            if (this.plugin.getShopManager().getShopsInWorld((World)world).isEmpty()) {
                return;
            }
            try {
                Field worldServerF = world.getClass().getDeclaredField("world");
                worldServerF.setAccessible(true);
                Object worldServer = worldServerF.get(world);
                Object paperWorldConfig = worldServer.getClass().getSuperclass().getDeclaredField("paperConfig").get(worldServer);
                boolean disableHopperMoveEvents = paperWorldConfig.getClass().getDeclaredField("disableHopperMoveEvents").getBoolean(paperWorldConfig);
                if (disableHopperMoveEvents) {
                    this.plugin.getLogger().warning("World " + world.getName() + " have shops and Hopper protection is enabled. But we detected \"disableHopperMoveEvents\" options in \"paper.yml\" is activated, so QuickShop already automatic disabled it.");
                    this.plugin.getLogger().warning("If you still want keep enable disableHopperMoveEvents enables in this world, please disable Hopper protection or make sure no shops in this world.");
                    paperWorldConfig.getClass().getDeclaredField("disableHopperMoveEvents").setBoolean(paperWorldConfig, false);
                    File serverRoot = this.plugin.getDataFolder().getParentFile().getParentFile();
                    File paperConfigYaml = new File(serverRoot, "paper.yml");
                    if (paperConfigYaml.exists()) {
                        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)paperConfigYaml);
                        ConfigurationSection worldsSection = Objects.requireNonNull(yamlConfiguration.getConfigurationSection("world-settings"));
                        ConfigurationSection worldSection = Objects.requireNonNull(worldsSection).getConfigurationSection(world.getName()) == null ? worldsSection.getConfigurationSection("default") : worldsSection.getConfigurationSection(world.getName());
                        Objects.requireNonNull(worldSection).set("hopper.disable-move-event", (Object)false);
                        Objects.requireNonNull(worldSection).set("hopper.disable-move-event-quickshop-tips", (Object)"QuickShop automatic disabled this due it will allow other players steal items from shop. This notice only shown when have shops in current world and hopper protection is on and also disable-move-event turned on.");
                        yamlConfiguration.save(paperConfigYaml);
                    }
                }
            }
            catch (Exception ex) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to automatic disable disable-move-event for world [" + world.getName() + "], please disable it by yourself or player can steal items from shops.", ex);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent e) {
        int a = e.blockList().size();
        for (int i = 0; i < a; ++i) {
            Block b = (Block)e.blockList().get(i);
            Shop shop = this.getShopNature(b.getLocation(), true);
            if (shop == null) {
                shop = this.getShopNextTo(b.getLocation());
            }
            if (shop == null) continue;
            if (this.plugin.getConfig().getBoolean("protect.explode")) {
                e.setCancelled(true);
                continue;
            }
            this.plugin.log("Deleting shop " + shop + " request by block break (explode).");
            shop.delete();
        }
    }

    @Nullable
    private Shop getShopNextTo(@NotNull Location loc) {
        Block b = Util.getAttached(loc.getBlock());
        if (b == null) {
            return null;
        }
        return this.getShopNature(b.getLocation(), false);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent e) {
        if (!this.useEnhanceProtection) {
            return;
        }
        Shop shop = this.getShopNature(e.getToBlock().getLocation(), true);
        if (shop == null) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        if (!this.useEnhanceProtection) {
            return;
        }
        Shop shop = this.getShopRedstone(event.getBlock().getLocation(), true);
        if (shop == null) {
            return;
        }
        event.setNewCurrent(event.getOldCurrent());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent e) {
        if (!this.useEnhanceProtection) {
            return;
        }
        Block newBlock = e.getNewState().getBlock();
        Shop thisBlockShop = this.getShopNature(newBlock.getLocation(), true);
        if (thisBlockShop == null) {
            return;
        }
        Shop underBlockShop = this.getShopNature(newBlock.getRelative(BlockFace.DOWN).getLocation(), true);
        if (underBlockShop == null) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExplode(EntityExplodeEvent e) {
        int a = e.blockList().size();
        for (int i = 0; i < a; ++i) {
            Block b = (Block)e.blockList().get(i);
            Shop shop = this.getShopNature(b.getLocation(), true);
            if (shop == null) continue;
            if (this.plugin.getConfig().getBoolean("protect.explode")) {
                e.setCancelled(true);
                continue;
            }
            this.plugin.log("Deleting shop " + shop + " request by block break (explode).");
            shop.delete();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onInventoryMove(InventoryMoveItemEvent event) {
        if (!this.plugin.getConfig().getBoolean("protect.hopper")) {
            return;
        }
        Location loc = event.getSource().getLocation();
        if (loc == null) {
            return;
        }
        Shop shop = this.getShopRedstone(loc, true);
        if (shop == null) {
            return;
        }
        event.setCancelled(true);
        Location location = event.getInitiator().getLocation();
        if (location == null) {
            return;
        }
        InventoryHolder holder = event.getInitiator().getHolder();
        if (holder instanceof Entity) {
            ((Entity)holder).remove();
        } else if (holder instanceof Block) {
            location.getBlock().breakNaturally();
        } else {
            Util.debugLog("Unknown location = " + loc);
        }
        if (this.sendProtectionAlert) {
            MsgUtil.sendGlobalAlert("[DisplayGuard] Defend a item steal action at" + location);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onMobChangeBlock(EntityChangeBlockEvent event) {
        if (!this.useEnhanceProtection) {
            return;
        }
        Shop shop = this.getShopNature(event.getBlock().getLocation(), true);
        if (shop == null) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("protect.entity")) {
            event.setCancelled(true);
            return;
        }
        this.plugin.log("Deleting shop " + shop + " request by mob changing.");
        shop.delete();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        if (!this.useEnhanceProtection) {
            return;
        }
        for (BlockState blockstate : event.getBlocks()) {
            Shop shop = this.getShopNature(blockstate.getLocation(), true);
            if (shop == null) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSponging(SpongeAbsorbEvent event) {
        if (!this.useEnhanceProtection) {
            return;
        }
        List blocks = event.getBlocks();
        for (BlockState block : blocks) {
            if (this.getShopNature(block.getLocation(), true) == null) continue;
            event.setCancelled(true);
        }
    }
}

