/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.permission;

import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.permission.BukkitPermsProvider;
import org.maxgamer.quickshop.permission.PermissionInformationContainer;
import org.maxgamer.quickshop.permission.PermissionProvider;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class PermissionManager {
    private final QuickShop plugin;
    private final PermissionProvider provider;

    public PermissionManager(QuickShop plugin) {
        this.plugin = plugin;
        this.provider = new BukkitPermsProvider();
        plugin.getLogger().info("Selected permission provider: " + this.provider.getName());
    }

    public boolean hasPermission(@NotNull CommandSender sender, @NotNull String permission) {
        try {
            boolean result = this.provider.hasPermission(sender, permission);
            if (Util.isDevMode()) {
                try {
                    PermissionInformationContainer container = this.provider.getDebugInfo(sender, permission);
                    Util.debugLog("Node: [" + container.getPermission() + "]; Result: [" + result + "]; Sender: [" + container.getSender().getName() + "]");
                }
                catch (Exception th) {
                    Util.debugLog("Exception threw when getting debug messages.");
                    MsgUtil.debugStackTrace(th.getStackTrace());
                }
            }
            return result;
        }
        catch (Exception th) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to processing permission response, This might or not a bug, we not sure, but you can report to both permission provider plugin author or QuickShop devs about this error", th);
            return false;
        }
    }

    public QuickShop getPlugin() {
        return this.plugin;
    }

    public PermissionProvider getProvider() {
        return this.provider;
    }
}

