/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shade.com.rollbar.notifier;

import java.util.Map;
import org.maxgamer.quickshop.shade.com.rollbar.api.payload.Payload;
import org.maxgamer.quickshop.shade.com.rollbar.api.payload.data.Level;
import org.maxgamer.quickshop.shade.com.rollbar.notifier.RollbarBase;
import org.maxgamer.quickshop.shade.com.rollbar.notifier.config.Config;
import org.maxgamer.quickshop.shade.com.rollbar.notifier.config.ConfigBuilder;
import org.maxgamer.quickshop.shade.com.rollbar.notifier.config.ConfigProvider;
import org.maxgamer.quickshop.shade.com.rollbar.notifier.uncaughtexception.RollbarUncaughtExceptionHandler;
import org.maxgamer.quickshop.shade.com.rollbar.notifier.util.BodyFactory;
import org.maxgamer.quickshop.shade.com.rollbar.notifier.util.ObjectsUtils;
import org.maxgamer.quickshop.shade.com.rollbar.notifier.wrapper.ThrowableWrapper;
import org.maxgamer.quickshop.shade.org.slf4j.slf4j.Logger;
import org.maxgamer.quickshop.shade.org.slf4j.slf4j.LoggerFactory;

public class Rollbar
extends RollbarBase<Void, Config> {
    private static Logger LOGGER = LoggerFactory.getLogger(Rollbar.class);
    private static final Void VOID = null;
    private static volatile Rollbar notifier;

    public Rollbar(Config config) {
        this(config, new BodyFactory());
    }

    Rollbar(Config config, BodyFactory bodyFactory) {
        super(config, bodyFactory, VOID);
        if (config.handleUncaughtErrors()) {
            this.handleUncaughtErrors();
        }
        this.processAppPackages(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Rollbar init(Config config) {
        if (notifier != null) return notifier;
        Class<Rollbar> clazz = Rollbar.class;
        synchronized (Rollbar.class) {
            if (notifier != null) return notifier;
            notifier = new Rollbar(config);
            LOGGER.debug("Rollbar managed notifier created.");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return notifier;
        }
    }

    public void handleUncaughtErrors() {
        this.handleUncaughtErrors(Thread.currentThread());
    }

    public void handleUncaughtErrors(Thread thread) {
        ObjectsUtils.requireNonNull(thread, "thread");
        LOGGER.debug("Handling uncaught errors for thread: {}.", (Object)thread);
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        thread.setUncaughtExceptionHandler(new RollbarUncaughtExceptionHandler(this, uncaughtExceptionHandler));
    }

    @Override
    public void configure(ConfigProvider configProvider) {
        ConfigBuilder builder;
        this.configReadLock.lock();
        try {
            builder = ConfigBuilder.withConfig((Config)this.config);
        }
        finally {
            this.configReadLock.unlock();
        }
        Config newConfig = configProvider.provide(builder);
        this.configure(newConfig);
    }

    @Override
    public void configure(Config config) {
        super.configure(config);
    }

    public Level level(Config config, Throwable error) {
        return super.level(config, error);
    }

    public Config config() {
        return (Config)this.config;
    }

    public void critical(Throwable error) {
        this.critical(error, null, null);
    }

    public void critical(Throwable error, String description) {
        this.critical(error, null, description);
    }

    public void critical(Throwable error, Map<String, Object> custom) {
        this.critical(error, custom, null);
    }

    public void critical(String message) {
        this.critical(null, null, message);
    }

    public void critical(String message, Map<String, Object> custom) {
        this.critical(null, custom, message);
    }

    public void critical(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, Level.CRITICAL);
    }

    public void error(Throwable error) {
        this.error(error, null, null);
    }

    public void error(Throwable error, String description) {
        this.error(error, null, description);
    }

    public void error(Throwable error, Map<String, Object> custom) {
        this.error(error, custom, null);
    }

    public void error(String message) {
        this.error(null, null, message);
    }

    public void error(String message, Map<String, Object> custom) {
        this.error(null, custom, message);
    }

    public void error(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, Level.ERROR);
    }

    public void warning(Throwable error) {
        this.warning(error, null, null);
    }

    public void warning(Throwable error, String description) {
        this.warning(error, null, description);
    }

    public void warning(Throwable error, Map<String, Object> custom) {
        this.warning(error, custom, null);
    }

    public void warning(String message) {
        this.warning(null, null, message);
    }

    public void warning(String message, Map<String, Object> custom) {
        this.warning(null, custom, message);
    }

    public void warning(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, Level.WARNING);
    }

    public void info(Throwable error) {
        this.info(error, null, null);
    }

    public void info(Throwable error, String description) {
        this.info(error, null, description);
    }

    public void info(Throwable error, Map<String, Object> custom) {
        this.info(error, custom, null);
    }

    public void info(String message) {
        this.info(null, null, message);
    }

    public void info(String message, Map<String, Object> custom) {
        this.info(null, custom, message);
    }

    public void info(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, Level.INFO);
    }

    public void debug(Throwable error) {
        this.debug(error, null, null);
    }

    public void debug(Throwable error, String description) {
        this.debug(error, null, description);
    }

    public void debug(Throwable error, Map<String, Object> custom) {
        this.debug(error, custom, null);
    }

    public void debug(String message) {
        this.debug(null, null, message);
    }

    public void debug(String message, Map<String, Object> custom) {
        this.debug(null, custom, message);
    }

    public void debug(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, Level.DEBUG);
    }

    public void log(Throwable error) {
        this.log(error, null, null, null);
    }

    public void log(Throwable error, String description) {
        this.log(error, null, description, null);
    }

    public void log(Throwable error, Map<String, Object> custom) {
        this.log(error, custom, null, null);
    }

    public void log(Throwable error, Map<String, Object> custom, Level level) {
        this.log(error, custom, null, level);
    }

    public void log(Throwable error, Level level) {
        this.log(error, null, null, level);
    }

    public void log(Throwable error, String description, Level level) {
        this.log(error, null, description, level);
    }

    public void log(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, null);
    }

    public void log(String message) {
        this.log(null, null, message, null);
    }

    public void log(String message, Map<String, Object> custom) {
        this.log(null, custom, message, null);
    }

    public void log(String message, Level level) {
        this.log(null, null, message, level);
    }

    public void log(String message, Map<String, Object> custom, Level level) {
        this.log(null, custom, message, level);
    }

    public void log(Throwable error, Map<String, Object> custom, String description, Level level) {
        this.log(error, custom, description, level, false);
    }

    public void log(Throwable error, Map<String, Object> custom, String description, Level level, boolean isUncaught) {
        this.log(this.wrapThrowable(error), custom, description, level, isUncaught);
    }

    public void log(ThrowableWrapper error, Map<String, Object> custom, String description, Level level, boolean isUncaught) {
        try {
            this.process(error, custom, description, level, isUncaught);
        }
        catch (Exception e) {
            LOGGER.error("Error while processing payload to send to Rollbar: {}", e);
        }
    }

    public void close(boolean wait) throws Exception {
        ((Config)this.config).sender().close(wait);
    }

    public void sendJsonPayload(String json) {
        try {
            this.configReadLock.lock();
            Config config = (Config)this.config;
            this.configReadLock.unlock();
            this.sendPayload(config, new Payload(json));
        }
        catch (Exception e) {
            LOGGER.error("Error while sending payload to Rollbar: {}", e);
        }
    }

    @Override
    protected Void sendPayload(Config config, Payload payload) {
        if (config.sender() != null) {
            LOGGER.debug("Sending payload.");
            config.sender().send(payload);
        }
        return VOID;
    }
}

