/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shade.me.lucko.helper.cooldown;

import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.maxgamer.quickshop.shade.me.lucko.helper.cooldown.Cooldown;
import org.maxgamer.quickshop.shade.me.lucko.helper.cooldown.CooldownMapImpl;

public interface CooldownMap<T> {
    @Nonnull
    public static <T> CooldownMap<T> create(@Nonnull Cooldown base) {
        Objects.requireNonNull(base, "base");
        return new CooldownMapImpl(base);
    }

    @Nonnull
    public Cooldown getBase();

    @Nonnull
    public Cooldown get(@Nonnull T var1);

    public void put(@Nonnull T var1, @Nonnull Cooldown var2);

    @Nonnull
    public Map<T, Cooldown> getAll();

    default public boolean test(@Nonnull T key) {
        return this.get(key).test();
    }

    default public boolean testSilently(@Nonnull T key) {
        return this.get(key).testSilently();
    }

    default public long elapsed(@Nonnull T key) {
        return this.get(key).elapsed();
    }

    default public void reset(@Nonnull T key) {
        this.get(key).reset();
    }

    default public long remainingMillis(@Nonnull T key) {
        return this.get(key).remainingMillis();
    }

    default public long remainingTime(@Nonnull T key, @Nonnull TimeUnit unit) {
        return this.get(key).remainingTime(unit);
    }

    @Nonnull
    default public OptionalLong getLastTested(@Nonnull T key) {
        return this.get(key).getLastTested();
    }

    default public void setLastTested(@Nonnull T key, long time) {
        this.get(key).setLastTested(time);
    }
}

