/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shop;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.shop.DisplayType;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.shop.ShopProtectionFlag;
import org.maxgamer.quickshop.util.JsonUtil;
import org.maxgamer.quickshop.util.Util;

public abstract class DisplayItem {
    protected static final QuickShop plugin = QuickShop.getInstance();
    private static final Gson gson = JsonUtil.getGson();
    private static final boolean displayAllowStacks = plugin.getConfig().getBoolean("shop.display-allow-stacks");
    private static volatile boolean isNotSupportVirtualItem = false;
    protected final ItemStack originalItemStack;
    protected final Shop shop;
    @Nullable
    protected ItemStack guardedIstack;
    private boolean pendingRemoval;

    protected DisplayItem(Shop shop) {
        this.shop = shop;
        this.originalItemStack = shop.getItem().clone();
        if (displayAllowStacks) {
            this.originalItemStack.setAmount(Math.min(this.originalItemStack.getAmount(), this.originalItemStack.getMaxStackSize()));
        } else {
            this.originalItemStack.setAmount(1);
        }
    }

    public static boolean checkIsGuardItemStack(@Nullable ItemStack itemStack) {
        if (!plugin.isDisplay()) {
            return false;
        }
        if (DisplayItem.getNowUsing() == DisplayType.VIRTUALITEM) {
            return false;
        }
        Util.ensureThread(false);
        if (itemStack == null) {
            return false;
        }
        if (!itemStack.hasItemMeta()) {
            return false;
        }
        ItemMeta iMeta = itemStack.getItemMeta();
        if (!iMeta.hasLore()) {
            return false;
        }
        String defaultMark = ShopProtectionFlag.getDefaultMark();
        for (String lore : iMeta.getLore()) {
            try {
                ShopProtectionFlag shopProtectionFlag;
                if (!lore.startsWith("{") || (shopProtectionFlag = (ShopProtectionFlag)gson.fromJson(lore, ShopProtectionFlag.class)) == null) continue;
                if (defaultMark.equals(ShopProtectionFlag.getMark())) {
                    return true;
                }
                if (shopProtectionFlag.getShopLocation() != null) {
                    return true;
                }
                if (shopProtectionFlag.getItemStackString() == null) continue;
                return true;
            }
            catch (JsonSyntaxException jsonSyntaxException) {
            }
        }
        return false;
    }

    public static boolean checkIsTargetShopDisplay(@NotNull ItemStack itemStack, @NotNull Shop shop) {
        if (!plugin.isDisplay()) {
            return false;
        }
        if (DisplayItem.getNowUsing() == DisplayType.VIRTUALITEM) {
            return false;
        }
        if (!itemStack.hasItemMeta()) {
            return false;
        }
        ItemMeta iMeta = itemStack.getItemMeta();
        if (!iMeta.hasLore()) {
            return false;
        }
        String defaultMark = ShopProtectionFlag.getDefaultMark();
        String shopLocation = shop.getLocation().toString();
        String attachedShopLocation = "null";
        if (shop.isRealDouble()) {
            attachedShopLocation = shop.getAttachedShop().getLocation().toString();
        }
        for (String lore : iMeta.getLore()) {
            try {
                ShopProtectionFlag shopProtectionFlag;
                if (!lore.startsWith("{") || (shopProtectionFlag = (ShopProtectionFlag)gson.fromJson(lore, ShopProtectionFlag.class)) == null || !ShopProtectionFlag.getMark().equals(defaultMark) || !shopProtectionFlag.getShopLocation().equals(shopLocation) && !shopProtectionFlag.getShopLocation().equals(attachedShopLocation)) continue;
                return true;
            }
            catch (JsonSyntaxException jsonSyntaxException) {
            }
        }
        return false;
    }

    @NotNull
    public static DisplayType getNowUsing() {
        DisplayType displayType = DisplayType.fromID(plugin.getConfig().getInt("shop.display-type"));
        if (isNotSupportVirtualItem && displayType == DisplayType.VIRTUALITEM) {
            plugin.getConfig().set("shop.display-type", (Object)0);
            plugin.saveConfig();
            plugin.getLogger().log(Level.WARNING, "Falling back to RealDisplayItem because VirtualDisplayItem is unsupported");
            return DisplayType.REALITEM;
        }
        return displayType;
    }

    @NotNull
    public static ItemStack createGuardItemStack(@NotNull ItemStack itemStack, @NotNull Shop shop) {
        ItemMeta iMeta = (itemStack = itemStack.clone()).getItemMeta();
        if (iMeta == null) {
            iMeta = plugin.getServer().getItemFactory().getItemMeta(itemStack.getType());
        }
        if (iMeta == null) {
            Util.debugLog("ItemStack " + itemStack + " cannot getting or creating ItemMeta, failed to create guarded ItemStack.");
            return itemStack;
        }
        if (plugin.getConfig().getBoolean("shop.display-item-use-name")) {
            if (iMeta.hasDisplayName()) {
                iMeta.setDisplayName(iMeta.getDisplayName());
            } else {
                iMeta.setDisplayName(Util.getItemStackName(itemStack));
            }
        } else {
            iMeta.setDisplayName(null);
        }
        ShopProtectionFlag shopProtectionFlag = DisplayItem.createShopProtectionFlag(itemStack, shop);
        String protectFlag = gson.toJson((Object)shopProtectionFlag);
        iMeta.setLore(Lists.newArrayList(protectFlag));
        itemStack.setItemMeta(iMeta);
        return itemStack;
    }

    @NotNull
    public static ShopProtectionFlag createShopProtectionFlag(@NotNull ItemStack itemStack, @NotNull Shop shop) {
        return new ShopProtectionFlag(shop.getLocation().toString(), Util.serialize(itemStack));
    }

    @NotNull
    public ItemStack getOriginalItemStack() {
        return this.originalItemStack;
    }

    public abstract boolean checkDisplayIsMoved();

    public abstract boolean checkDisplayNeedRegen();

    public abstract boolean checkIsShopEntity(Entity var1);

    public abstract void fixDisplayMoved();

    public abstract void fixDisplayNeedRegen();

    public abstract void remove();

    public abstract boolean removeDupe();

    public abstract void respawn();

    public abstract void safeGuard(@NotNull Entity var1);

    public abstract void spawn();

    public abstract Entity getDisplay();

    @Nullable
    public Location getDisplayLocation() {
        Util.ensureThread(false);
        if (this.shop.isRealDouble()) {
            if (this.shop.isLeftShop()) {
                Util.debugLog("Shop is left shop, so location is null.");
                return null;
            }
            double avgX = (this.shop.getLocation().getX() + this.shop.getAttachedShop().getLocation().getX()) / 2.0;
            double avgZ = (this.shop.getLocation().getZ() + this.shop.getAttachedShop().getLocation().getZ()) / 2.0;
            Location newloc = new Location(this.shop.getLocation().getWorld(), avgX, this.shop.getLocation().getY(), avgZ, this.shop.getLocation().getYaw(), this.shop.getLocation().getPitch());
            return newloc.add(0.5, 1.2, 0.5);
        }
        return this.shop.getLocation().clone().add(0.5, 1.2, 0.5);
    }

    public abstract boolean isSpawned();

    public void pendingRemoval() {
        this.pendingRemoval = true;
    }

    public boolean isPendingRemoval() {
        return this.pendingRemoval;
    }

    public static void setNotSupportVirtualItem(boolean isNotSupportVirtualItem) {
        DisplayItem.isNotSupportVirtualItem = isNotSupportVirtualItem;
    }
}

