/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.shop;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.chat.QuickComponent;
import org.maxgamer.quickshop.shop.Shop;

public class ShopControlPanel {
    private final Map<Plugin, TreeSet<Entry>> panelRegistry = new ConcurrentHashMap<Plugin, TreeSet<Entry>>();
    private final QuickShop plugin;

    public ShopControlPanel(QuickShop plugin) {
        this.plugin = plugin;
    }

    public void register(@NotNull Plugin namespace, int priority, @NotNull @NotNull Function<Map.Entry<@NotNull CommandSender, @NotNull Shop>, @Nullable QuickComponent> executor) {
        Entry entry;
        TreeSet<Entry> entries = this.panelRegistry.get(namespace);
        if (entries == null) {
            entries = new TreeSet<Entry>(new Comparator());
        }
        if (entries.contains(entry = new Entry(priority, executor))) {
            return;
        }
        entries.add(entry);
        this.panelRegistry.put(namespace, entries);
    }

    public void unregister(@NotNull Plugin namespace, int priority, @NotNull @NotNull Function<Map.Entry<@NotNull CommandSender, @NotNull Shop>, @Nullable QuickComponent> executor) {
        TreeSet<Entry> entries = this.panelRegistry.get(namespace);
        if (entries == null) {
            return;
        }
        Entry entry = new Entry(priority, executor);
        entries.remove(entry);
    }

    public void unregister(@NotNull Plugin namespace, @NotNull @NotNull Function<Map.Entry<@NotNull CommandSender, @NotNull Shop>, @Nullable QuickComponent> executor) {
        TreeSet<Entry> entries = this.panelRegistry.get(namespace);
        if (entries == null) {
            return;
        }
        entries.removeIf(entry -> entry.getExecutor().equals(executor));
    }

    public void unregisterAll(@NotNull Plugin namespace) {
        this.panelRegistry.remove(namespace);
    }

    public static class Comparator
    implements java.util.Comparator<Entry>,
    Serializable {
        @Override
        public int compare(Entry o1, Entry o2) {
            return o1.priority - o2.priority;
        }
    }

    public static class Entry {
        private final int priority;
        private final Function<Map.Entry<@NotNull CommandSender, @NotNull Shop>, @Nullable QuickComponent> executor;

        public Entry(int priority, @NotNull @NotNull Function<Map.Entry<@NotNull CommandSender, @NotNull Shop>, @Nullable QuickComponent> executor) {
            this.priority = priority;
            this.executor = executor;
        }

        public int getPriority() {
            return this.priority;
        }

        @NotNull
        public @NotNull Function<Map.Entry<@NotNull CommandSender, @NotNull Shop>, @Nullable QuickComponent> getExecutor() {
            return this.executor;
        }

        @Nullable
        public QuickComponent get(@NotNull @NotNull Map.Entry<@NotNull CommandSender, @NotNull Shop> data) {
            return this.executor.apply(data);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPriority() != other.getPriority()) {
                return false;
            }
            Function<Map.Entry<CommandSender, Shop>, QuickComponent> this$executor = this.getExecutor();
            Function<Map.Entry<CommandSender, Shop>, QuickComponent> other$executor = other.getExecutor();
            return !(this$executor == null ? other$executor != null : !this$executor.equals(other$executor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPriority();
            Function<Map.Entry<CommandSender, Shop>, QuickComponent> $executor = this.getExecutor();
            result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
            return result;
        }
    }
}

