/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.maxgamer.quickshop.QuickShop;

public class AsyncPacketSender {
    private static volatile AsyncSendingTask instance = null;
    private static boolean isUsingGlobal = false;
    private static volatile boolean enabled = false;

    private AsyncPacketSender() {
    }

    public static synchronized void start(QuickShop plugin) {
        isUsingGlobal = plugin.getConfig().getBoolean("use-global-virtual-item-queue");
        if (isUsingGlobal) {
            AsyncPacketSender.createAndCancelExistingTask(plugin);
        }
        enabled = true;
    }

    private static synchronized void createAndCancelExistingTask(QuickShop plugin) {
        if (instance != null) {
            instance.stop();
        }
        instance = new AsyncSendingTask();
        instance.start(plugin);
    }

    public static AsyncSendingTask create() {
        if (!enabled) {
            throw new IllegalStateException("Please start AsyncPacketSender first!");
        }
        if (isUsingGlobal) {
            return instance;
        }
        return new AsyncSendingTask();
    }

    public static synchronized void stop() {
        if (isUsingGlobal) {
            instance.stop();
        }
    }

    public static class AsyncSendingTask {
        private final Queue<Runnable> asyncPacketSendQueue = new ArrayBlockingQueue<Runnable>(100, true);
        private final AtomicBoolean taskDone = new AtomicBoolean(true);
        private volatile BukkitTask asyncSendingTask;

        public synchronized void start(QuickShop plugin) {
            if (this.asyncSendingTask == null || this.asyncSendingTask.isCancelled()) {
                this.asyncSendingTask = plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, () -> {
                    if (this.asyncSendingTask.isCancelled()) {
                        return;
                    }
                    if (!this.taskDone.get()) {
                        return;
                    }
                    this.taskDone.set(false);
                    Runnable nextTask = this.asyncPacketSendQueue.poll();
                    while (nextTask != null) {
                        nextTask.run();
                        nextTask = this.asyncPacketSendQueue.poll();
                    }
                    this.taskDone.set(true);
                }, 0L, 1L);
            }
        }

        public synchronized void stop() {
            if (this.asyncSendingTask != null && !this.asyncSendingTask.isCancelled()) {
                this.asyncSendingTask.cancel();
            }
            this.asyncPacketSendQueue.clear();
        }

        public void offer(Runnable runnable) {
            this.asyncPacketSendQueue.offer(runnable);
        }
    }
}

