/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.util.CalculateUtil;
import org.maxgamer.quickshop.util.Util;

public class PriceLimiter {
    private double minPrice;
    private double maxPrice;
    private boolean allowFreeShop;
    private boolean wholeNumberOnly;

    @NotNull
    public CheckResult check(@NotNull ItemStack stack, double price) {
        if (Double.isInfinite(price) || Double.isNaN(price)) {
            return new CheckResult(Status.NOT_VALID, this.minPrice, this.maxPrice);
        }
        if (this.allowFreeShop && price != 0.0 && price < this.minPrice) {
            return new CheckResult(Status.REACHED_PRICE_MIN_LIMIT, this.minPrice, this.maxPrice);
        }
        if (this.wholeNumberOnly) {
            try {
                BigDecimal.valueOf(price).setScale(0, RoundingMode.UNNECESSARY);
            }
            catch (ArithmeticException exception) {
                Util.debugLog(exception.getMessage());
                return new CheckResult(Status.NOT_A_WHOLE_NUMBER, this.minPrice, this.maxPrice);
            }
        }
        if (price < this.minPrice) {
            return new CheckResult(Status.REACHED_PRICE_MIN_LIMIT, this.minPrice, this.maxPrice);
        }
        if (this.maxPrice != -1.0 && price > this.maxPrice) {
            return new CheckResult(Status.REACHED_PRICE_MAX_LIMIT, this.minPrice, this.maxPrice);
        }
        double perItemPrice = QuickShop.getInstance().isAllowStack() ? CalculateUtil.divide(price, stack.getAmount()) : price;
        Map.Entry<Double, Double> materialLimit = Util.getPriceRestriction(stack.getType());
        if (materialLimit != null) {
            if (perItemPrice < materialLimit.getKey() || perItemPrice > materialLimit.getValue()) {
                return new CheckResult(Status.PRICE_RESTRICTED, materialLimit.getKey(), materialLimit.getValue());
            }
            return new CheckResult(Status.PASS, materialLimit.getKey(), materialLimit.getValue());
        }
        return new CheckResult(Status.PASS, this.minPrice, this.maxPrice);
    }

    public PriceLimiter(double minPrice, double maxPrice, boolean allowFreeShop, boolean wholeNumberOnly) {
        this.minPrice = minPrice;
        this.maxPrice = maxPrice;
        this.allowFreeShop = allowFreeShop;
        this.wholeNumberOnly = wholeNumberOnly;
    }

    public double getMinPrice() {
        return this.minPrice;
    }

    public double getMaxPrice() {
        return this.maxPrice;
    }

    public boolean isAllowFreeShop() {
        return this.allowFreeShop;
    }

    public boolean isWholeNumberOnly() {
        return this.wholeNumberOnly;
    }

    public void setMinPrice(double minPrice) {
        this.minPrice = minPrice;
    }

    public void setMaxPrice(double maxPrice) {
        this.maxPrice = maxPrice;
    }

    public void setAllowFreeShop(boolean allowFreeShop) {
        this.allowFreeShop = allowFreeShop;
    }

    public void setWholeNumberOnly(boolean wholeNumberOnly) {
        this.wholeNumberOnly = wholeNumberOnly;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PriceLimiter)) {
            return false;
        }
        PriceLimiter other = (PriceLimiter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMinPrice(), other.getMinPrice()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxPrice(), other.getMaxPrice()) != 0) {
            return false;
        }
        if (this.isAllowFreeShop() != other.isAllowFreeShop()) {
            return false;
        }
        return this.isWholeNumberOnly() == other.isWholeNumberOnly();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PriceLimiter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $minPrice = Double.doubleToLongBits(this.getMinPrice());
        result = result * 59 + (int)($minPrice >>> 32 ^ $minPrice);
        long $maxPrice = Double.doubleToLongBits(this.getMaxPrice());
        result = result * 59 + (int)($maxPrice >>> 32 ^ $maxPrice);
        result = result * 59 + (this.isAllowFreeShop() ? 79 : 97);
        result = result * 59 + (this.isWholeNumberOnly() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "PriceLimiter(minPrice=" + this.getMinPrice() + ", maxPrice=" + this.getMaxPrice() + ", allowFreeShop=" + this.isAllowFreeShop() + ", wholeNumberOnly=" + this.isWholeNumberOnly() + ")";
    }

    public static class CheckResult {
        private Status status;
        private double min;
        private double max;

        public CheckResult(Status status, double min, double max) {
            this.status = status;
            this.min = min;
            this.max = max;
        }

        public Status getStatus() {
            return this.status;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public void setMin(double min) {
            this.min = min;
        }

        public void setMax(double max) {
            this.max = max;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CheckResult)) {
                return false;
            }
            CheckResult other = (CheckResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getMin(), other.getMin()) != 0) {
                return false;
            }
            if (Double.compare(this.getMax(), other.getMax()) != 0) {
                return false;
            }
            Status this$status = this.getStatus();
            Status other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CheckResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $min = Double.doubleToLongBits(this.getMin());
            result = result * 59 + (int)($min >>> 32 ^ $min);
            long $max = Double.doubleToLongBits(this.getMax());
            result = result * 59 + (int)($max >>> 32 ^ $max);
            Status $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            return result;
        }

        public String toString() {
            return "PriceLimiter.CheckResult(status=" + (Object)((Object)this.getStatus()) + ", min=" + this.getMin() + ", max=" + this.getMax() + ")";
        }
    }

    public static enum Status {
        PASS,
        REACHED_PRICE_MAX_LIMIT,
        REACHED_PRICE_MIN_LIMIT,
        PRICE_RESTRICTED,
        NOT_A_WHOLE_NUMBER,
        NOT_VALID;

    }
}

