/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util;

public class Timer {
    private long startTime;
    private long passedTime;
    private boolean isPaused = false;

    public Timer() {
    }

    public Timer(boolean autoStart) {
        if (autoStart) {
            this.start();
        }
    }

    public Timer(long startTime) {
        this.startTime = startTime;
    }

    public long stopAndGetTimePassed() {
        long time = this.getPassedTime();
        this.startTime = 0L;
        return time;
    }

    public long getPassedTimeOffsetFrom(long atTime) {
        return atTime - this.startTime + this.passedTime;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.isPaused = false;
    }

    public void pause() {
        this.passedTime = this.getPassedTime();
        this.isPaused = true;
    }

    public void resume() {
        if (this.isPaused) {
            this.startTime = System.currentTimeMillis() - this.passedTime;
            this.passedTime = 0L;
            this.isPaused = false;
        }
    }

    public long getPassedTime() {
        if (this.isPaused) {
            return this.passedTime;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Timer)) {
            return false;
        }
        Timer other = (Timer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.startTime != other.startTime) {
            return false;
        }
        return this.isPaused == other.isPaused;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Timer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTime = this.startTime;
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        result = result * 59 + (this.isPaused ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Timer(startTime=" + this.startTime + ", passedTime=" + this.getPassedTime() + ", isPaused=" + this.isPaused + ")";
    }
}

