/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util.envcheck;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.zip.ZipFile;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.shop.DisplayItem;
import org.maxgamer.quickshop.shop.DisplayType;
import org.maxgamer.quickshop.shop.VirtualDisplayItem;
import org.maxgamer.quickshop.util.GameVersion;
import org.maxgamer.quickshop.util.JsonUtil;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.ReflectFactory;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.envcheck.CheckResult;
import org.maxgamer.quickshop.util.envcheck.EnvCheckEntry;
import org.maxgamer.quickshop.util.envcheck.ResultContainer;
import org.maxgamer.quickshop.util.envcheck.ResultReport;
import org.maxgamer.quickshop.util.security.JarVerifyTool;

public final class EnvironmentChecker {
    private final QuickShop plugin;
    private final List<Method> tests = new ArrayList<Method>();

    public EnvironmentChecker(QuickShop plugin) {
        this.plugin = plugin;
        this.registerTests(this.getClass());
    }

    public void registerTests(@NotNull Class<?> clazz) {
        for (Method declaredMethod : clazz.getDeclaredMethods()) {
            this.registerTest(declaredMethod);
        }
    }

    public void registerTest(@NotNull Method method) {
        EnvCheckEntry envCheckEntry = method.getAnnotation(EnvCheckEntry.class);
        if (envCheckEntry == null) {
            return;
        }
        if (method.getReturnType() != ResultContainer.class) {
            this.plugin.getLogger().warning("Failed loading EncCheckEntry [" + method.getName() + "]: Illegal test returns");
            return;
        }
        this.tests.add(method);
    }

    private void sortTests() {
        this.tests.sort((o1, o2) -> {
            EnvCheckEntry e1 = o1.getAnnotation(EnvCheckEntry.class);
            EnvCheckEntry e2 = o2.getAnnotation(EnvCheckEntry.class);
            return Integer.compare(e1.priority(), e2.priority());
        });
    }

    public ResultReport run(EnvCheckEntry.Stage stage) {
        this.sortTests();
        LinkedHashMap<EnvCheckEntry, ResultContainer> results = new LinkedHashMap<EnvCheckEntry, ResultContainer>();
        boolean skipAllTest = false;
        ResultContainer executeResult = null;
        CheckResult result = CheckResult.PASSED;
        Properties properties = System.getProperties();
        for (Method declaredMethod : this.tests) {
            if (skipAllTest) break;
            try {
                EnvCheckEntry envCheckEntry = declaredMethod.getAnnotation(EnvCheckEntry.class);
                if (Arrays.stream(envCheckEntry.stage()).noneMatch(entry -> entry == stage)) {
                    Util.debugLog("Skip test: " + envCheckEntry.name() + ": Except stage: " + Arrays.toString((Object[])envCheckEntry.stage()) + " Current stage: " + (Object)((Object)stage));
                    continue;
                }
                if (!properties.containsKey("org.maxgamer.quickshop.util.envcheck.skip." + envCheckEntry.name().toUpperCase(Locale.ROOT).replace(" ", "_"))) {
                    executeResult = (ResultContainer)declaredMethod.invoke((Object)this, new Object[0]);
                    if (executeResult.getResult().ordinal() > result.ordinal()) {
                        result = executeResult.getResult();
                    }
                } else {
                    result = CheckResult.SKIPPED;
                }
                switch (result) {
                    case SKIPPED: {
                        this.plugin.getLogger().info("[SKIP] " + envCheckEntry.name());
                        Util.debugLog("Runtime check [" + envCheckEntry.name() + "] has been skipped (Startup Flag).");
                        break;
                    }
                    case PASSED: {
                        if (!Util.isDevEdition() && !Util.isDevMode()) break;
                        this.plugin.getLogger().info("[OK] " + envCheckEntry.name());
                        Util.debugLog("[Pass] " + envCheckEntry.name() + ": " + executeResult.getResultMessage());
                        break;
                    }
                    case WARNING: {
                        this.plugin.getLogger().warning("[WARN] " + envCheckEntry.name() + ": " + executeResult.getResultMessage());
                        Util.debugLog("[Warning] " + envCheckEntry.name() + ": " + executeResult.getResultMessage());
                        break;
                    }
                    case STOP_WORKING: {
                        this.plugin.getLogger().warning("[STOP] " + envCheckEntry.name() + ": " + executeResult.getResultMessage());
                        Util.debugLog("[Stop-Freeze] " + envCheckEntry.name() + ": " + executeResult.getResultMessage());
                        break;
                    }
                    case DISABLE_PLUGIN: {
                        this.plugin.getLogger().warning("[FATAL] " + envCheckEntry.name() + ": " + executeResult.getResultMessage());
                        Util.debugLog("[Fatal-Disable] " + envCheckEntry.name() + ": " + executeResult.getResultMessage());
                        skipAllTest = true;
                        break;
                    }
                    default: {
                        this.plugin.getLogger().warning("[UNDEFINED] " + envCheckEntry.name() + ": " + executeResult.getResultMessage());
                    }
                }
                if (executeResult != null) {
                    results.put(envCheckEntry, executeResult);
                    continue;
                }
                results.put(envCheckEntry, new ResultContainer(CheckResult.SKIPPED, "Startup flag mark this check should be skipped."));
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to execute EnvCheckEntry [" + declaredMethod.getName() + "]: Exception thrown out without getting caught. Something went wrong!", e);
                this.plugin.getLogger().warning("[FAIL] " + declaredMethod.getName());
            }
        }
        return new ResultReport(result, results);
    }

    public boolean isOutdatedJvm() {
        String jvmVersion = System.getProperty("java.version");
        String[] splitVersion = jvmVersion.split("\\.");
        if (splitVersion.length < 1) {
            Util.debugLog("Failed to parse jvm version to check: " + jvmVersion);
            return false;
        }
        try {
            int majorVersion = Integer.parseInt(splitVersion[0]);
            return majorVersion < 16;
        }
        catch (NumberFormatException ignored) {
            Util.debugLog("Failed to parse jvm major version to check: " + splitVersion[0]);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EnvCheckEntry(name="Signature Verify", priority=0, stage={EnvCheckEntry.Stage.ON_LOAD, EnvCheckEntry.Stage.ON_ENABLE})
    public ResultContainer securityVerify() {
        JarVerifyTool tool = new JarVerifyTool();
        ZipFile jarFile = null;
        try {
            ResultContainer resultContainer;
            ClassLoader loader = this.getClass().getClassLoader();
            try (InputStream stream1 = loader.getResourceAsStream("META-INF/MANIFEST.MF");
                 InputStream stream2 = loader.getResourceAsStream("META-INF/SELFSIGN.DSA");
                 InputStream stream3 = loader.getResourceAsStream("META-INF/SELFSIGN.SF");){
                if (stream1 == null || stream2 == null || stream3 == null) {
                    this.plugin.getLogger().warning("The signature could not be found! The QuickShop jar has been modified or you're running a custom build.");
                    ResultContainer resultContainer2 = new ResultContainer(CheckResult.STOP_WORKING, "Security risk detected, QuickShop jar has been modified.");
                    return resultContainer2;
                }
            }
            String jarPath = this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile();
            jarPath = URLDecoder.decode(jarPath, "UTF-8");
            Util.debugLog("JarPath selected: " + jarPath);
            jarFile = new JarFile(jarPath);
            List<JarEntry> modifiedEntry = tool.verify((JarFile)jarFile);
            if (modifiedEntry.isEmpty()) {
                resultContainer = new ResultContainer(CheckResult.PASSED, "The jar is valid. No issues detected.");
                return resultContainer;
            }
            modifiedEntry.forEach(jarEntry -> {
                this.plugin.getLogger().warning(">> Modified Class Detected <<");
                this.plugin.getLogger().warning("Name: " + jarEntry.getName());
                this.plugin.getLogger().warning("CRC: " + jarEntry.getCrc());
                this.plugin.getLogger().warning(JsonUtil.getGson().toJson(jarEntry));
            });
            this.plugin.getLogger().severe("QuickShop detected that the jar has been modified! This is usually caused by the file being damaged or virus infected.");
            this.plugin.getLogger().severe("To prevent severe server failure, QuickShop has been disabled.");
            this.plugin.getLogger().severe("For further information, Please join our support Discord server: https://discord.com/invite/bfefw2E.");
            resultContainer = new ResultContainer(CheckResult.STOP_WORKING, "Security risk detected, QuickShop jar has been modified.");
            return resultContainer;
        }
        catch (IOException ioException) {
            this.plugin.getLogger().log(Level.WARNING, "ALERT: QuickShop cannot validate itself. This may be caused by you having deleted QuickShop's jar while the server is running.", ioException);
            ResultContainer resultContainer = new ResultContainer(CheckResult.WARNING, "Failed to validate digital signature! Security may be compromised!");
            return resultContainer;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @EnvCheckEntry(name="EnvChecker SelfTest", priority=1)
    public ResultContainer selfTest() {
        return new ResultContainer(CheckResult.PASSED, "I'm fine :)");
    }

    @EnvCheckEntry(name="Java Runtime Environment Version Test", priority=1, stage={EnvCheckEntry.Stage.ON_ENABLE})
    public ResultContainer jrevTest() {
        if (this.isOutdatedJvm()) {
            String jvmWarning = "\n============================================================\n    Warning! You're running an outdated version of Java!\n============================================================\n* QuickShop will stop being compatible with your current Java version in the future!\n*\n* You should schedule a Java upgrade on your server,\n* because we will drop support for any Java versions lower than Java 16.\n*\n* That means:\n* 1) Future QuickShop builds will no longer work on your server.\n* 2) No support for QuickShop builds that run on outdated Java versions will be given.\n* \n* Why:\n* 1) We don't want to keep compatibility with outdated software\n*    and systems. As Paper upgraded, we did too.\n* 2) Java is downward compatible, so most legacy (Java 8+) Plugins should still work.\n* 3) Newer Java APIs allow accessing resources and processing them\n*    faster than before, meaning a performance improvement.\n* \n* What should I do?\n* You should update your server's Java version\n* as soon as you can to Java 16 or higher.\n*\n* Most plugins can run on Java 16+ without problems\n* unless their code is really outdated.\n* If a Plugin is not compatible with Java 16 and the developer\n* doesn't update it, then you should replace them.\n*\n* You can get Java 16 here:\n* https://www.oracle.com/java/technologies/javase-downloads.html\n*\n" + String.format("* Current Java version: %s", System.getProperty("java.version"));
            this.plugin.getLogger().warning(jvmWarning);
            Thread.sleep(5000L);
            return new ResultContainer(CheckResult.WARNING, "Unsupported outdated JRE version detected.");
        }
        return new ResultContainer(CheckResult.PASSED, "Java is up-to-date: " + System.getProperty("java.version"));
    }

    @EnvCheckEntry(name="Spigot Based Server Test", priority=2)
    public ResultContainer spigotBasedServer() {
        ResultContainer success = new ResultContainer(CheckResult.PASSED, "Server");
        ResultContainer failed = new ResultContainer(CheckResult.STOP_WORKING, "Server must be Spigot based, Don't use CraftBukkit!");
        try {
            try {
                this.plugin.getServer().spigot();
                String nmsVersion = Util.getNMSVersion();
                this.plugin.getLogger().info("Running QuickShop-" + QuickShop.getFork() + " on NMS version " + nmsVersion + " For Minecraft version " + ReflectFactory.getServerVersion());
            }
            catch (Exception e) {
                return failed;
            }
            return success;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to check Spigot API!" + this.plugin.getServer().getBukkitVersion() + " may not be Spigot based.");
            return failed;
        }
    }

    @EnvCheckEntry(name="Old QuickShop Test", priority=3)
    public ResultContainer oldQuickShopTest() {
        if (Util.isClassAvailable("org.maxgamer.quickshop.Util.NMS")) {
            return new ResultContainer(CheckResult.STOP_WORKING, "FATAL: Old QuickShop build is installed! You must remove old QuickShop jar from the plugins folder!");
        }
        return new ResultContainer(CheckResult.PASSED, "No old QuickShop jar installled on this server");
    }

    public boolean isForgeBasedServer() {
        if (Util.isClassAvailable("net.minecraftforge.server.ServerMain")) {
            return true;
        }
        return Util.isClassAvailable("net.minecraftforge.fml.loading.ModInfo");
    }

    public boolean isFabricBasedServer() {
        return Util.isClassAvailable("net.fabricmc.loader.launch.knot.KnotClient");
    }

    @EnvCheckEntry(name="ModdedServer Based Test", priority=4)
    public ResultContainer moddedBasedTest() {
        boolean trigged = false;
        if (this.isForgeBasedServer()) {
            this.plugin.getLogger().warning("WARN: QuickShop is not designed and tested for Forge!");
            this.plugin.getLogger().warning("WARN: Use at you own risk!.");
            this.plugin.getLogger().warning("WARN: No support will be given!");
            trigged = true;
        }
        if (this.isFabricBasedServer()) {
            this.plugin.getLogger().warning("WARN: QuickShop is not designed and tested for Fabric!");
            this.plugin.getLogger().warning("WARN: Use at you own risk!.");
            this.plugin.getLogger().warning("WARN: No support will be given!");
            trigged = true;
        }
        if (trigged) {
            return new ResultContainer(CheckResult.WARNING, "No support will be given to modded servers.");
        }
        return new ResultContainer(CheckResult.PASSED, "Server is unmodified.");
    }

    @EnvCheckEntry(name="CoreSupport Test", priority=6)
    public ResultContainer coreSupportTest() {
        String nmsVersion = Util.getNMSVersion();
        GameVersion gameVersion = GameVersion.get(nmsVersion);
        if (!gameVersion.isCoreSupports()) {
            return new ResultContainer(CheckResult.STOP_WORKING, "Your Minecraft version is no longer supported: " + ReflectFactory.getServerVersion() + " (" + nmsVersion + ")");
        }
        if (gameVersion == GameVersion.UNKNOWN) {
            return new ResultContainer(CheckResult.WARNING, "QuickShop may not fully support version " + nmsVersion + "/" + ReflectFactory.getServerVersion() + ", Some features may not work.");
        }
        return new ResultContainer(CheckResult.PASSED, "Passed checks");
    }

    @EnvCheckEntry(name="Virtual DisplayItem Support Test", priority=7)
    public ResultContainer virtualDisplaySupportTest() {
        Throwable throwable;
        String nmsVersion = Util.getNMSVersion();
        GameVersion gameVersion = GameVersion.get(nmsVersion);
        if (!gameVersion.isVirtualDisplaySupports()) {
            throwable = new IllegalStateException("Version not supports Virtual DisplayItem.");
        } else if (this.plugin.getServer().getPluginManager().getPlugin("ProtocolLib") != null) {
            throwable = VirtualDisplayItem.PacketFactory.testFakeItem();
        } else {
            DisplayItem.setNotSupportVirtualItem(true);
            return new ResultContainer(CheckResult.WARNING, "ProtocolLib is not installed, virtual DisplayItem seems will not work on your server.");
        }
        if (throwable != null) {
            Util.debugLog(throwable.getMessage());
            MsgUtil.debugStackTrace(throwable.getStackTrace());
            DisplayItem.setNotSupportVirtualItem(true);
            this.plugin.getLogger().log(Level.SEVERE, "Virtual DisplayItem Support Test: Failed to initialize VirtualDisplayItem", throwable);
            return new ResultContainer(CheckResult.WARNING, "Virtual DisplayItem seems to not work on this Minecraft server, Make sure QuickShop, ProtocolLib and server builds are up to date.");
        }
        return new ResultContainer(CheckResult.PASSED, "Passed checks");
    }

    @EnvCheckEntry(name="PersistentStorageApi Support Test", priority=8)
    public ResultContainer persistentStorageApiSupportTest() {
        String nmsVersion = Util.getNMSVersion();
        GameVersion gameVersion = GameVersion.get(nmsVersion);
        if (!gameVersion.isPersistentStorageApiSupports()) {
            return new ResultContainer(CheckResult.WARNING, "PersistentStorageApi seems to not work on this Minecraft server, You may be at risk for an exploit. Make sure your server is running at least 1.13.2.");
        }
        return new ResultContainer(CheckResult.PASSED, "Passed checks");
    }

    @EnvCheckEntry(name="GameVersion supporting Test", priority=9)
    public ResultContainer gamerVersionSupportTest() {
        String nmsVersion = Util.getNMSVersion();
        GameVersion gameVersion = GameVersion.get(nmsVersion);
        if (gameVersion == GameVersion.UNKNOWN) {
            return new ResultContainer(CheckResult.WARNING, "Your Minecraft server version not tested by developers, QuickShop may ran into issues on this version.");
        }
        return new ResultContainer(CheckResult.PASSED, "Passed checks");
    }

    @EnvCheckEntry(name="PacketListenerAPI Conflict Test", priority=10)
    public ResultContainer plapiConflictTest() {
        if (this.plugin.isDisplay() && DisplayItem.getNowUsing() == DisplayType.VIRTUALITEM && Bukkit.getPluginManager().isPluginEnabled("ProtocolLib") && Bukkit.getPluginManager().isPluginEnabled("PacketListenerAPI")) {
            return new ResultContainer(CheckResult.WARNING, "Virtual DisplayItem may stop working on your server. We are already aware that [PacketListenerAPI] and [ProtocolLib] are conflicting. (QuickShops requirement to send fake items). If your display is not showing, please uninstall [PacketListenerAPI].");
        }
        return new ResultContainer(CheckResult.PASSED, "Passed checks");
    }

    @EnvCheckEntry(name="Permission Manager Test", priority=10, stage={EnvCheckEntry.Stage.ON_ENABLE})
    public ResultContainer permManagerConflictTest() {
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("GroupManager")) {
            return new ResultContainer(CheckResult.WARNING, "WARNING: Unsupported plugin management plugin [GroupManager] installed, the permissions may not working.");
        }
        return new ResultContainer(CheckResult.PASSED, "Passed checks");
    }
}

