/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util.location;

import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public class StringOf {
    @NotNull
    private final Location location;
    @NotNull
    private final World world;

    public StringOf(@NotNull Location location) {
        if (location.getWorld() == null) {
            throw new IllegalStateException("World of the location cannot be null!");
        }
        this.location = location;
        this.world = location.getWorld();
    }

    @NotNull
    public String asKey() {
        return this.asString().replaceAll(":", "/").replaceAll("\\.", "_");
    }

    @NotNull
    public String asString() {
        String s = this.world.getName() + ":";
        s = s + String.format(Locale.ENGLISH, "%.2f,%.2f,%.2f", this.location.getX(), this.location.getY(), this.location.getZ());
        if (this.location.getYaw() != 0.0f || this.location.getPitch() != 0.0f) {
            s = s + String.format(Locale.ENGLISH, ":%.2f:%.2f", Float.valueOf(this.location.getYaw()), Float.valueOf(this.location.getPitch()));
        }
        return s;
    }
}

