/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.util.paste;

import com.google.common.cache.CacheStats;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.database.WarpedResultSet;
import org.maxgamer.quickshop.economy.Economy;
import org.maxgamer.quickshop.economy.EconomyCore;
import org.maxgamer.quickshop.economy.Economy_Vault;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.paste.LuckoPastebinPaster;
import org.maxgamer.quickshop.util.paste.PastebinPaster;
import org.maxgamer.quickshop.util.paste.UbuntuPaster;

public class Paste {
    private final QuickShop plugin;

    @NotNull
    public String genNewPaste() {
        StringBuilder finalReport = new StringBuilder();
        finalReport.append("###############################\n");
        finalReport.append("QuickShop-").append(QuickShop.getFork()).append(" Paste Result\n");
        finalReport.append("###############################\n");
        finalReport.append("\n");
        if (this.plugin.getServer().getPluginManager().getPlugin("ConsoleSpamFix") != null) {
            finalReport.append("Warning: ConsoleSpamFix installed! Please disable it before reporting any errors!").append("\n");
        }
        finalReport.append("\n");
        finalReport.append("================================================\n");
        finalReport.append("QuickShop:\n");
        finalReport.append("\tVersion: ").append(QuickShop.getVersion()).append("\n");
        finalReport.append("\tFork: ").append(QuickShop.getFork()).append("\n");
        finalReport.append("\tBuild Number: ").append(this.plugin.getBuildInfo().getBuildId()).append("\n");
        finalReport.append("\tBuild Branch: ").append(this.plugin.getBuildInfo().getGitBranch()).append("\n");
        finalReport.append("\tBuild Commit: ").append(this.plugin.getBuildInfo().getGitCommit()).append("\n");
        finalReport.append("\tBuild URL: ").append(this.plugin.getBuildInfo().getBuildUrl()).append("\n");
        finalReport.append("\tBuild Tag: ").append(this.plugin.getBuildInfo().getBuildTag()).append("\n");
        finalReport.append("\tChat System: ").append(this.plugin.getQuickChatType().name()).append("\n");
        finalReport.append("\tServer ID: ").append(this.plugin.getServerUniqueID()).append("\n");
        finalReport.append("\tOpenInv Hook: ").append(this.plugin.getOpenInvPlugin() == null ? "Disabled" : "Enabled").append("\n");
        finalReport.append("\tEconomy System: ");
        try {
            EconomyCore economyCore = this.plugin.getEconomy().getCore();
            switch (Economy.getNowUsing()) {
                case VAULT: {
                    finalReport.append("Vault").append("%").append(((Economy_Vault)economyCore).getProviderName());
                    break;
                }
                default: {
                    finalReport.append("Unknown").append("%").append("Unknown error");
                    break;
                }
            }
        }
        catch (Exception e) {
            finalReport.append("Unknown").append("%").append("Unknown error");
        }
        finalReport.append("\n");
        finalReport.append("================================================\n");
        finalReport.append("System:\n");
        finalReport.append("\tOS: ").append(System.getProperty("os.name")).append("\n");
        finalReport.append("\tArch: ").append(System.getProperty("os.arch")).append("\n");
        finalReport.append("\tVersion: ").append(System.getProperty("os.version")).append("\n");
        finalReport.append("\tCores: ").append(Runtime.getRuntime().availableProcessors()).append("\n");
        finalReport.append("================================================\n");
        finalReport.append("Server:\n");
        finalReport.append("\tName: ").append(this.plugin.getServer().getName()).append("\n");
        finalReport.append("\tServer Name: ").append(this.plugin.getServer().getName()).append("\n");
        finalReport.append("\tBuild: ").append(this.plugin.getServer().getVersion()).append("\n");
        finalReport.append("\tNMSV: ").append(Util.getNMSVersion()).append("\n");
        finalReport.append("\tData Version: ").append(this.plugin.getServer().getUnsafe().getDataVersion()).append("\n");
        if (this.plugin.getEnvironmentChecker().isFabricBasedServer() || this.plugin.getEnvironmentChecker().isForgeBasedServer()) {
            if (this.plugin.getEnvironmentChecker().isForgeBasedServer()) {
                finalReport.append("Modded Server: Forge (No support offer on this platform)\n");
            }
            if (this.plugin.getEnvironmentChecker().isFabricBasedServer()) {
                finalReport.append("Modded Server: Fabric (No support offer on this platform)\n");
            }
        }
        finalReport.append("\tJava: ").append(System.getProperty("java.version")).append("\n");
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        finalReport.append("\tInput Args: ").append(Util.list2String(arguments)).append("\n");
        finalReport.append("\tVM Name: ").append(runtimeMxBean.getVmName()).append("\n");
        Map<String, String> sys = runtimeMxBean.getSystemProperties();
        ArrayList<String> sysData = new ArrayList<String>();
        sys.keySet().forEach(key -> sysData.add(key + "=" + (String)sys.get(key)));
        finalReport.append("\tSystem Properties: ").append(Util.list2String(sysData)).append("\n");
        finalReport.append("\tPlayers: ").append(this.plugin.getServer().getOnlinePlayers().size()).append("/").append(this.plugin.getServer().getMaxPlayers()).append("\n");
        finalReport.append("\tOnlineMode: ").append(this.plugin.getServer().getOnlineMode()).append("\n");
        finalReport.append("\tBukkitVersion: ").append(this.plugin.getServer().getVersion()).append("\n");
        finalReport.append("\tWorldContainer: ").append(this.plugin.getServer().getWorldContainer()).append("\n");
        ArrayList<String> modules = new ArrayList<String>();
        this.plugin.getIntegrationHelper().getIntegrations().forEach(m -> modules.add(m.getName()));
        finalReport.append("\tLoaded Integrations: ").append(Util.list2String(modules)).append("\n");
        finalReport.append("================================================\n");
        finalReport.append("Replaceable Modules Status:\n");
        finalReport.append("\tItemMatcher: ").append(this.plugin.getItemMatcher().getName()).append("@").append(this.plugin.getItemMatcher().getPlugin().getName()).append("\n");
        if (this.plugin.getEconomy() == null) {
            finalReport.append("\tEconomyCore: ").append("Not loaded").append("@").append("Unknown").append("\n");
        } else {
            finalReport.append("\tEconomyCore: ").append(this.plugin.getEconomy().getCore().getName()).append("@").append(this.plugin.getEconomy().getCore().getPlugin().getName()).append("\n");
        }
        finalReport.append("\tDatabaseCore: ").append(this.plugin.getDatabaseManager().getDatabase().getName()).append("@").append(this.plugin.getDatabaseManager().getDatabase().getPlugin().getName()).append("\n");
        finalReport.append("\tGameLanguage Processor: ").append(MsgUtil.gameLanguage.getName()).append("@").append(MsgUtil.gameLanguage.getPlugin().getName()).append("\n");
        finalReport.append("================================================\n");
        finalReport.append("Worlds:\n");
        finalReport.append("\tTotal: ").append(this.plugin.getServer().getWorlds().size()).append("\n");
        for (World world : this.plugin.getServer().getWorlds()) {
            finalReport.append("\t*********************************\n");
            finalReport.append("\t\tName: ").append(world.getName()).append("\n");
            finalReport.append("\t\tEnvironment: ").append(world.getEnvironment().name()).append("\n");
            finalReport.append("\t\tPlayer In World: ").append(world.getPlayers().size()).append("\n");
            finalReport.append("\t\tShops In World: ").append(Util.getShopsInWorld(world.getName())).append("\n");
        }
        finalReport.append("\t*********************************\n");
        finalReport.append("================================================\n");
        finalReport.append("Plugins:\n");
        finalReport.append("\tTotal: ").append(this.plugin.getServer().getPluginManager().getPlugins().length).append("\n");
        for (Plugin bplugin : this.plugin.getServer().getPluginManager().getPlugins()) {
            finalReport.append("\t").append(bplugin.getName()).append(" @ ").append(bplugin.isEnabled() ? "Enabled" : "Disabled").append(" # ").append(bplugin.getDescription().getVersion()).append(" # ").append(bplugin.getDescription().getAPIVersion());
            if (bplugin.getDescription().getDepend().contains(this.plugin.getName()) || bplugin.getDescription().getSoftDepend().contains(this.plugin.getName())) {
                finalReport.append(" # [Addon/Compatible Module]");
            }
            finalReport.append(" # ");
            Class<?> pluginClass = bplugin.getClass();
            Package pluginPackage = pluginClass.getPackage();
            String className = pluginClass == null ? "[Null Class]" : pluginClass.getName();
            String packageName = pluginPackage == null ? "[Default Package]" : pluginPackage.getName();
            if (className.startsWith(packageName)) {
                finalReport.append(className);
            } else {
                finalReport.append(packageName).append(".").append(className);
            }
            finalReport.append("\n");
        }
        finalReport.append("================================================\n");
        finalReport.append("Performance:\n");
        finalReport.append("\tCache:\n");
        finalReport.append("\t\tCache      Enabled: ").append(this.plugin.getShopCache() != null).append("\n");
        if (this.plugin.getShopCache() != null) {
            CacheStats stats = this.plugin.getShopCache().getStats();
            finalReport.append("\t\t--------------------------").append("\n");
            finalReport.append("\t\tAvg  Load  Penalty: ").append(stats.averageLoadPenalty()).append("\n");
            finalReport.append("\t\tHit           Rate: ").append(stats.hitRate()).append("\n");
            finalReport.append("\t\tMiss          Rate: ").append(stats.missRate()).append("\n");
            finalReport.append("\t\t--------------------------").append("\n");
            finalReport.append("\t\tHit          Count: ").append(stats.hitCount()).append("\n");
            finalReport.append("\t\tMiss         Count: ").append(stats.missCount()).append("\n");
            finalReport.append("\t\tLoad         Count: ").append(stats.loadCount()).append("\n");
            finalReport.append("\t\tLoad Success Count: ").append(stats.loadSuccessCount()).append("\n");
            finalReport.append("\t\t--------------------------").append("\n");
            finalReport.append("\t\tEviction     Count: ").append(stats.evictionCount()).append("\n");
            finalReport.append("\t\tEviction     Count: ").append(stats.evictionCount()).append("\n");
            finalReport.append("\t\t--------------------------").append("\n");
            finalReport.append("\t\tRequest      Count: ").append(stats.requestCount()).append("\n");
            finalReport.append("\t\tTotal Loading Time: ").append(stats.totalLoadTime()).append("\n");
        }
        finalReport.append("================================================\n");
        finalReport.append("Configurations:\n");
        try {
            finalReport.append("\t*********************************\n");
            finalReport.append("\tconfig.yml:\n");
            finalReport.append("\t\t\n");
            String config = new String(Objects.requireNonNull(Util.inputStream2ByteArray(this.plugin.getDataFolder() + "/config.yml")), StandardCharsets.UTF_8);
            try {
                ConfigurationSection configurationSection = this.plugin.getConfig().getConfigurationSection("database");
                config = config.replaceAll(Objects.requireNonNull(Objects.requireNonNull(configurationSection).getString("user")), "[PROTECTED]");
                config = config.replace(Objects.requireNonNull(configurationSection.getString("password")), "[PROTECTED]");
                config = config.replace(Objects.requireNonNull(configurationSection.getString("host")), "[PROTECTED]");
                config = config.replace(Objects.requireNonNull(configurationSection.getString("port")), "[PROTECTED]");
                config = config.replace(Objects.requireNonNull(configurationSection.getString("database")), "[PROTECTED]");
            }
            catch (Exception configurationSection) {
                // empty catch block
            }
            finalReport.append(config).append("\n");
            finalReport.append("\t*********************************\n");
            finalReport.append("\tmessages.json:\n");
            finalReport.append("\t\t\n").append(new String(Objects.requireNonNull(Util.inputStream2ByteArray(this.plugin.getDataFolder() + "/messages.json")), StandardCharsets.UTF_8)).append("\n");
            finalReport.append("\t*********************************\n");
            finalReport.append("\titemi18n.yml:\n");
            finalReport.append("\t\t\n").append(new String(Objects.requireNonNull(Util.inputStream2ByteArray(new File(this.plugin.getDataFolder(), "itemi18n.yml").getPath())), StandardCharsets.UTF_8)).append("\n");
            finalReport.append("\t*********************************\n");
            finalReport.append("\tenchi18n.yml:\n");
            finalReport.append("\t\t\n").append(new String(Objects.requireNonNull(Util.inputStream2ByteArray(new File(this.plugin.getDataFolder(), "enchi18n.yml").getPath())), StandardCharsets.UTF_8)).append("\n");
            finalReport.append("\t*********************************\n");
            finalReport.append("\tpotioni18n.yml:\n");
            finalReport.append("\t\t\n").append(new String(Objects.requireNonNull(Util.inputStream2ByteArray(new File(this.plugin.getDataFolder(), "potioni18n.yml").getPath())), StandardCharsets.UTF_8)).append("\n");
            finalReport.append("\t*********************************\n");
            finalReport.append("\tInternal Debug Log:\n");
            finalReport.append("\t\t\n").append(Util.list2String(Util.getDebugLogs()).replaceAll(",", "\n")).append("\n");
            try {
                finalReport.append("\t*********************************\n");
                finalReport.append("\tbukkit.yml:\n");
                finalReport.append("\t\t\n").append(new String(Objects.requireNonNull(Util.inputStream2ByteArray(new File(new File("."), "bukkit.yml").getPath())), StandardCharsets.UTF_8)).append("\n");
            }
            catch (Exception th) {
                finalReport.append("\t*********************************\n");
                finalReport.append("\tbukkit.yml:\n");
                finalReport.append("\t\t\n").append("Read failed.").append("\n");
            }
            try {
                finalReport.append("\t*********************************\n");
                finalReport.append("\tspigot.yml:\n");
                finalReport.append("\t\t\n").append(new String(Objects.requireNonNull(Util.inputStream2ByteArray(new File(new File("."), "spigot.yml").getPath())), StandardCharsets.UTF_8)).append("\n");
            }
            catch (Exception th) {
                finalReport.append("\t*********************************\n");
                finalReport.append("\tspigot.yml:\n");
                finalReport.append("\t\t\n").append("Read failed.").append("\n");
            }
            try {
                finalReport.append("\t*********************************\n");
                finalReport.append("\tpaper.yml:\n");
                finalReport.append("\t\t\n").append(new String(Objects.requireNonNull(Util.inputStream2ByteArray(new File(new File("."), "paper.yml").getPath())), StandardCharsets.UTF_8).replaceAll("secret:.*", "secret: [PROTECTED]")).append("\n");
            }
            catch (Exception th) {
                finalReport.append("\t*********************************\n");
                finalReport.append("\tpaper.yml:\n");
                finalReport.append("\t\t\n").append("Read failed.").append("\n");
            }
            try {
                finalReport.append("\t*********************************\n");
                finalReport.append("\ttuinity.yml:\n");
                finalReport.append("\t\t\n").append(new String(Objects.requireNonNull(Util.inputStream2ByteArray(new File(new File("."), "tuinity.yml").getPath())), StandardCharsets.UTF_8)).append("\n");
            }
            catch (Exception th) {
                finalReport.append("\t*********************************\n");
                finalReport.append("\ttuinity.yml:\n");
                finalReport.append("\t\t\n").append("Read failed.").append("\n");
            }
            try {
                finalReport.append("\t*********************************\n");
                finalReport.append("\tpurpur.yml:\n");
                finalReport.append("\t\t\n").append(new String(Objects.requireNonNull(Util.inputStream2ByteArray(new File(new File("."), "purpur.yml").getPath())), StandardCharsets.UTF_8)).append("\n");
            }
            catch (Exception th) {
                finalReport.append("\t*********************************\n");
                finalReport.append("\tpurpur.yml:\n");
                finalReport.append("\t\t\n").append("Read failed.").append("\n");
            }
        }
        catch (Exception ignored) {
            finalReport.append("\tFailed to get data\n");
        }
        finalReport.append("================================================\n");
        finalReport.append("Shops in DB:\n");
        this.plugin.getShopLoader().getOriginShopsInDatabase().forEach(shopDatabaseInfoOrigin -> finalReport.append("\t").append(shopDatabaseInfoOrigin).append("\n"));
        finalReport.append("Total: ").append(this.plugin.getShopLoader().getOriginShopsInDatabase().size()).append("\n");
        finalReport.append("================================================\n");
        int totalDB = 0;
        try (WarpedResultSet warpRS = this.plugin.getDatabaseHelper().selectAllShops();){
            while (warpRS.getResultSet().next()) {
                ++totalDB;
            }
        }
        finalReport.append("Shops in DB(RealTime): ").append(totalDB).append("\n");
        finalReport.append("================================================\n");
        finalReport.append("Shops in Mem:\n");
        finalReport.append("Total: ").append(this.plugin.getShopLoader().getShopsInDatabase().size()).append("\n");
        finalReport.append("================================================\n");
        return finalReport.toString();
    }

    @Nullable
    public String paste(@NotNull String content) {
        try {
            LuckoPastebinPaster paster = new LuckoPastebinPaster();
            return paster.pasteTheText(content);
        }
        catch (Exception ex) {
            Util.debugLog(ex.getMessage());
            try {
                PastebinPaster paster = new PastebinPaster();
                return paster.pasteTheText(content);
            }
            catch (Exception ex2) {
                Util.debugLog(ex2.getMessage());
                try {
                    UbuntuPaster paster = new UbuntuPaster();
                    return paster.pasteTheText(content);
                }
                catch (Exception ex3) {
                    Util.debugLog(ex3.getMessage());
                    return null;
                }
            }
        }
    }

    @Nullable
    public String paste(@NotNull String content, PasteType type) {
        switch (type) {
            case PASTEBIN: {
                try {
                    PastebinPaster paster = new PastebinPaster();
                    return paster.pasteTheText(content);
                }
                catch (Exception exception) {
                    break;
                }
            }
            case UBUNTU: {
                try {
                    UbuntuPaster paster = new UbuntuPaster();
                    return paster.pasteTheText(content);
                }
                catch (Exception exception) {
                    break;
                }
            }
            default: {
                try {
                    LuckoPastebinPaster paster = new LuckoPastebinPaster();
                    return paster.pasteTheText(content);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public Paste(QuickShop plugin) {
        this.plugin = plugin;
    }

    public static enum PasteType {
        LUCKO,
        PASTEBIN,
        UBUNTU;

    }
}

