/*
 * Decompiled with CFR 0.152.
 */
package com.ericdebouwer.zombieapocalypse;

import com.ericdebouwer.zombieapocalypse.UpdateChecker;
import com.ericdebouwer.zombieapocalypse.apocalypse.ApocalypseCommand;
import com.ericdebouwer.zombieapocalypse.apocalypse.ApocalypseListener;
import com.ericdebouwer.zombieapocalypse.apocalypse.ApocalypseManager;
import com.ericdebouwer.zombieapocalypse.config.ConfigurationManager;
import com.ericdebouwer.zombieapocalypse.integration.bstats.bukkit.Metrics;
import com.ericdebouwer.zombieapocalypse.integration.silkspawners.SilkZombieItems;
import com.ericdebouwer.zombieapocalypse.integration.silkspawners.SpawnerBreakListener;
import com.ericdebouwer.zombieapocalypse.zombie.ZombieCommand;
import com.ericdebouwer.zombieapocalypse.zombie.ZombieFactory;
import com.ericdebouwer.zombieapocalypse.zombie.ZombieItems;
import com.ericdebouwer.zombieapocalypse.zombie.ZombieListener;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Consumer;

public class ZombieApocalypse
extends JavaPlugin {
    private ApocalypseManager apocalypseManager;
    private ConfigurationManager configManager;
    private ZombieFactory zombieFactory;
    private ZombieItems zombieItems;
    private boolean paperMC = false;

    public void onEnable() {
        this.zombieFactory = new ZombieFactory(this);
        this.configManager = new ConfigurationManager(this);
        if (!this.configManager.isValid()) {
            this.getLogger().warning("Invalid config.yml, plugin will disable to prevent crashing!");
            this.getLogger().warning("See the header of the config.yml about fixing the problem.");
            return;
        }
        this.getLogger().info("Configuration has been successfully loaded!");
        this.getLogger().info("If you really love this project, you could consider donating to help me keep this project alive! https://paypal.me/3ricL");
        ApocalypseCommand apoCommand = new ApocalypseCommand(this);
        this.getCommand("apocalypse").setExecutor((CommandExecutor)apoCommand);
        this.getCommand("apocalypse").setTabCompleter((TabCompleter)apoCommand);
        this.apocalypseManager = new ApocalypseManager(this);
        this.zombieItems = new ZombieItems(this);
        ZombieCommand zombieCommand = new ZombieCommand(this);
        this.getCommand("zombie").setExecutor((CommandExecutor)zombieCommand);
        this.getCommand("zombie").setTabCompleter((TabCompleter)zombieCommand);
        try {
            Class.forName("org.bukkit.World").getMethod("spawn", Location.class, Class.class, CreatureSpawnEvent.SpawnReason.class, Consumer.class);
            this.paperMC = true;
            this.getLogger().info("PaperMC detected! Changing spawning algorithm accordingly");
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        this.getServer().getPluginManager().registerEvents((Listener)new ZombieListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ApocalypseListener(this), (Plugin)this);
        Plugin silkSpawnerPlugin = this.getServer().getPluginManager().getPlugin("SilkSpawners");
        if (silkSpawnerPlugin != null && silkSpawnerPlugin.isEnabled()) {
            this.getLogger().info("SilkSpawners detected! Making our spawners comply with it");
            this.zombieItems = new SilkZombieItems(this);
            this.getServer().getPluginManager().registerEvents((Listener)new SpawnerBreakListener(this), (Plugin)this);
        }
        if (this.configManager.isCollectMetrics()) {
            new Metrics(this, 14674);
        }
        if (this.configManager.isCheckUpdates()) {
            int resourceId = 82106;
            new UpdateChecker(this, resourceId).onStart(() -> this.getLogger().info("Checking for updates...")).onError(() -> this.getLogger().warning("Failed to check for updates!")).onOldVersion((oldVersion, newVersion) -> {
                this.getLogger().info("Update detected! You are using version " + oldVersion + ", but version " + newVersion + " is available!");
                this.getLogger().info("You can download the new version here -> https://www.spigotmc.org/resources/" + resourceId + "/updates");
            }).onNoUpdate(() -> this.getLogger().info("You are running the latest version.")).run();
        }
    }

    public void onDisable() {
        if (this.apocalypseManager != null) {
            this.apocalypseManager.onDisable();
        }
    }

    public ApocalypseManager getApocalypseManager() {
        return this.apocalypseManager;
    }

    public ConfigurationManager getConfigManager() {
        return this.configManager;
    }

    public ZombieFactory getZombieFactory() {
        return this.zombieFactory;
    }

    public ZombieItems getZombieItems() {
        return this.zombieItems;
    }

    public boolean isPaperMC() {
        return this.paperMC;
    }
}

