/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.command;

import com.handy.playertitle.constants.PlayerTabListEnum;
import com.handy.playertitle.constants.TabListEnum;
import com.handy.playertitle.lib.annotation.HandyCommand;
import com.handy.playertitle.lib.command.HandyCommandFactory;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.util.ConfigUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

@HandyCommand(name="playerTitle")
public class PlayerTitleCommand
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (args.length < 1) {
            return this.sendHelp(sender);
        }
        boolean rst = HandyCommandFactory.getInstance().onCommand(sender, cmd, label, args, BaseUtil.getLangMsg("noPermission"));
        if (!rst) {
            return this.sendHelp(sender);
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        List<String> commands = PlayerTabListEnum.returnList(args, args.length);
        if (sender.hasPermission("playerTitle.reload")) {
            commands = TabListEnum.returnList(args, args.length);
        }
        if (commands == null) {
            return null;
        }
        StringUtil.copyPartialMatches((String)args[args.length - 1].toLowerCase(), commands, completions);
        Collections.sort(completions);
        return completions;
    }

    private boolean sendHelp(CommandSender sender) {
        if (!sender.hasPermission("playerTitle.reload")) {
            List playerHelps = ConfigUtil.LANG_CONFIG.getStringList("playerHelps");
            for (String help : playerHelps) {
                MessageUtil.sendMessage(sender, help);
            }
            return true;
        }
        List helps = ConfigUtil.LANG_CONFIG.getStringList("helps");
        for (String help : helps) {
            MessageUtil.sendMessage(sender, help);
        }
        return true;
    }
}

