/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.core.reward;

import com.handy.playertitle.constants.RewardTypeEnum;
import com.handy.playertitle.core.reward.IRewardService;
import com.handy.playertitle.core.reward.impl.CoinRewardServiceImpl;
import com.handy.playertitle.core.reward.impl.ItemStackRewardServiceImpl;
import com.handy.playertitle.core.reward.impl.PlayerPointsRewardServiceImpl;
import com.handy.playertitle.core.reward.impl.VaultRewardServiceImpl;
import com.handy.playertitle.entity.TitleReward;
import org.bukkit.entity.Player;

public class RewardStrategy {
    private static final RewardStrategy INSTANCE = new RewardStrategy();

    private RewardStrategy() {
    }

    public static RewardStrategy getInstance() {
        return INSTANCE;
    }

    public void getReward(Player player, TitleReward titleReward) {
        IRewardService rewardService;
        RewardTypeEnum rewardTypeEnum = RewardTypeEnum.getEnumThrow(titleReward.getRewardType());
        switch (rewardTypeEnum) {
            case VAULT: {
                rewardService = new VaultRewardServiceImpl();
                break;
            }
            case PLAYER_POINTS: {
                rewardService = new PlayerPointsRewardServiceImpl();
                break;
            }
            case COIN: {
                rewardService = new CoinRewardServiceImpl();
                break;
            }
            case ITEM_STACK: {
                rewardService = new ItemStackRewardServiceImpl();
                break;
            }
            default: {
                return;
            }
        }
        rewardService.getReward(player, titleReward);
    }
}

