/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.listener.gui;

import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.constants.TitleUseTypeEnum;
import com.handy.playertitle.inventory.OpenGui;
import com.handy.playertitle.inventory.RewardGui;
import com.handy.playertitle.inventory.SelectGui;
import com.handy.playertitle.inventory.ShopGui;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.expand.adapter.PlayerSchedulerUtil;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.inventory.IHandyClickEvent;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleUtil;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class OpenClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.OPEN.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Player player = handyInventory.getPlayer();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                OpenGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                OpenGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "number")) {
            Inventory inventory = RewardGui.getInstance().createGui(player);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.OPEN_CONFIG, "shop")) {
            Inventory inventory = ShopGui.getInstance().createGui(player);
            handyInventory.syncOpen(inventory);
            return;
        }
        Map<Integer, String> custom = HandyInventoryUtil.getCustomButton(ConfigUtil.OPEN_CONFIG, "custom");
        String command = custom.get(rawSlot);
        if (StrUtil.isNotEmpty(command)) {
            PlayerSchedulerUtil.syncPerformCommand(player, command);
            return;
        }
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.OPEN_CONFIG.getString("open.index"));
        if (indexList.contains(rawSlot) && map.get(event.getRawSlot()) != null) {
            if (!ConfigUtil.SELECT_CONFIG.getBoolean("enable")) {
                TitleUtil.playerTitleUse(player, map.get(event.getRawSlot()), TitleUseTypeEnum.ALL, false);
                OpenGui.getInstance().setInventoryDate(handyInventory);
                return;
            }
            Inventory inventory = SelectGui.getInstance().createGui(player, map.get(event.getRawSlot()), handyInventory.getPageNum());
            handyInventory.syncOpen(inventory);
        }
    }
}

