/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Container;

import java.util.UUID;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Container.CMICommands;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.entity.Player;

public class CMICommandSender {
    private commandSenderType type = commandSenderType.invalid;
    private CommandSender sender;

    public CMICommandSender(CommandSender sender) {
        this.sender = sender;
        if (sender == null) {
            return;
        }
        if (sender instanceof Player) {
            this.type = commandSenderType.player;
        } else if (sender instanceof ConsoleCommandSender) {
            this.type = commandSenderType.console;
        } else {
            try {
                if (Class.forName("org.bukkit.command.BlockCommandSender") != null && sender instanceof BlockCommandSender) {
                    this.type = commandSenderType.commandblock;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (Class.forName("org.bukkit.command.ProxiedCommandSender") != null && sender instanceof ProxiedCommandSender) {
                    this.type = commandSenderType.rcon;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isPlayer() {
        return this.type.equals((Object)commandSenderType.player);
    }

    public boolean isConsole() {
        return this.type.equals((Object)commandSenderType.console);
    }

    public boolean isCommandBlock() {
        return this.type.equals((Object)commandSenderType.commandblock);
    }

    public Player getPlayer() {
        if (!this.isPlayer()) {
            return null;
        }
        return (Player)this.sender;
    }

    public boolean isValid() {
        return this.sender != null && !this.type.equals((Object)commandSenderType.invalid);
    }

    public Location getLocation() {
        if (!this.isValid()) {
            return null;
        }
        if (this.isPlayer()) {
            return this.getPlayer().getLocation();
        }
        if (this.isCommandBlock()) {
            return ((BlockCommandSender)this.sender).getBlock().getLocation();
        }
        return null;
    }

    public UUID getUUID() {
        if (!this.isValid()) {
            return null;
        }
        if (this.isPlayer()) {
            return this.getPlayer().getUniqueId();
        }
        if (this.isConsole()) {
            return CMILib.getInstance().getServerUUID();
        }
        return null;
    }

    public commandSenderType getType() {
        return this.type;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public void setSender(CommandSender sender) {
        this.sender = sender;
    }

    public void sendMessage(String message) {
        this.getSender().sendMessage(message);
    }

    public void performCommand(String command) {
        CMICommands.performCommand(this.getSender(), command);
    }

    public static enum commandSenderType {
        player,
        console,
        commandblock,
        rcon,
        invalid;

    }
}

