/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.Zrips.CMILib.Attributes.Attribute;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Colors.CMIColors;
import net.Zrips.CMILib.Enchants.CMIEnchantment;
import net.Zrips.CMILib.Entities.CMIEntity;
import net.Zrips.CMILib.Entities.CMIEntityType;
import net.Zrips.CMILib.Items.CMIAsyncHead;
import net.Zrips.CMILib.Items.CMIItemSerializer;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Recipes.CMIRecipe;
import net.Zrips.CMILib.Recipes.CMIRecipeIngredient;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CMIItemStack {
    @Deprecated
    private int id = 0;
    @Deprecated
    private short data = 0;
    private short durability = 0;
    private int amount = 0;
    private String bukkitName = null;
    private String mojangName = null;
    private CMIMaterial cmiMaterial = null;
    private Material material = null;
    private CMIEntityType entityType = null;
    private ItemStack item;

    public CMIItemStack(Material material) {
        this.material = material;
        this.cmiMaterial = CMIMaterial.get(material);
    }

    public CMIItemStack(CMIMaterial cmiMaterial) {
        this.cmiMaterial = cmiMaterial;
        if (cmiMaterial != null) {
            this.material = cmiMaterial.getMaterial();
        }
    }

    public CMIItemStack(ItemStack item) {
        this.setItemStack(item);
    }

    public CMIItemStack clone() {
        CMIItemStack cm = new CMIItemStack(this.material);
        cm.entityType = this.entityType;
        cm.setId(this.id);
        cm.setData(this.data);
        cm.setAmount(this.amount);
        cm.setDurability(this.durability);
        cm.setBukkitName(this.bukkitName);
        cm.setMojangName(this.mojangName);
        cm.setCMIMaterial(this.cmiMaterial);
        cm.setMaterial(this.material);
        cm.setItemStack(this.item != null ? this.item.clone() : null);
        return cm;
    }

    @Deprecated
    public int getId() {
        return this.id;
    }

    @Deprecated
    public void setId(Integer id) {
        this.id = id;
    }

    @Deprecated
    public short getData() {
        return this.data;
    }

    public boolean isTool() {
        return this.getMaxDurability() > 0;
    }

    public boolean isArmor() {
        if (this.getCMIType() != null && this.getCMIType().isArmor()) {
            return true;
        }
        return CMIMaterial.isArmor(this.getType());
    }

    public short getDurability() {
        return this.getItemStack().getDurability();
    }

    public short getMaxDurability() {
        return this.material.getMaxDurability();
    }

    public void setData(short data) {
        this.data = data;
        if (this.getCMIType() != null) {
            ItemMeta meta = null;
            if (this.item != null && this.item.hasItemMeta()) {
                meta = this.item.getItemMeta();
            }
            this.item = null;
            if (meta != null && this.getItemStack() != null) {
                this.getItemStack().setItemMeta(meta);
            }
        }
    }

    public CMIItemStack setUnbreakable(Boolean state) {
        if (state == null) {
            return this;
        }
        this.item = (ItemStack)new CMINBT(this.getItemStack()).setByte("Unbreakable", state != false ? (byte)1 : 0);
        return this;
    }

    public CMIItemStack addAttributes(List<Attribute> attList) {
        if (attList == null || attList.isEmpty()) {
            return this;
        }
        this.item = CMILib.getInstance().getReflectionManager().addAttributes(attList, this.getItemStack());
        return this;
    }

    public CMIItemStack setTag(String tag) {
        if (tag == null || tag.isEmpty()) {
            return this;
        }
        this.item = CMINBT.modifyItemStack(this.getItemStack(), tag);
        return this;
    }

    public CMIItemStack setDisplayName(String name) {
        ItemMeta meta = this.getItemStack().getItemMeta();
        if (meta != null) {
            if (name == null) {
                meta.setDisplayName(null);
            } else {
                meta.setDisplayName(CMIChatColor.translate(name));
            }
        }
        this.getItemStack().setItemMeta(meta);
        return this;
    }

    public String getDisplayName() {
        ItemMeta meta = this.getItemStack().getItemMeta();
        return meta == null || meta.getDisplayName() == null || meta.getDisplayName().isEmpty() ? this.getRealName() : meta.getDisplayName();
    }

    public CMIItemStack addLore(String string) {
        if (string == null) {
            return this;
        }
        ItemMeta meta = this.getItemStack().getItemMeta();
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        lore.add(CMIChatColor.translate(string));
        meta.setLore(lore);
        this.getItemStack().setItemMeta(meta);
        return this;
    }

    public CMIItemStack clearLore() {
        ItemMeta meta = this.getItemStack().getItemMeta();
        if (meta != null) {
            ArrayList t = new ArrayList();
            meta.setLore(t);
            this.getItemStack().setItemMeta(meta);
        }
        return this;
    }

    public CMIItemStack setLore(List<String> lore) {
        if (lore == null || lore.isEmpty()) {
            return this;
        }
        ItemMeta meta = this.getItemStack().getItemMeta();
        ArrayList<String> t = new ArrayList<String>();
        for (String one : lore) {
            t.add(CMIChatColor.translate(one));
        }
        meta.setLore(t);
        this.getItemStack().setItemMeta(meta);
        return this;
    }

    public CMIItemStack addEnchant(Enchantment enchant, Integer level) {
        if (enchant == null) {
            return this;
        }
        if (this.getItemStack().getItemMeta() instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)this.getItemStack().getItemMeta();
            meta.addStoredEnchant(enchant, level.intValue(), true);
            this.getItemStack().setItemMeta((ItemMeta)meta);
        } else {
            ItemMeta meta = this.getItemStack().getItemMeta();
            meta.addEnchant(enchant, level.intValue(), true);
            this.getItemStack().setItemMeta(meta);
        }
        return this;
    }

    public CMIItemStack addEnchant(HashMap<Enchantment, Integer> enchants) {
        if (enchants == null || enchants.isEmpty()) {
            return this;
        }
        for (Map.Entry<Enchantment, Integer> oneEnch : enchants.entrySet()) {
            this.addEnchant(oneEnch.getKey(), oneEnch.getValue());
        }
        return this;
    }

    public CMIItemStack clearEnchants() {
        ItemMeta meta = this.getItemStack().getItemMeta();
        meta.getEnchants().clear();
        this.getItemStack().setItemMeta(meta);
        return this;
    }

    public List<String> getLore() {
        ItemMeta meta = this.getItemStack().getItemMeta();
        if (meta != null) {
            ArrayList lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList();
                meta.setLore(lore);
            }
            return meta.getLore() == null ? new ArrayList() : meta.getLore();
        }
        return new ArrayList<String>();
    }

    public String getRealName() {
        return this.getCMIType() == null || this.getCMIType() == CMIMaterial.NONE ? this.getType().name() : (this.getCMIType().getTranslatedName() != null ? this.getCMIType().getTranslatedName() : this.getCMIType().getName());
    }

    public String getBukkitName() {
        return this.bukkitName == null || this.bukkitName.isEmpty() ? null : this.bukkitName;
    }

    public void setBukkitName(String bukkitName) {
        this.bukkitName = bukkitName;
    }

    public String getMojangName() {
        return this.mojangName == null || this.mojangName.isEmpty() ? this.getCMIType().getMaterial().name() : this.mojangName;
    }

    public void setMojangName(String mojangName) {
        if (mojangName != null) {
            this.mojangName = mojangName.replace("minecraft:", "");
        }
    }

    public Material getType() {
        if (this.material == null && this.cmiMaterial != null) {
            return this.cmiMaterial.getMaterial();
        }
        return this.material;
    }

    public CMIMaterial getCMIType() {
        return this.cmiMaterial == null ? CMIMaterial.get(this.material) : this.cmiMaterial;
    }

    @Deprecated
    public Material getMaterial() {
        return this.getType();
    }

    public void setMaterial(Material material) {
        this.cmiMaterial = CMIMaterial.get(material);
        this.material = material;
    }

    public void setCMIMaterial(CMIMaterial material) {
        this.cmiMaterial = material;
        this.material = material == null ? null : material.getMaterial();
    }

    private void setEnt() {
        if (this.cmiMaterial.isMonsterEgg()) {
            if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                this.item = this.item == null ? new ItemStack(this.getType()) : this.item;
                this.item.setAmount(this.getAmount());
            } else {
                ItemStack itemStack = this.item == null ? new ItemStack(this.getType(), this.amount == 0 ? 1 : this.amount, this.data == 0 ? (short)90 : (short)this.data) : (this.item = this.item);
            }
            if (this.getEntityType() != null) {
                this.item = CMILib.getInstance().getReflectionManager().setEggType(this.item, this.getEntityType());
            } else {
                CMIEntityType type = CMIEntityType.getById(this.data);
                if (type != null && !Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                    this.item = CMILib.getInstance().getReflectionManager().setEggType(this.item, type.getType());
                }
            }
        } else if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            this.item = this.item == null ? new ItemStack(this.getType()) : this.item;
            this.item.setAmount(this.getAmount());
            if (this.getType().equals((Object)CMIMaterial.SPAWNER.getMaterial())) {
                if (this.getEntityType() != null) {
                    this.item = CMIEntity.setEntityType(this.item, this.getEntityType());
                } else if (Version.isCurrentEqualOrLower(Version.v1_19_R2)) {
                    this.item = CMIEntity.setEntityType(this.item, CMIEntityType.getById(this.data == 0 ? 90 : (int)this.data).getType());
                }
            }
        } else {
            this.item = new ItemStack(this.getType(), this.amount == 0 ? 1 : this.amount, this.data);
        }
    }

    public ItemStack getItemStack() {
        if (this.item == null) {
            try {
                if (!this.getType().isItem()) {
                    return null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.setEnt();
            if (this.item == null) {
                return null;
            }
            if (this.getCMIType().isPotion() || this.item.getType().name().contains("SPLASH_POTION") || this.item.getType().name().contains("TIPPED_ARROW")) {
                PotionMeta potion = (PotionMeta)this.item.getItemMeta();
                PotionEffectType effect = PotionEffectType.getById((int)this.data);
                if (effect != null) {
                    potion.addCustomEffect(new PotionEffect(effect, 60, 0), true);
                }
                this.item.setItemMeta((ItemMeta)potion);
                this.item.setDurability((short)0);
                potion = (PotionMeta)this.item.getItemMeta();
                potion.setDisplayName(this.getRealName());
                this.item.setItemMeta((ItemMeta)potion);
            }
            this.applyEntityType();
            if (this.durability > 0) {
                if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                    Damageable damage = (Damageable)this.item.getItemMeta();
                    damage.setDamage(this.item.getType().getMaxDurability() - this.durability);
                } else {
                    this.item.setDurability(this.durability);
                }
            }
        }
        return this.item;
    }

    private void applyEntityType() {
        CMIEntityType type;
        if (!CMIMaterial.SPAWNER.equals((Object)this.getCMIType())) {
            return;
        }
        if (this.data == 0) {
            this.data = (short)90;
        }
        if ((type = this.entityType) == null && Version.isCurrentEqualOrLower(Version.v1_19_R2)) {
            type = CMIEntityType.getById(this.data);
        }
        if (type != null) {
            this.item = CMIEntity.setEntityType(this.getItemStack(), type.getType());
        }
    }

    public CMIItemStack setItemStack(ItemStack item) {
        this.item = item;
        if (item != null) {
            this.amount = item.getAmount();
            this.material = item.getType();
            this.cmiMaterial = CMIMaterial.get(item);
            if (Version.isCurrentEqualOrLower(Version.v1_13_R2)) {
                this.id = item.getType().getId();
                if (this.getType().isBlock() || this.getType().isSolid()) {
                    this.data = item.getData().getData();
                }
                if (item.getType().getMaxDurability() - item.getDurability() < 0) {
                    this.data = item.getData().getData();
                }
            } else if (this.cmiMaterial != null) {
                this.id = this.cmiMaterial.getId();
            }
            if (item.getType().getMaxDurability() > 15) {
                this.data = 0;
            }
            if (CMIMaterial.isMonsterEgg(item.getType())) {
                this.entityType = CMIEntityType.getByType(CMILib.getInstance().getReflectionManager().getEggType(item));
            }
            if (item.getType() == Material.POTION || item.getType().name().contains("SPLASH_POTION") || item.getType().name().contains("TIPPED_ARROW")) {
                PotionMeta potion = (PotionMeta)item.getItemMeta();
                try {
                    if (potion != null && potion.getBasePotionData() != null && potion.getBasePotionData().getType() != null && potion.getBasePotionData().getType().getEffectType() != null) {
                        this.data = (short)potion.getBasePotionData().getType().getEffectType().getId();
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    public int getAmount() {
        return this.amount <= 0 ? 1 : this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        if (this.item != null) {
            this.item.setAmount(this.amount == 0 ? this.item.getAmount() : this.amount);
        }
    }

    public boolean isSimilar(ItemStack item) {
        return this.isSimilar(CMILib.getInstance().getItemManager().getItem(item));
    }

    public boolean isSimilar(CMIItemStack item) {
        if (item == null) {
            return false;
        }
        try {
            if ((item.getCMIType().isPotion() || item.getCMIType().equals((Object)CMIMaterial.TIPPED_ARROW)) && (this.getCMIType().isPotion() || this.getCMIType().equals((Object)CMIMaterial.TIPPED_ARROW)) && this.getType().equals((Object)item.getType())) {
                PotionMeta potion = (PotionMeta)item.getItemStack().getItemMeta();
                PotionMeta potion2 = (PotionMeta)this.getItemStack().getItemMeta();
                try {
                    PotionData base2;
                    PotionData base1;
                    return potion != null && potion.getBasePotionData() != null && (base1 = potion.getBasePotionData()).getType() != null && potion2 != null && potion2.getBasePotionData() != null && (base2 = potion2.getBasePotionData()).getType() != null && base1.getType().equals((Object)base2.getType()) && base1.isExtended() == base2.isExtended() && base1.isUpgraded() == base2.isUpgraded();
                }
                catch (NoSuchMethodError base1) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.getItemStack().getItemMeta() instanceof EnchantmentStorageMeta && item.getItemStack().getItemMeta() instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta meta1 = (EnchantmentStorageMeta)this.getItemStack().getItemMeta();
                EnchantmentStorageMeta meta2 = (EnchantmentStorageMeta)item.getItemStack().getItemMeta();
                for (Map.Entry one : meta1.getEnchants().entrySet()) {
                    if (meta2.getEnchants().containsKey(one.getKey()) && meta2.getEnchants().get(one.getKey()) == one.getValue()) continue;
                    return false;
                }
                for (Map.Entry one : meta1.getStoredEnchants().entrySet()) {
                    if (meta2.getStoredEnchants().containsKey(one.getKey()) && meta2.getStoredEnchants().get(one.getKey()) == one.getValue()) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ((item.getCMIType() == CMIMaterial.SPAWNER || item.getCMIType().isMonsterEgg()) && (this.getCMIType() == CMIMaterial.SPAWNER || this.getCMIType().isMonsterEgg())) {
            if (this.cmiMaterial != item.cmiMaterial) {
                return false;
            }
            return this.getEntityType() == item.getEntityType();
        }
        if (item.getCMIType() == CMIMaterial.PLAYER_HEAD && this.getCMIType() == CMIMaterial.PLAYER_HEAD) {
            try {
                String base1 = null;
                try {
                    CMINBT nbt = new CMINBT(this.getItemStack());
                    List<String> ls = nbt.getList("SkullOwner.Properties.textures");
                    if (ls != null) {
                        base1 = ls.get(0);
                    }
                }
                catch (Throwable nbt) {
                    // empty catch block
                }
                String base2 = null;
                try {
                    CMINBT nbt = new CMINBT(item.getItemStack());
                    List<String> ls = nbt.getList("SkullOwner.Properties.textures");
                    if (ls != null) {
                        base2 = ls.get(0);
                    }
                }
                catch (Throwable nbt) {
                    // empty catch block
                }
                if (base1 != null && base2 == null || base1 == null && base2 != null || base1 != null && base2 != null && !base1.equals(base2)) {
                    SkullMeta skullMeta = (SkullMeta)item.getItemStack().getItemMeta();
                    SkullMeta skullMeta2 = (SkullMeta)this.getItemStack().getItemMeta();
                    if (skullMeta.getOwner() != null && skullMeta2.getOwner() == null || skullMeta.getOwner() == null && skullMeta2.getOwner() != null) {
                        return false;
                    }
                    if (skullMeta.getOwner() != null && skullMeta2.getOwner() != null && !skullMeta.getOwner().equals(skullMeta2.getOwner())) {
                        return false;
                    }
                    return false;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            return this.cmiMaterial == item.cmiMaterial;
        }
        return this.cmiMaterial == item.cmiMaterial && this.getData() == item.getData();
    }

    public EntityType getEntityType() {
        if (this.getItemStack() == null) {
            return null;
        }
        if (this.entityType != null) {
            return this.entityType.getType();
        }
        ItemStack is = this.getItemStack().clone();
        if (Version.isCurrentEqualOrHigher(Version.v1_8_R1) && is.getItemMeta() instanceof BlockStateMeta) {
            CMINBT nbt;
            if (Version.isCurrentEqualOrHigher(Version.v1_19_R3) && !(nbt = new CMINBT(is)).hasNBT("BlockEntityTag")) {
                return null;
            }
            BlockStateMeta bsm = (BlockStateMeta)is.getItemMeta();
            if (bsm.getBlockState() instanceof CreatureSpawner) {
                CreatureSpawner bs = (CreatureSpawner)bsm.getBlockState();
                try {
                    return bs.getSpawnedType();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        if (CMIMaterial.isMonsterEgg(is.getType())) {
            return CMILib.getInstance().getReflectionManager().getEggType(is);
        }
        if (CMIMaterial.get(is) != null && CMIMaterial.get(is).isMonsterEgg()) {
            return CMILib.getInstance().getReflectionManager().getEggType(is);
        }
        if (Version.isCurrentEqualOrLower(Version.v1_12_R1)) {
            return EntityType.fromId((int)is.getData().getData());
        }
        return null;
    }

    public boolean hasNbtTag() {
        return new CMINBT(this.getItemStack()).hasNBT();
    }

    public CMIItemStack setNbt(String path, String value) {
        ItemStack it = this.getItemStack();
        this.item = it = (ItemStack)new CMINBT(it).setString(path, value);
        return this;
    }

    public CMIItemStack setNbt(String path, int value) {
        ItemStack it = this.getItemStack();
        this.item = it = (ItemStack)new CMINBT(it).setInt(path, value);
        return this;
    }

    public CMIItemStack setNbt(String path, boolean value) {
        ItemStack it = this.getItemStack();
        ItemMeta meta = (it = (ItemStack)new CMINBT(it).setBoolean(path, value)).getItemMeta();
        if (meta != null) {
            this.getItemStack().setItemMeta(meta);
        }
        return this;
    }

    public String getNbtString(String path) {
        return new CMINBT(this.getItemStack()).getString(path);
    }

    public Integer getNbtInt(String path) {
        return new CMINBT(this.getItemStack()).getInt(path);
    }

    public Boolean getNbtBoolean(String path) {
        return new CMINBT(this.getItemStack()).getBoolean(path);
    }

    public List<Recipe> getRecipesFor() {
        CMIMaterial colorMat;
        if (this.getItemStack() == null) {
            return new ArrayList<Recipe>();
        }
        ItemStack i = this.getItemStack().clone();
        if (Version.isCurrentLower(Version.v1_13_R1)) {
            i.getData().setData((byte)this.data);
        }
        if (i.getType().getMaxDurability() > 15) {
            i.setDurability((short)0);
        }
        ArrayList<Recipe> recipes = new ArrayList();
        try {
            recipes = Bukkit.getRecipesFor((ItemStack)i);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.getCMIType().isShulkerBox() && (colorMat = CMIColors.getColorMaterial(this.getCMIType())) != null) {
            HashMap<Integer, CMIRecipeIngredient> Recipe2 = new HashMap<Integer, CMIRecipeIngredient>();
            Recipe2.put(1, new CMIRecipeIngredient(CMIMaterial.SHULKER_BOX.newItemStack()));
            Recipe2.put(2, new CMIRecipeIngredient(colorMat.newItemStack()));
            Recipe rec = CMIRecipe.makeShaplessRecipe(this.getItemStack(), Recipe2);
            if (rec != null) {
                recipes.add(rec);
            }
            for (CMIMaterial one : CMIMaterial.values()) {
                CMIMaterial c;
                if (!one.isShulkerBox() || (c = CMIColors.getColorMaterial(one)) == null || c.equals((Object)colorMat)) continue;
                Recipe2.put(1, new CMIRecipeIngredient(one.newItemStack()));
                Recipe2.put(2, new CMIRecipeIngredient(colorMat.newItemStack()));
                rec = CMIRecipe.makeShaplessRecipe(this.getItemStack(), Recipe2);
                if (rec == null) continue;
                recipes.add(rec);
            }
        }
        if (this.getCMIType().equals((Object)CMIMaterial.FIREWORK_ROCKET)) {
            HashMap<Integer, CMIRecipeIngredient> Recipe3 = new HashMap<Integer, CMIRecipeIngredient>();
            Recipe3.put(1, new CMIRecipeIngredient(CMIMaterial.PAPER.newItemStack()));
            Recipe3.put(2, new CMIRecipeIngredient(CMIMaterial.GUNPOWDER.newItemStack()));
            Recipe rec = CMIRecipe.makeShaplessRecipe(this.getItemStack(), Recipe3);
            if (rec != null) {
                recipes.add(rec);
            }
            Recipe3.put(3, new CMIRecipeIngredient(CMIMaterial.GUNPOWDER.newItemStack()));
            rec = CMIRecipe.makeShaplessRecipe(this.getItemStack(), Recipe3);
            if (rec != null) {
                recipes.add(rec);
            }
            Recipe3.put(4, new CMIRecipeIngredient(CMIMaterial.GUNPOWDER.newItemStack()));
            rec = CMIRecipe.makeShaplessRecipe(this.getItemStack(), Recipe3);
            if (rec != null) {
                recipes.add(rec);
            }
            Recipe3.put(5, new CMIRecipeIngredient(CMIMaterial.FIREWORK_STAR.newItemStack()));
            rec = CMIRecipe.makeShaplessRecipe(this.getItemStack(), Recipe3);
            if (rec != null) {
                recipes.add(rec);
            }
        }
        return recipes;
    }

    public List<Recipe> getRecipesFrom() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        ItemStack i = this.getItemStack();
        if (i == null) {
            return recipes;
        }
        i = i.clone();
        if (Version.isCurrentLower(Version.v1_13_R1)) {
            i.getData().setData((byte)this.data);
        }
        if (i.getType().getMaxDurability() > 15) {
            i.setDurability((short)0);
        }
        Iterator it = Bukkit.recipeIterator();
        block0: while (it.hasNext()) {
            ShapelessRecipe srec;
            Recipe rec = (Recipe)it.next();
            if (rec == null) continue;
            for (ItemStack one : CMIRecipe.getIngredientsList(rec)) {
                if (one.getType() != i.getType() || one.getDurability() != -1 && one.getDurability() != Short.MAX_VALUE && one.getDurability() != i.getDurability()) continue;
                recipes.add(rec);
                break;
            }
            if (rec instanceof ShapelessRecipe) {
                srec = (ShapelessRecipe)rec;
                for (RecipeChoice one : srec.getChoiceList()) {
                    if (one == null || !one.test(i)) continue;
                    recipes.add(rec);
                    continue block0;
                }
                continue;
            }
            if (!(rec instanceof ShapedRecipe)) continue;
            srec = (ShapedRecipe)rec;
            for (RecipeChoice one : srec.getChoiceMap().values()) {
                if (one == null || !one.test(i)) continue;
                recipes.add(rec);
                continue block0;
            }
        }
        return recipes;
    }

    public void setDurability(short durability) {
        this.durability = durability;
    }

    public Set<Enchantment> getValidEnchants() {
        HashSet<Enchantment> enchants = new HashSet<Enchantment>();
        for (Enchantment one : CMIEnchantment.values()) {
            if (!CMIEnchantment.isEnabled(one) || !one.canEnchantItem(this.getItemStack())) continue;
            enchants.add(one);
        }
        return enchants;
    }

    public String toOneLiner() {
        return CMIItemSerializer.toOneLiner(this);
    }

    public static ItemStack getHead(String texture) {
        ItemStack cached;
        if (texture == null || texture.isEmpty()) {
            return null;
        }
        if (texture.length() < 120) {
            texture = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUv" + texture;
        }
        if ((cached = CMIEntityType.cache.get(texture)) != null) {
            return cached.clone();
        }
        ItemStack item = CMIMaterial.PLAYER_HEAD.newItemStack();
        item = CMILib.getInstance().getReflectionManager().setSkullTexture(item, null, texture);
        CMIEntityType.cache.put(texture, item);
        return item.clone();
    }

    public void setEntityType(CMIEntityType entityType) {
        this.entityType = entityType;
        this.applyEntityType();
    }

    public void setEntityType(EntityType entityType) {
        this.setEntityType(CMIEntityType.getByType(entityType));
    }

    public static ItemStack getItemInMainHand(Player player) {
        return CMILib.getInstance().getReflectionManager().getItemInMainHand(player);
    }

    public static ItemStack getItemInOffHand(Player player) {
        return CMILib.getInstance().getReflectionManager().getItemInOffHand(player);
    }

    public static void setItemInMainHand(Player player, ItemStack item) {
        CMILib.getInstance().getReflectionManager().setItemInMainHand(player, item);
    }

    public static void setItemInOffHand(Player player, ItemStack item) {
        CMILib.getInstance().getReflectionManager().setItemInOffHand(player, item);
    }

    public static CMIItemStack deserialize(String input) {
        return CMIItemSerializer.deserialize(null, input, null);
    }

    public static CMIItemStack deserialize(String input, CMIAsyncHead ahead) {
        return CMIItemSerializer.deserialize(null, input, ahead);
    }

    public static CMIItemStack deserialize(CommandSender sender, String input) {
        return CMIItemSerializer.deserialize(sender, input, null);
    }

    public static CMIItemStack deserialize(CommandSender sender, String input, CMIAsyncHead ahead) {
        return CMIItemSerializer.deserialize(sender, input, ahead);
    }

    public static String serialize(ItemStack item) {
        return CMIItemSerializer.serialize(item);
    }
}

