/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Placeholders;

import com.Zrips.CMI.CMI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Chat.ChatFilterRule;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Messages.CMIMessages;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Placeholder {
    private CMILib plugin;
    Pattern placeholderKeepPatern = Pattern.compile("(\\%\\%)([^\\\"^\\%^ ]+)(\\%\\%)(\\B)");
    Pattern placeholderOthersKeepPatern = Pattern.compile("(?i)(\\%parseother_)((\\{)([^\\\"^\\%^ ^\\{^\\}]+)(\\}))([^(\\}\\%).]+)(\\}\\%)");
    Pattern placeholderPatern = Pattern.compile("(%)([^\"^%^ ]+)(%)");
    Pattern placeholderPatern2 = Pattern.compile("(\\{)([^\"^%^ ^{^}]+)(\\})");
    private static ChatFilterRule numericalRule = new ChatFilterRule().setPattern("(\\$)(\\d)");
    Random random = new Random(System.nanoTime());
    private HashMap<String, String> randomCache = new HashMap();

    public Placeholder(CMILib plugin) {
        this.plugin = plugin;
    }

    public List<String> updatePlaceHolders(Player player, List<String> messages) {
        ArrayList<String> ms = new ArrayList<String>(messages);
        int l = messages.size();
        for (int i = 0; i < l; ++i) {
            ms.set(i, this.updatePlaceHolders(player, messages.get(i)));
        }
        return ms;
    }

    private void reportIssue() {
        CMIMessages.consoleMessage("&cPlaceholder got blocked due to security concerns (%checkitem%)");
    }

    public CMIPlaceholderType getPlaceHolderType(Player player, String placeholder) {
        if (placeholder == null) {
            return null;
        }
        if (placeholder.contains("%") && !placeholder.equals(this.translateOwnPlaceHolder(player, placeholder))) {
            return CMIPlaceholderType.CMI;
        }
        if (placeholder.contains("{") && !placeholder.equals(this.translateOwnPlaceHolder(player, placeholder))) {
            return CMIPlaceholderType.CMI;
        }
        if (this.plugin.isPlaceholderAPIEnabled()) {
            try {
                if (placeholder.contains("%")) {
                    if (!placeholder.toLowerCase().contains("%checkitem")) {
                        if (!placeholder.equals(PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder))) {
                            return CMIPlaceholderType.PAPI;
                        }
                    } else {
                        this.reportIssue();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public String updatePlaceHolders(UUID uuid, String message) {
        if (message == null) {
            return null;
        }
        if (message.contains("{")) {
            message = this.translateOwnPlaceHolder(uuid, message);
        }
        if (message.contains("%")) {
            message = this.translateOwnPlaceHolder(uuid, message);
        }
        if (this.plugin.isPlaceholderAPIEnabled()) {
            try {
                if (message.contains("%")) {
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    if (!message.toLowerCase().contains("%checkitem")) {
                        message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
                    } else {
                        this.reportIssue();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return message;
    }

    public String updatePlaceHolders(String message) {
        UUID uuid = null;
        return this.updatePlaceHolders(uuid, message);
    }

    public String updatePlaceHolders(Player player, String message) {
        if (message == null) {
            return null;
        }
        HashMap<String, String> temp = new HashMap<String, String>();
        if (message.contains("{")) {
            Matcher match = this.placeholderOthersKeepPatern.matcher(message);
            while (match.find()) {
                try {
                    if (!message.contains("%")) break;
                    String group = match.group();
                    int id = new Random().nextInt(Integer.MAX_VALUE);
                    String with = "|" + id + "|";
                    temp.put(with, group);
                    message = message.replaceFirst(Matcher.quoteReplacement(group), Matcher.quoteReplacement(with));
                }
                catch (Throwable throwable) {}
            }
            if ((message = this.translateOwnPlaceHolder(player, message)).contains("%")) {
                message = this.translateOwnPlaceHolder(player, message);
            }
            for (Map.Entry one : temp.entrySet()) {
                message = message.replace((CharSequence)one.getKey(), (CharSequence)one.getValue());
            }
        } else if (message.contains("%")) {
            message = this.translateOwnPlaceHolder(player, message);
        }
        if (this.plugin.isPlaceholderAPIEnabled()) {
            try {
                if (message.contains("%")) {
                    if (!message.toLowerCase().contains("%checkitem")) {
                        message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
                    } else {
                        this.reportIssue();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return message;
    }

    public boolean containsPlaceHolder(String msg) {
        Matcher match = this.placeholderPatern.matcher(msg);
        if (match.find()) {
            return true;
        }
        match = this.placeholderPatern2.matcher(msg);
        return match.find();
    }

    public String translateOwnPlaceHolder(Player player, String message) {
        return this.translateOwnPlaceHolder(player == null ? null : player.getUniqueId(), message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String matchInception(UUID uuid, String message, int depth) {
        if (!message.contains("{")) return message;
        Matcher match = this.placeholderPatern2.matcher(message);
        int i = 0;
        try {
            while (match.find()) {
                if (++i > 10) {
                    return message;
                }
                String cmd = match.group(2);
                if (!message.contains("{")) {
                    return message;
                }
                CMIPlaceHolders place = CMIPlaceHolders.getByNameExact(cmd);
                if (place == null) {
                    if (!this.plugin.isPlaceholderAPIEnabled()) continue;
                    try {
                        Player player = Bukkit.getPlayer((UUID)uuid);
                        String group = match.group();
                        if (group.startsWith("{#")) continue;
                        if (!cmd.toLowerCase().contains("checkitem")) {
                            String with = PlaceholderAPI.setPlaceholders((Player)player, (String)("%" + cmd + "%"));
                            if (with == null) {
                                with = "";
                            }
                            if (with.equalsIgnoreCase("%" + cmd + "%")) continue;
                            message = message.replaceFirst(Pattern.quote(group), Matcher.quoteReplacement(with));
                            continue;
                        }
                        this.reportIssue();
                    }
                    catch (Exception player) {}
                    continue;
                }
                String group = match.group();
                String with = this.getValue(uuid, place, group);
                if (with == null) {
                    with = "";
                }
                message = message.replaceFirst(Matcher.quoteReplacement(group), Matcher.quoteReplacement(with));
            }
            return message;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return message;
    }

    public String translateOwnPlaceHolder(UUID uuid, String message) {
        String with;
        HashMap<String, Object> temp;
        if (message == null) {
            return null;
        }
        if (CMILib.getInstance().isCmiPresent()) {
            try {
                message = CMI.getInstance().getPlaceholderAPIManager().translateOwnPlaceHolder(uuid, message);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (message.contains("{")) {
            temp = new HashMap<String, Object>();
            Matcher match = this.placeholderOthersKeepPatern.matcher(message);
            while (match.find()) {
                try {
                    if (!message.contains("%")) break;
                    String group2 = match.group();
                    int n = new Random().nextInt(Integer.MAX_VALUE);
                    with = "|" + n + "|";
                    temp.put(with, group2);
                    message = message.replaceFirst(Matcher.quoteReplacement(group2), Matcher.quoteReplacement(with));
                }
                catch (Throwable group2) {}
            }
            message = this.matchInception(uuid, message, 0);
            for (Map.Entry entry : temp.entrySet()) {
                message = message.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        if (message.contains("%")) {
            temp = new HashMap();
            Matcher matchKeep = this.placeholderKeepPatern.matcher(message);
            while (matchKeep.find()) {
                try {
                    if (!message.contains("%")) break;
                    String group3 = matchKeep.group();
                    int n = new Random().nextInt(Integer.MAX_VALUE);
                    with = "|" + n + "|";
                    temp.put(with, group3.substring(1, group3.length() - 1));
                    message = message.replaceFirst(Matcher.quoteReplacement(group3), Matcher.quoteReplacement(with));
                }
                catch (Throwable group3) {}
            }
            Matcher match = this.placeholderPatern.matcher(message);
            while (match.find()) {
                try {
                    String string = match.group(2);
                    if (!message.contains("%")) break;
                    CMIPlaceHolders place = CMIPlaceHolders.getByNameExact(string);
                    if (place == null) continue;
                    String group4 = match.group();
                    String with2 = this.getValue(uuid, place, group4);
                    if (with2 == null) {
                        with2 = "";
                    }
                    message = message.replaceFirst(Pattern.quote(group4), Matcher.quoteReplacement(with2));
                }
                catch (Throwable throwable) {}
            }
            for (Map.Entry one : temp.entrySet()) {
                message = message.replace((CharSequence)one.getKey(), (CharSequence)one.getValue());
            }
        }
        return message;
    }

    public String getValue(Player player, CMIPlaceHolders placeHolder) {
        return this.getValue(player, placeHolder, null);
    }

    public String getValue(Player player, CMIPlaceHolders placeHolder, String value) {
        return this.getValue(player != null ? player.getUniqueId() : null, placeHolder, value);
    }

    public String getValue(UUID uuid, CMIPlaceHolders placeHolder, String value) {
        return null;
    }

    private void informFailed(String value) {
        CMIMessages.consoleMessage("&cInccorrect placeholder format for " + value);
    }

    private String variable(Boolean state) {
        return state != false ? CMIMessages.getMsg(LC.info_variables_True, new Object[0]) : CMIMessages.getMsg(LC.info_variables_False, new Object[0]);
    }

    public static enum CMIPlaceholderType {
        CMI,
        PAPI,
        MVdW;

    }

    public static final class CMIPlaceHolders
    extends Enum<CMIPlaceHolders> {
        static LinkedHashMap<String, CMIPlaceHolders> byNameStatic;
        static LinkedHashMap<String, LinkedHashSet<CMIPlaceHolders>> byNameComplex;
        private String[] vars;
        private List<Integer> groups = new ArrayList<Integer>();
        private ChatFilterRule rule = null;
        private boolean hidden = false;
        private String desc = null;
        private static final /* synthetic */ CMIPlaceHolders[] $VALUES;

        public static CMIPlaceHolders[] values() {
            return (CMIPlaceHolders[])$VALUES.clone();
        }

        public static CMIPlaceHolders valueOf(String name) {
            return Enum.valueOf(CMIPlaceHolders.class, name);
        }

        private CMIPlaceHolders() {
        }

        private CMIPlaceHolders(boolean hideen) {
            this(null, hideen, new String[0]);
        }

        private CMIPlaceHolders(String desc, String ... vars) {
            this(desc, false, vars);
        }

        private CMIPlaceHolders(String desc, boolean hidden, String ... vars) {
            this.desc = desc;
            this.vars = vars;
            this.hidden = hidden;
            try {
                Matcher matcher = numericalRule.getMatcher(this.toString());
                if (matcher != null) {
                    this.rule = new ChatFilterRule();
                    ArrayList<String> ls = new ArrayList<String>();
                    ls.add("(%)" + this.toString().replaceAll("\\$\\d", "([^\"^%]*)") + "(%)");
                    ls.add("(\\{)" + this.toString().replaceAll("\\$\\d", "([^\"^%]*)") + "(\\})");
                    this.rule.setPattern(ls);
                    while (matcher.find()) {
                        try {
                            int id = Integer.parseInt(matcher.group(2));
                            this.groups.add(id);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }

        public static CMIPlaceHolders getByName(String name) {
            if (name.startsWith("%") || name.startsWith("{")) {
                name = name.replace("%", "").replace("{", "").replace("}", "");
            }
            String original = name;
            CMIPlaceHolders got = byNameStatic.get(name);
            if (got != null) {
                return got;
            }
            String[] split = name.split("_");
            if (split.length < 3) {
                return null;
            }
            String prefix = split[0] + "_" + split[1];
            Set main = byNameComplex.get(prefix);
            if (main == null) {
                return null;
            }
            for (CMIPlaceHolders mainOne : main) {
                if (mainOne.getComplexRegexMatchers(original).isEmpty()) continue;
                return mainOne;
            }
            return null;
        }

        public static CMIPlaceHolders getByNameExact(String name) {
            return CMIPlaceHolders.getByName(name);
        }

        public String getFull() {
            if (this.isComplex()) {
                String name = this.name();
                int i = 0;
                for (String one : this.name().split("_")) {
                    if (!one.startsWith("$")) continue;
                    if (this.vars.length >= i - 1) {
                        name = name.replace(one, "[" + this.vars[i] + "]");
                    }
                    ++i;
                }
                return "%" + name + "%";
            }
            return "%" + this.name() + "%";
        }

        public String getMVdW() {
            if (this.isComplex()) {
                String name = this.name();
                int i = 0;
                for (String one : this.name().split("_")) {
                    if (!one.startsWith("$")) continue;
                    if (this.vars.length >= i - 1) {
                        name = name.replace(one, "*");
                    }
                    ++i;
                }
                return name;
            }
            return this.name();
        }

        public List<String> getComplexRegexMatchers(String text) {
            Matcher matcher;
            ArrayList<String> lsInLs = new ArrayList<String>();
            if (!this.isComplex()) {
                return lsInLs;
            }
            if (!text.startsWith("%") && !text.endsWith("%")) {
                text = "%" + text + "%";
            }
            if ((matcher = this.getRule().getMatcher(text)) == null) {
                return lsInLs;
            }
            while (matcher.find()) {
                lsInLs.add(matcher.group());
            }
            return lsInLs;
        }

        public List<String> getComplexValues(String text) {
            Matcher matcher;
            ArrayList<String> lsInLs = new ArrayList<String>();
            if (!this.isComplex() || text == null) {
                return lsInLs;
            }
            if (!text.startsWith("%") && !text.endsWith("%")) {
                text = "%" + text + "%";
            }
            if ((matcher = this.getRule().getMatcher(text)) == null) {
                return lsInLs;
            }
            if (matcher.find()) {
                try {
                    for (Integer oneG : this.groups) {
                        lsInLs.add(matcher.group(oneG + 1));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return lsInLs;
        }

        public boolean isComplex() {
            return this.rule != null;
        }

        public ChatFilterRule getRule() {
            return this.rule;
        }

        public void setRule(ChatFilterRule rule) {
            this.rule = rule;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public String getDescription() {
            return this.desc;
        }

        private static /* synthetic */ CMIPlaceHolders[] $values() {
            return new CMIPlaceHolders[0];
        }

        static {
            $VALUES = CMIPlaceHolders.$values();
            byNameStatic = new LinkedHashMap();
            byNameComplex = new LinkedHashMap();
            for (CMIPlaceHolders one : CMIPlaceHolders.values()) {
                String fullName = one.toString();
                if (!one.isComplex()) {
                    byNameStatic.put(fullName.toLowerCase(), one);
                    continue;
                }
                String[] split = fullName.split("_");
                String first = split[0] + "_" + split[1];
                LinkedHashSet<CMIPlaceHolders> old = byNameComplex.getOrDefault(first, new LinkedHashSet());
                old.add(one);
                byNameComplex.put(first, old);
            }
        }
    }
}

